/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaClass;
import com.ibm.dtfj.phd.PHDJavaHeap;
import com.ibm.dtfj.phd.PHDJavaMethod;
import com.ibm.dtfj.phd.PHDJavaObject;
import com.ibm.dtfj.phd.PHDJavaReference;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PHDJavaClass
implements JavaClass {
    private JavaClassLoader loader;
    private String name;
    private final long addr;
    private final long superAddress;
    private final ImageAddressSpace space;
    private final PHDJavaRuntime runtime;
    private Object refs;
    private final int flags;
    private final int hashCode;
    private int size;
    private boolean isPacked;
    private JavaClass componentType;
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private JavaObject classObject;
    private static final int UNKNOWN_SIZE = Integer.MIN_VALUE;
    static final int UNKNOWN_SUPERCLASS = -1;
    static final String UNKNOWN_ARRAY = "[";
    static final String UNKNOWN_NONARRAY = "]";

    public PHDJavaClass(Builder builder) {
        this.space = builder.space;
        this.runtime = builder.runtime;
        this.loader = builder.loader;
        this.addr = builder.addr;
        this.superAddress = builder.superAddress;
        this.name = builder.name;
        this.size = builder.size;
        this.flags = builder.flags;
        this.hashCode = builder.hashCode;
        this.refs = builder.refs;
        this.componentType = builder.componentType;
        this.isPacked = builder.isPacked;
    }

    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this.loader;
    }

    JavaClassLoader setClassLoader(JavaClassLoader jcl) {
        JavaClassLoader ret = this.loader;
        this.loader = jcl;
        return ret;
    }

    public JavaClass getComponentType() throws CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException(this.getName() + " is not an array");
        }
        if (this.componentType == null) {
            String nm = this.getName();
            String compName = nm.startsWith("[[") ? nm.substring(1) : (nm.startsWith("[L") ? nm.substring(2, nm.length() - 1) : (nm.equals("[B") ? "byte" : (nm.equals("[C") ? "char" : (nm.equals("[S") ? "short" : (nm.equals("[I") ? "int" : (nm.equals("[J") ? "long" : (nm.equals("[F") ? "float" : (nm.equals("[D") ? "double" : (nm.equals("[Z") ? "boolean" : "java/lang/Object")))))))));
            this.componentType = this.loader.findClass(compName);
            if (this.componentType == null) {
                this.componentType = new PHDCorruptJavaClass("component type for " + nm + " is " + compName + " which is not found from " + this.loader, this.getID(), null);
            }
        }
        if (this.componentType instanceof CorruptData) {
            throw new CorruptDataException((CorruptData)this.componentType);
        }
        return this.componentType;
    }

    JavaClass setComponentType(JavaClass comp) {
        JavaClass ret = this.componentType;
        if (ret == null) {
            this.componentType = comp;
        }
        return ret;
    }

    public Iterator<JavaObject> getConstantPoolReferences() {
        return Collections.emptyList().iterator();
    }

    public Iterator<JavaField> getDeclaredFields() {
        return Collections.emptyList().iterator();
    }

    public Iterator<JavaMethod> getDeclaredMethods() {
        return this.methods.iterator();
    }

    public ImagePointer getID() {
        return this.addr != 0L ? this.space.getPointer(this.addr) : null;
    }

    public Iterator<String> getInterfaces() {
        return Collections.emptyList().iterator();
    }

    public int getModifiers() throws CorruptDataException {
        return -16777216;
    }

    public String getName() throws CorruptDataException {
        if (this.name == null) {
            throw new CorruptDataException((CorruptData)new PHDCorruptData("No class name available (null)", this.getID()));
        }
        if (this.name.equals(UNKNOWN_ARRAY)) {
            throw new CorruptDataException((CorruptData)new PHDCorruptData("No class name available (unknown array)", this.getID()));
        }
        if (this.name.equals(UNKNOWN_NONARRAY)) {
            throw new CorruptDataException((CorruptData)new PHDCorruptData("No class name available (unknown non-array)", this.getID()));
        }
        return this.name;
    }

    public JavaObject getObject() throws CorruptDataException {
        if (this.addr == 0L) {
            return null;
        }
        if (this.classObject != null) {
            return this.classObject;
        }
        JavaClass jlc = this.runtime.findClass("java/lang/Class");
        if (jlc == null) {
            jlc = this.loader.findClass("java/lang/Class");
        }
        this.classObject = new PHDJavaObject.Builder((PHDJavaHeap)this.runtime.getHeaps().next(), this.addr, jlc, this.flags, this.hashCode).refsAsArray(new long[0], 0).length(-1).build();
        return this.classObject;
    }

    public JavaClass getSuperclass() throws CorruptDataException {
        if (this.superAddress == 0L) {
            return null;
        }
        if (this.superAddress == -1L) {
            throw new CorruptDataException((CorruptData)new PHDCorruptJavaClass("No superclass available", null, null));
        }
        JavaClass sup = this.runtime.findClass(this.superAddress);
        try {
            if (sup != null && "java/lang/Class".equals(sup.getName())) {
                sup = null;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (sup == null) {
            throw new CorruptDataException((CorruptData)new PHDCorruptJavaClass("Superclass not found", this.space.getPointer(this.superAddress), null));
        }
        return sup;
    }

    public boolean isArray() throws CorruptDataException {
        return this.componentType != null || this.name != null && this.name.startsWith(UNKNOWN_ARRAY) || !UNKNOWN_NONARRAY.equals(this.name) && this.getName().startsWith(UNKNOWN_ARRAY);
    }

    public Iterator<JavaReference> getReferences() {
        final PHDJavaClass source = this;
        return new Iterator<JavaReference>(){
            int count;
            JavaClass sup;
            JavaObject load;
            {
                try {
                    this.sup = PHDJavaClass.this.getSuperclass();
                    if (this.sup != null) {
                        this.count = -1;
                    }
                }
                catch (CorruptDataException e) {
                    // empty catch block
                }
                try {
                    this.load = PHDJavaClass.this.loader.getObject();
                    if (this.load != null) {
                        this.count = -2;
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                if (this.count < 0) {
                    return true;
                }
                if (PHDJavaClass.this.refs instanceof LongEnumeration) {
                    LongEnumeration le = (LongEnumeration)PHDJavaClass.this.refs;
                    return le.hasMoreElements();
                }
                if (PHDJavaClass.this.refs instanceof long[]) {
                    long[] arefs = (long[])PHDJavaClass.this.refs;
                    return this.count < arefs.length;
                }
                if (PHDJavaClass.this.refs instanceof int[]) {
                    int[] arefs = (int[])PHDJavaClass.this.refs;
                    return this.count < arefs.length;
                }
                return false;
            }

            @Override
            public JavaReference next() {
                long ref;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("" + this.count++);
                }
                int refType = 0;
                JavaObject cls = null;
                if (this.count == -2) {
                    cls = this.load;
                    ++this.count;
                    if (this.sup == null) {
                        ++this.count;
                    }
                    ref = 0L;
                    refType = 4;
                } else if (this.count == -1) {
                    cls = this.sup;
                    ++this.count;
                    ref = 0L;
                    refType = 10;
                } else {
                    if (PHDJavaClass.this.refs instanceof LongEnumeration) {
                        LongEnumeration le = (LongEnumeration)PHDJavaClass.this.refs;
                        ref = le.nextLong();
                        ++this.count;
                    } else if (PHDJavaClass.this.refs instanceof int[]) {
                        int[] arefs = (int[])PHDJavaClass.this.refs;
                        ref = PHDJavaClass.this.runtime.expandAddress(arefs[this.count++]);
                    } else {
                        long[] arefs = (long[])PHDJavaClass.this.refs;
                        ref = arefs[this.count++];
                    }
                    cls = PHDJavaClass.this.runtime.findClass(ref);
                }
                if (cls != null) {
                    return new PHDJavaReference(cls, source, 1, refType, 0, "?");
                }
                return new PHDJavaReference(new PHDJavaObject.Builder((PHDJavaHeap)PHDJavaClass.this.runtime.getHeaps().next(), ref, null, 4, -1).build(), source, 1, refType, 0, "?");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return "PHDJavaClass " + this.name + "@" + Long.toHexString(this.addr);
    }

    public int hashCode() {
        return (int)this.addr ^ (int)(this.addr >>> 32);
    }

    public long getInstanceSize() throws CorruptDataException {
        if (this.size == Integer.MIN_VALUE) {
            throw new CorruptDataException((CorruptData)new PHDCorruptData("No class size available", this.getID()));
        }
        int header = this.runtime.minInstanceSize == 0 && this.size >= 0 ? (this.runtime.is64Bit() ? 24 : 12) : 0;
        return header + Math.abs(this.size);
    }

    long getArraySize(int length) throws CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException(this.getName() + " is not an array");
        }
        int s1 = 0;
        if (this.name != null) {
            if (this.name.equals("[B") || this.name.equals("[Z")) {
                s1 = 1;
            } else if (this.name.equals("[S") || this.name.equals("[C")) {
                s1 = 2;
            } else if (this.name.equals("[I") || this.name.equals("[F")) {
                s1 = 4;
            } else if (this.name.equals("[D") || this.name.equals("[J")) {
                s1 = 8;
            }
        }
        int prefix = this.runtime.pointerSize() * 2 + (this.runtime.minInstanceSize == 0 && s1 != 0 ? 4 : 8);
        if (s1 == 0) {
            s1 = this.runtime.pointerSize();
        }
        return (long)prefix + (long)length * (long)s1;
    }

    static boolean referencesClass(JavaClass from, JavaClass to) {
        Iterator i1 = from.getReferences();
        while (i1.hasNext()) {
            Object o = i1.next();
            if (o instanceof CorruptData) continue;
            JavaReference jr = (JavaReference)o;
            try {
                if (jr.isClassReference() && jr.getTarget().equals(to)) {
                    return true;
                }
                if (!jr.isObjectReference() || !jr.getTarget().equals(to.getObject())) continue;
                return true;
            }
            catch (DataUnavailable e) {
            }
            catch (CorruptDataException e) {
            }
        }
        return false;
    }

    void addMethod(PHDJavaMethod javaMethod) {
        this.methods.add(javaMethod);
    }

    void setJavaObject(JavaObject obj) {
        this.classObject = obj;
    }

    void setName(String newName) {
        this.name = newName;
    }

    void updateSize(long instanceAddress, long nextObjectAddress) {
        long delta = nextObjectAddress - instanceAddress;
        if (this.size < 0 && delta > 0L && delta < 65536L && -delta > (long)this.size) {
            this.size = -((int)delta);
        }
    }

    public JavaObject getProtectionDomain() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getProtectionDomain");
    }

    public boolean isPacked() {
        return this.isPacked;
    }

    public long getPackedDataSize() throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getPackedDataSize");
    }

    public static class Builder {
        private final ImageAddressSpace space;
        private final PHDJavaRuntime runtime;
        private final JavaClassLoader loader;
        private final long addr;
        private final long superAddress;
        private final String name;
        private int size = Integer.MIN_VALUE;
        private int flags = 4;
        private int hashCode = -1;
        private Object refs = null;
        private JavaClass componentType = null;
        private boolean isPacked = false;

        public Builder(ImageAddressSpace space, PHDJavaRuntime runtime, JavaClassLoader loader, long address, long superAddress, String name) {
            this.space = space;
            this.runtime = runtime;
            this.loader = loader;
            this.addr = address;
            this.name = name;
            if ("byte".equals(name) || "short".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name) || "boolean".equals(name) || "char".equals(name) || "void".equals(name)) {
                superAddress = 0L;
            }
            this.superAddress = superAddress;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder hashCode(int hashCode) {
            this.hashCode = hashCode;
            return this;
        }

        public Builder refs(LongEnumeration refs) {
            this.refs = this.runtime.convertRefs(refs, 0);
            return this;
        }

        public Builder componentType(JavaClass componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder isPacked(boolean isPacked) {
            this.isPacked = isPacked;
            return this;
        }

        public PHDJavaClass build() {
            return new PHDJavaClass(this);
        }
    }
}

