/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;

class PHDJavaReference
implements JavaReference {
    private final Object target;
    private final Object source;
    private final int reach;
    private final int ref;
    private final int root;
    private final String desc;

    PHDJavaReference(Object target, Object source, int reach, int ref, int root, String desc) {
        this.target = target;
        this.source = source;
        this.reach = reach;
        this.ref = ref;
        this.root = root;
        switch (ref) {
            case 0: {
                desc = "Unknown reference";
                break;
            }
            case 1: {
                desc = "Class reference";
                break;
            }
            case 2: {
                desc = "Field reference";
                break;
            }
            case 3: {
                desc = "Array element reference";
                break;
            }
            case 4: {
                desc = "Class loader reference";
                break;
            }
            case 5: {
                desc = "Signers reference";
                break;
            }
            case 6: {
                desc = "Protection domain reference";
                break;
            }
            case 7: {
                desc = "Interface reference";
                break;
            }
            case 8: {
                desc = "Static field reference";
                break;
            }
            case 9: {
                desc = "Constant pool reference";
                break;
            }
            case 10: {
                desc = "Superclass reference";
                break;
            }
            case 11: {
                desc = "Loaded class reference";
                break;
            }
            case 12: {
                desc = "Class object reference";
                break;
            }
            case 13: {
                desc = "Associated class reference";
            }
        }
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public int getReachability() throws CorruptDataException {
        return this.reach;
    }

    public int getReferenceType() throws CorruptDataException {
        return this.ref;
    }

    public int getRootType() throws CorruptDataException {
        return this.root;
    }

    public Object getSource() throws DataUnavailable, CorruptDataException {
        return this.source;
    }

    public Object getTarget() throws DataUnavailable, CorruptDataException {
        return this.target;
    }

    public boolean isClassReference() throws DataUnavailable, CorruptDataException {
        return this.target instanceof JavaClass;
    }

    public boolean isObjectReference() throws DataUnavailable, CorruptDataException {
        return this.target instanceof JavaObject;
    }

    public boolean equals(Object o) {
        if (o instanceof PHDJavaReference) {
            PHDJavaReference to = (PHDJavaReference)o;
            if (this.target == to.target && this.source == to.source && this.reach == to.reach && this.ref == to.ref && this.root == to.root && (this.getDescription() == null ? to.getDescription() == null : this.getDescription().equals(to.getDescription()))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.target != null ? this.target.hashCode() : 0) ^ (this.source != null && this.source != this.target ? this.source.hashCode() : 0) ^ this.reach ^ this.ref ^ this.root ^ (this.getDescription() != null ? this.getDescription().hashCode() : 0);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "," + this.source + "," + this.desc + "]";
    }
}

