/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.parser;

import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.parser.Base;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.BufferedNumberStream;
import com.ibm.dtfj.phd.util.LongEnumeration;
import com.ibm.dtfj.phd.util.NumberStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.ImageInputStream;

public class HeapdumpReader
extends Base {
    private static final long MAX_UNSIGNED_INT_AS_LONG = 0xFFFFFFFFL;
    String filename;
    DataStreamAdapter dis;
    long lastAddress;
    long[] classAddressCache = new long[4];
    int classAddressCacheIndex;
    int totalObjects;
    int totalRefs;
    int version;
    int random1;
    int random2;
    int totalLong;
    int totalShort;
    int totalMedium;
    int totalPrim;
    int totalLongPrim;
    int totalClass;
    int totalArray;
    int totalHash;
    int totalActualRefs;
    int totalNegGaps;
    Vector classNames = new Vector();
    int dumpFlags;
    String full_version = "unknown";
    boolean dbg = debug;
    boolean pre78432;
    int gapShift = 3;
    boolean j9;
    NumberStream refStream = new BufferedNumberStream();
    RefEnum refEnum = new RefEnum(this.refStream);
    private static final boolean nomangle = Boolean.getBoolean("findroots.nomangle");
    boolean continueParse;
    PHDImage image = null;

    public HeapdumpReader(File file, PHDImage image) throws IOException {
        this(file.getAbsolutePath());
        this.image = image;
        if (this.image == null) {
            throw new NullPointerException("PHDImage must be provided to allow streams to be cleaned up.");
        }
        this.image.registerReader(this);
    }

    public HeapdumpReader(ImageInputStream stream, PHDImage image) throws IOException {
        this(stream);
        this.image = image;
        if (this.image == null) {
            throw new NullPointerException("PHDImage must be provided to allow streams to be cleaned up.");
        }
        this.image.registerReader(this);
    }

    protected HeapdumpReader(ImageInputStream stream) throws IOException {
        this.filename = "[data stream]";
        stream.seek(0L);
        this.dis = new DataStreamAdapter(stream);
        this.processData();
    }

    protected HeapdumpReader(String filename) throws IOException {
        if (this.dbg) {
            System.out.println("opening file " + filename);
        }
        this.filename = filename;
        FilterInputStream is = null;
        try {
            if (filename.endsWith(".gz")) {
                is = new BufferedInputStream(new GZIPInputStream(new FileInputStream(filename)));
            } else {
                FileInputStream fis = new FileInputStream(filename);
                is = new BufferedInputStream(fis);
            }
            this.dis = new DataStreamAdapter(new DataInputStream(is));
            this.processData();
        }
        catch (UTFDataFormatException e) {
            try {
                if (filename.endsWith(".gz")) {
                    is = new GZIPInputStream(new FileInputStream(filename));
                } else {
                    FileInputStream fis = new FileInputStream(filename);
                    is = new BufferedInputStream(fis);
                }
                this.dis = new DataStreamAdapter(new DataInputStream(is));
                long l = this.dis.readLong();
                if (l == 5303217658343391L) {
                    UTFDataFormatException e1 = new UTFDataFormatException("Warning!\nThis PHD file has been ftp'd in ascii mode and is consequently unusable.\nPlease go back and ftp the original file again but this time specifying binary ftp mode.");
                    e1.initCause(e);
                    e = e1;
                    System.err.println(e.getMessage());
                }
                throw e;
            }
            catch (Exception ee) {
                IOException ioe = new IOException("Error parsing PHD file");
                ioe.initCause(ee);
                throw ioe;
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error parsing PHD file");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void processData() throws IOException {
        try {
            int tag;
            this.dis.mark(2);
            int len = this.dis.readUnsignedShort();
            this.dis.reset();
            String header = this.readUTF();
            if (this.dbg) {
                System.out.println("read header: " + header);
            }
            if (header.equals("portable heap dump")) {
                this.version = this.dis.readInt();
                if (this.version != 4 && this.version != 5 && this.version != 6) {
                    throw new IOException("unexpected version: " + this.version);
                }
            } else {
                throw new IOException("bad header in '" + this.filename + "' : " + (char)(len >> 8 & 0xFF) + (char)(len & 0xFF) + header.substring(0, Math.min(header.length(), 50)));
            }
            if (this.dbg) {
                System.out.println("phd version: " + this.version);
            }
            if (this.version == 5) {
                this.gapShift = 2;
            }
            this.dumpFlags = this.dis.readInt();
            if ((this.dumpFlags & 4) != 0) {
                this.gapShift = 2;
                this.j9 = true;
            }
            if (this.dbg) {
                System.out.println("read dump flags 0x" + HeapdumpReader.hex(this.dumpFlags));
            }
            HeapdumpReader.Assert((tag = this.dis.readUnsignedByte()) == 1);
            if (this.dbg) {
                System.out.println("read start of header tag");
            }
            block8: do {
                tag = this.dis.readUnsignedByte();
                switch (tag) {
                    case 1: {
                        if (this.dbg) {
                            System.out.println("read totals tag");
                        }
                        this.totalObjects = this.dis.readInt();
                        this.totalRefs = this.dis.readInt();
                        break;
                    }
                    case 2: {
                        if (!this.dbg) continue block8;
                        System.out.println("read end of header tag");
                        break;
                    }
                    case 3: {
                        if (this.dbg) {
                            System.out.println("read hashcodes tag");
                        }
                        this.random1 = this.dis.readInt();
                        this.random2 = this.dis.readInt();
                        break;
                    }
                    case 4: {
                        this.full_version = this.readUTF();
                        if (this.full_version.endsWith("0917")) {
                            this.pre78432 = true;
                        }
                        if (!this.dbg) continue block8;
                        System.out.println("read full version tag, version = " + this.full_version);
                        break;
                    }
                    default: {
                        throw new IOException("unrecognized tag: " + tag);
                    }
                }
            } while (tag != 2);
            tag = this.dis.readUnsignedByte();
            HeapdumpReader.Assert(tag == 2);
            if (this.dbg) {
                System.out.println("read start of dump tag");
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error parsing PHD file");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public String full_version() {
        return this.full_version;
    }

    public int version() {
        return this.version;
    }

    public boolean is64Bit() {
        return (this.dumpFlags & 1) != 0;
    }

    public boolean isJ9() {
        return this.j9;
    }

    public boolean allObjectsHashed() {
        return (this.dumpFlags & 2) != 0;
    }

    public int totalObjects() {
        return this.totalObjects;
    }

    public int totalRefs() {
        return this.totalRefs;
    }

    int Handle2Hash(long address) {
        return (int)(address >>> 3);
    }

    int ROTATE(int value, int n) {
        return value >>> n | value << 32 - n;
    }

    int MANGLE(int hashCode) {
        return (this.ROTATE(hashCode ^ this.random1, 17) ^ this.random2) >>> 1;
    }

    int getHashCode(long address, int flags) throws Exception {
        if (this.j9 && this.allObjectsHashed()) {
            if (this.dbg) {
                System.out.println("request to getHashCode (j9)");
            }
            int r = this.dis.readShort() & Short.MAX_VALUE;
            return r << 16 | r;
        }
        if (flags != 0) {
            if (this.dbg) {
                System.out.println("request to getHashCode (sov/J9 R26+)");
            }
            ++this.totalHash;
            return this.dis.readInt();
        }
        if (!this.j9) {
            if (this.dbg) {
                System.out.println("request to getHashCode (sov mangle)");
            }
            return nomangle ? 0 : this.MANGLE(this.Handle2Hash(address));
        }
        if (this.dbg) {
            System.out.println("request to getHashCode (J9 unset)");
        }
        return 0;
    }

    private long getInstanceSize() throws IOException {
        if (this.version >= 6) {
            int val = this.dis.readInt();
            return (0xFFFFFFFFL & (long)val) * 4L;
        }
        return -1L;
    }

    long readWord() throws Exception {
        if (this.is64Bit()) {
            return this.dis.readLong();
        }
        return this.dis.readInt();
    }

    long readUnsignedWord() throws Exception {
        if (this.is64Bit()) {
            return this.dis.readLong();
        }
        int val = this.dis.readInt();
        return 0xFFFFFFFFL & (long)val;
    }

    void readRefs(long address, long classAddress, int numRefs, int refsSize) throws IOException {
        this.refStream.clear();
        long gap = 0L;
        if (this.dbg) {
            System.out.println("readRefs, numRefs = " + numRefs + " refsSize = " + refsSize);
        }
        for (int i = 0; i < numRefs; ++i) {
            long ref;
            gap = refsSize == 0 ? (long)(this.dis.readByte() << this.gapShift) : (refsSize == 1 ? (long)(this.dis.readShort() << this.gapShift) : (refsSize == 2 ? (long)this.dis.readInt() << this.gapShift : this.dis.readLong() << this.gapShift));
            long l = ref = this.is64Bit() ? address + gap : address + gap & 0xFFFFFFFFL;
            if (this.j9 && i == 0 && ref == classAddress) continue;
            this.refStream.writeLong(ref);
            if (this.dbg) {
                System.out.println("read ref " + HeapdumpReader.hex(ref) + " with gap " + HeapdumpReader.hex(gap));
            }
            ++this.totalActualRefs;
        }
        this.refStream.rewind();
    }

    void reverseOrderOfRefs(boolean isPacked, boolean isNativePacked) {
        int i;
        int count = this.refEnum.numberOfElements();
        long[] refs = new long[count];
        for (i = 0; i < count; ++i) {
            refs[i] = (Long)this.refEnum.nextElement();
        }
        this.refStream.clear();
        if (isPacked && !isNativePacked) {
            this.refStream.writeLong(refs[0]);
            for (i = count - 1; i >= 1; --i) {
                this.refStream.writeLong(refs[i]);
            }
        } else {
            for (i = count - 1; i >= 0; --i) {
                this.refStream.writeLong(refs[i]);
            }
        }
        this.refStream.rewind();
    }

    long getRelativeAddress(int flags) throws IOException {
        long gap = 0L;
        switch (flags) {
            case 0: {
                gap = this.dis.readByte() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + gap) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + byte gap 0x" + HeapdumpReader.hex(gap));
                break;
            }
            case 1: {
                gap = this.dis.readShort() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + gap) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + short gap 0x" + HeapdumpReader.hex(gap));
                break;
            }
            case 2: {
                gap = (long)this.dis.readInt() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + gap) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + int gap 0x" + HeapdumpReader.hex(gap));
                break;
            }
            case 3: {
                gap = this.dis.readLong() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + gap) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + long gap 0x" + HeapdumpReader.hex(gap));
            }
        }
        return this.is64Bit() ? this.lastAddress + gap : this.lastAddress + gap & 0xFFFFFFFFL;
    }

    public void exitParse() {
        this.continueParse = false;
    }

    public boolean parse(PortableHeapDumpListener listener) throws Exception {
        long address = 0L;
        this.continueParse = true;
        block8: while (this.continueParse) {
            int hashCode;
            int length;
            int objFlags;
            int tag = this.dis.readUnsignedByte();
            if (this.dbg) {
                System.out.println("read tag " + HeapdumpReader.hex(tag));
            }
            if ((tag & 0x80) != 0) {
                long classAddress = this.classAddressCache[(tag &= 0x7F) >> 5];
                int numRefs = tag >> 3 & 3;
                int refsSize = tag & 3;
                address = this.getRelativeAddress(tag >> 2 & 1);
                int hashCode2 = this.getHashCode(address, 0);
                objFlags = this.j9 || this.allObjectsHashed() ? 1 : 0;
                this.readRefs(address, classAddress, numRefs, refsSize);
                if (this.dbg) {
                    System.out.println(HeapdumpReader.hex(address) + ": short object, class = " + HeapdumpReader.hex(classAddress));
                }
                ++this.totalShort;
                this.lastAddress = address;
                listener.objectDump(address, classAddress, objFlags, hashCode2, this.refEnum, false, false, -1L);
                continue;
            }
            if ((tag & 0x40) != 0) {
                long classAddress;
                int numRefs = (tag &= 0x3F) >> 3;
                int refsSize = tag & 3;
                address = this.getRelativeAddress(tag >> 2 & 1);
                this.classAddressCache[this.classAddressCacheIndex] = classAddress = this.readUnsignedWord();
                this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
                int hashCode3 = this.getHashCode(address, 0);
                objFlags = this.j9 || this.allObjectsHashed() ? 1 : 0;
                this.readRefs(address, classAddress, numRefs, refsSize);
                if (this.dbg) {
                    System.out.println(HeapdumpReader.hex(address) + ": medium object, class = " + HeapdumpReader.hex(classAddress));
                }
                ++this.totalMedium;
                this.lastAddress = address;
                listener.objectDump(address, classAddress, objFlags, hashCode3, this.refEnum, false, false, -1L);
                continue;
            }
            if ((tag & 0x20) != 0) {
                int objFlags2;
                int type = tag >> 2 & 7;
                int size = tag & 3;
                length = 0;
                if (this.pre78432 && size == 3) {
                    address = this.lastAddress + (long)(this.dis.readInt() << this.gapShift);
                    length = this.dis.readInt();
                    if (this.dbg) {
                        System.out.println("warning! bad primitive array");
                    }
                } else {
                    address = this.getRelativeAddress(size);
                    length = size == 0 ? this.dis.readUnsignedByte() : (size == 1 ? this.dis.readUnsignedShort() : (size == 2 ? this.dis.readInt() : (int)this.dis.readLong()));
                }
                hashCode = this.getHashCode(address, 0);
                long instanceSize = this.getInstanceSize();
                int n = objFlags2 = this.j9 || this.allObjectsHashed() ? 1 : 0;
                if (this.dbg) {
                    System.out.println(HeapdumpReader.hex(address) + ": primitive array, short record, length " + length + ", instance size = " + instanceSize);
                }
                ++this.totalPrim;
                this.lastAddress = address;
                listener.primitiveArrayDump(address, type, length, objFlags2, hashCode, instanceSize);
                continue;
            }
            switch (tag) {
                case 3: {
                    if (nomangle) {
                        System.out.println("totalLong = " + this.totalLong + " totalMedium = " + this.totalMedium + " totalShort = " + this.totalShort + " totalPrim = " + this.totalPrim + " totalHash = " + this.totalHash);
                    }
                    if (nomangle) {
                        System.out.println("totalLongPrim = " + this.totalLongPrim + " totalClass = " + this.totalClass + " totalArray = " + this.totalArray + " totalRefs = " + this.totalActualRefs);
                    }
                    if (nomangle) {
                        System.out.println("version = " + this.version);
                    }
                    return false;
                }
                case 4: {
                    int flags = this.dis.readUnsignedByte();
                    address = this.getRelativeAddress(flags >> 6 & 3);
                    long classAddress = this.readUnsignedWord();
                    boolean isPacked = (flags >> 3 & 1) == 1;
                    boolean isNativePacked = (flags >> 2 & 1) == 1;
                    this.classAddressCache[this.classAddressCacheIndex] = classAddress;
                    this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
                    int hashCode4 = this.getHashCode(address, flags & 2);
                    int objFlags3 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | flags & 3;
                    int numRefs = this.dis.readInt();
                    int refsSize = flags >> 4 & 3;
                    this.readRefs(address, classAddress, numRefs, refsSize);
                    long instanceSize = -1L;
                    if (isPacked) {
                        instanceSize = this.getInstanceSize();
                    }
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(address) + ": long object, hash code = " + HeapdumpReader.hex(hashCode4) + " flags = " + HeapdumpReader.hex(flags) + " class = " + HeapdumpReader.hex(classAddress) + " numRefs = " + numRefs + " instance size = " + instanceSize);
                    }
                    ++this.totalLong;
                    this.lastAddress = address;
                    listener.objectDump(address, classAddress, objFlags3, hashCode4, this.refEnum, isPacked, isNativePacked, instanceSize);
                    continue block8;
                }
                case 8: {
                    ++this.totalArray;
                }
                case 5: {
                    int flags = this.dis.readUnsignedByte();
                    address = this.getRelativeAddress(flags >> 6 & 3);
                    long classAddress = this.readUnsignedWord();
                    boolean isPacked = (flags >> 3 & 1) == 1;
                    boolean isNativePacked = (flags >> 2 & 1) == 1;
                    int hashCode4 = this.getHashCode(address, flags & 2);
                    int objFlags4 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | flags & 3;
                    int numRefs = this.dis.readInt();
                    int refsSize = flags >> 4 & 3;
                    this.readRefs(address, classAddress, numRefs, refsSize);
                    this.reverseOrderOfRefs(isPacked, isNativePacked);
                    int length2 = numRefs;
                    if (tag == 8) {
                        length2 = this.dis.readInt();
                    }
                    long instanceSize = this.getInstanceSize();
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(address) + ": object array, hash code = " + HeapdumpReader.hex(hashCode4) + " flags = " + HeapdumpReader.hex(flags) + " num refs = " + numRefs + " length = " + length2 + " instance size = " + instanceSize);
                    }
                    this.lastAddress = address;
                    listener.objectArrayDump(address, classAddress, objFlags4, hashCode4, this.refEnum, length2, instanceSize, isPacked, isNativePacked);
                    continue block8;
                }
                case 6: {
                    boolean isPacked;
                    int flags = this.dis.readUnsignedByte();
                    address = this.getRelativeAddress(flags >> 6 & 3);
                    int instanceSize = this.dis.readInt();
                    int hashCode5 = this.getHashCode(address, flags & 8);
                    int objFlags5 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | ((flags & 8) != 0 ? 3 : 0);
                    long superAddress = this.readUnsignedWord();
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(address) + ": class flags = " + HeapdumpReader.hex(flags) + " hashCode = " + HeapdumpReader.hex(hashCode5) + " instanceSize = " + instanceSize + " superAddress = " + HeapdumpReader.hex(superAddress));
                    }
                    String className = this.readUTF();
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(address) + ": class " + className);
                    }
                    int numRefs = this.dis.readInt();
                    int refsSize = flags >> 4 & 3;
                    boolean bl = isPacked = (flags >> 2 & 1) == 1;
                    if (this.dbg && isPacked) {
                        System.out.println("class is packed");
                    }
                    this.readRefs(address, -1L, numRefs, refsSize);
                    ++this.totalClass;
                    this.lastAddress = address;
                    listener.classDump(address, superAddress, className, instanceSize, objFlags5, hashCode5, this.refEnum, isPacked);
                    continue block8;
                }
                case 7: {
                    int flags = this.dis.readUnsignedByte();
                    int type = flags >>> 5;
                    length = 0;
                    if ((flags & 0x10) == 0) {
                        address = this.lastAddress + (long)(this.dis.readByte() << this.gapShift);
                        length = this.dis.readUnsignedByte();
                    } else {
                        address = this.lastAddress + (this.readWord() << this.gapShift);
                        length = (int)this.readUnsignedWord();
                    }
                    hashCode = this.getHashCode(address, flags & 2);
                    long instanceSize = this.getInstanceSize();
                    int objFlags6 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | flags & 3;
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(address) + ": primitive array, long record, length = " + length + " hash code = " + HeapdumpReader.hex(hashCode) + " flags = " + HeapdumpReader.hex(flags) + " instance size = " + instanceSize);
                    }
                    ++this.totalLongPrim;
                    this.lastAddress = address;
                    listener.primitiveArrayDump(address, type, length, objFlags6, hashCode, instanceSize);
                    continue block8;
                }
            }
            throw new Exception("unexpected tag: " + tag);
        }
        return true;
    }

    String className() {
        return "HeapdumpReader";
    }

    private String readUTF() throws IOException {
        int length = this.dis.readUnsignedShort();
        byte[] buf = new byte[length];
        this.dis.readFully(buf);
        return new String(buf, "UTF-8");
    }

    public void close() {
        if (this.dis != null) {
            try {
                this.dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void releaseResources() {
        if (this.dis != null) {
            try {
                this.dis.releaseResources();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws IOException {
        HeapdumpReader reader = new HeapdumpReader(args[0]);
        System.out.println("is64Bit = " + (reader.is64Bit() ? "true" : "false"));
        System.out.println("phd version = " + reader.version());
        System.out.println("full version = " + reader.full_version());
        System.out.println("total objects = " + reader.totalObjects());
        System.out.println("total refs = " + reader.totalRefs());
        reader.close();
    }

    private class DataStreamAdapter {
        private final DataInputStream dis;
        private final ImageInputStream iis;

        public DataStreamAdapter(ImageInputStream iis) {
            this.iis = iis;
            this.dis = null;
        }

        public DataStreamAdapter(DataInputStream dis) {
            this.dis = dis;
            this.iis = null;
        }

        public int readInt() throws IOException {
            if (this.dis == null) {
                return this.iis.readInt();
            }
            return this.dis.readInt();
        }

        public int readUnsignedShort() throws IOException {
            if (this.dis == null) {
                return this.iis.readUnsignedShort();
            }
            return this.dis.readUnsignedShort();
        }

        public int readUnsignedByte() throws IOException {
            if (this.dis == null) {
                return this.iis.readUnsignedByte();
            }
            return this.dis.readUnsignedByte();
        }

        public void mark(int readlimit) {
            if (this.dis == null) {
                this.iis.mark();
            } else {
                this.dis.mark(readlimit);
            }
        }

        public void reset() throws IOException {
            if (this.dis == null) {
                this.iis.reset();
            } else {
                this.dis.reset();
            }
        }

        public long readLong() throws IOException {
            if (this.dis == null) {
                return this.iis.readLong();
            }
            return this.dis.readLong();
        }

        public short readShort() throws IOException {
            if (this.dis == null) {
                return this.iis.readShort();
            }
            return this.dis.readShort();
        }

        public byte readByte() throws IOException {
            if (this.dis == null) {
                return this.iis.readByte();
            }
            return this.dis.readByte();
        }

        public void readFully(byte[] buffer) throws IOException {
            if (this.dis == null) {
                this.iis.readFully(buffer);
            } else {
                this.dis.readFully(buffer);
            }
        }

        public void close() throws IOException {
            if (this.dis != null) {
                this.dis.close();
            }
        }

        public void releaseResources() throws IOException {
            if (this.dis == null) {
                this.iis.close();
            } else {
                this.dis.close();
            }
        }
    }

    class RefEnum
    implements LongEnumeration {
        NumberStream stream;

        RefEnum(NumberStream stream) {
            this.stream = stream;
        }

        public boolean hasMoreElements() {
            return this.stream.hasMore();
        }

        public boolean hasNumberOfElements() {
            return true;
        }

        public int numberOfElements() {
            return this.stream.elementCount();
        }

        public Object nextElement() {
            return new Long(this.nextLong());
        }

        public long nextLong() {
            return this.stream.readLong();
        }

        public void reset() {
            this.stream.clear();
        }
    }
}

