/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.FileSniffer;
import com.ibm.dtfj.utils.file.GZipFileManager;
import com.ibm.dtfj.utils.file.MVSImageInputStream;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.SimpleFileManager;
import com.ibm.dtfj.utils.file.ZipFileManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileManager {
    public static final long MIN_CORE_SIZE = 0x1400000L;
    protected static final Logger logger = Logger.getLogger("com.ibm.dtfj.log");

    public abstract List<ManagedImageSource> getImageSources() throws IOException;

    public abstract ImageInputStream getStream() throws IOException;

    public static File createTempDir(File parent) throws IOException {
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException("The specified parent temporary directory does not exist or is not a directory : " + parent.getAbsolutePath());
        }
        File tmpdir = File.createTempFile("dtfj", "cprss", parent);
        tmpdir.delete();
        tmpdir.mkdirs();
        tmpdir.deleteOnExit();
        logger.fine("Created temporary directory for extracted files : " + tmpdir.getAbsolutePath());
        return tmpdir;
    }

    public static boolean fileExists(File file) {
        String os = System.getProperty("os.name");
        if (os == null) {
            return true;
        }
        if (os.toLowerCase().contains("z/os")) {
            if (file.exists()) {
                return true;
            }
            try {
                new MVSImageInputStream(file.getName());
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        return file.exists();
    }

    public static FileManager getManager(File file) {
        String name = file.getName().toLowerCase();
        try {
            if (FileSniffer.isZipFile(file)) {
                return new ZipFileManager(file);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Error encountered sampling potential zip file", e);
        }
        if (name.endsWith(".gz")) {
            return new GZipFileManager(file);
        }
        return new SimpleFileManager(file);
    }

    public static boolean isArchive(File file) {
        String name = file.getName().toLowerCase();
        try {
            if (FileSniffer.isZipFile(file)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Error encountered sampling potential zip file", e);
        }
        return name.endsWith(".gz");
    }

    protected String[] getJavaCoreNameFromPHD(String name) {
        String prefix = "heapdump";
        int p = Math.max(0, name.indexOf(prefix));
        String extraPrefix = name.substring(0, p);
        if ((name = name.substring(p)).startsWith(prefix)) {
            String[] s = name.split("\\.");
            s[0] = extraPrefix + "javacore" + s[0].substring(prefix.length());
            int[] sequence = s.length >= 6 ? new int[]{0, 1, -1} : new int[]{0};
            String[] javaCoreNames = new String[sequence.length];
            for (int index = 0; index < sequence.length; ++index) {
                javaCoreNames[index] = this.genJavacoreName(s, sequence[index], 4);
            }
            return javaCoreNames;
        }
        return new String[0];
    }

    protected String genJavacoreName(String[] s, int inc, int componentToInc) {
        StringBuffer sb = new StringBuffer(s[0]);
        for (int i = 1; i < s.length - 1; ++i) {
            String ss = s[i];
            if (i == componentToInc) {
                try {
                    int iv = Integer.parseInt(ss);
                    String si = Integer.toString(iv + inc);
                    ss = ss.substring(0, Math.max(0, ss.length() - si.length())) + si;
                }
                catch (NumberFormatException e) {}
            } else if (i == s.length - 2 && s[i + 1].equals("gz")) break;
            sb.append('.');
            sb.append(ss);
        }
        sb.append(".txt");
        return sb.toString();
    }
}

