/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Container;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    protected Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    public static final String FILE_EXT_JAR = ".jar";
    public static final String FILE_EXT_CLASS = ".class";
    private final String name;
    private long lastModified = -1L;
    private long size = -1L;
    private Container parent = null;
    private URL url = null;
    protected File file = null;
    protected Object data = null;

    public Entry(String name) {
        this.name = name;
    }

    public Entry(String name, File file) {
        this.name = name;
        this.file = file;
        if (file != null) {
            this.size = file.length();
            this.lastModified = file.lastModified();
        }
    }

    public Entry(File file) {
        if (file == null) {
            this.name = "root";
        } else {
            this.name = file.getName();
            this.size = file.length();
            this.lastModified = file.lastModified();
        }
        this.file = file;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public Container getParent() {
        return this.parent;
    }

    public URL toURL() {
        try {
            if (this.url != null) {
                return this.url;
            }
            if (this.parent != null && this.parent.getName().endsWith(FILE_EXT_JAR)) {
                this.url = new URL("jar:file:" + this.parent.getFile().getAbsolutePath() + "!/" + this.name);
            }
            if (this.file != null) {
                this.url = this.file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.FINE, "Exception thrown when constructing URL from jar file name " + this.parent.getFile().getAbsolutePath() + " and class file name " + this.name);
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasChanged(Entry previous) {
        if (this.file != null ? previous.file == null : !this.name.equals(previous.name)) {
            return false;
        }
        return this.size != previous.size || this.lastModified != previous.lastModified;
    }

    public boolean hasChanged(File previous) {
        if (this.file == null) {
            return true;
        }
        if (this.file.equals(previous)) {
            return this.size != previous.length() || this.lastModified != previous.lastModified();
        }
        return true;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Entry)) {
            return false;
        }
        Entry compareTo = (Entry)o;
        return this.name.equals(compareTo.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (this.file == null) {
            return this.name;
        }
        return this.name + " loaded from " + this.file.getAbsolutePath();
    }
}

