/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import java.net.URL;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassScanner
implements ClassVisitor,
AnnotationVisitor {
    private ClassInfo info;
    private Annotation currentAnnotation = null;
    private final URL url;
    private final Set<ClassListener> listeners;

    public ClassScanner(URL url, Set<ClassListener> listeners) {
        this.url = url;
        this.listeners = listeners;
    }

    public AnnotationVisitor visitAnnotation(String classname, boolean visible) {
        this.currentAnnotation = this.info.addAnnotation(classname);
        for (ClassListener listener : this.listeners) {
            listener.visitAnnotation(classname, visible);
        }
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String dotName = name.replace('/', '.');
        String dotSuperName = superName.replace('/', '.');
        this.info = new ClassInfo(dotName, this.url);
        for (String iface : interfaces) {
            this.info.addInterface(iface);
        }
        for (ClassListener listener : this.listeners) {
            listener.visit(version, access, dotName, signature, dotSuperName, interfaces);
        }
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }

    public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
        return null;
    }

    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        return null;
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitSource(String arg0, String arg1) {
    }

    public void visit(String name, Object value) {
        this.currentAnnotation.addEntry(name, value);
        for (ClassListener listener : this.listeners) {
            listener.visitAnnotationValue(name, value);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return null;
    }

    public AnnotationVisitor visitArray(String name) {
        return null;
    }

    public void visitEnum(String name, String desc, String value) {
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }
}

