/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class FileOutputChannel
implements IOutputChannel {
    private File file;
    private FileWriter fw;

    public FileOutputChannel(FileWriter f, File file) {
        this.fw = f;
        this.file = file;
    }

    public void print(String outputString) {
        try {
            this.fw.write(Utils.toString(outputString));
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printPrompt(String prompt) {
    }

    public void println(String outputString) {
        try {
            this.fw.write(Utils.toString(outputString) + "\n");
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void error(String outputString) {
        try {
            this.fw.write("\n");
            this.fw.write("\tERROR: " + Utils.toString(outputString) + "\n");
            this.fw.write("\n");
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void error(String msg, Exception e) {
        try {
            this.fw.write("\n");
            this.fw.write("\tERROR: " + Utils.toString(msg) + "\n");
            this.fw.write("\n");
            PrintWriter writer = new PrintWriter((Writer)this.fw, true);
            e.printStackTrace(writer);
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printInput(long timestamp, String prompt, String outputString) {
        try {
            this.fw.write(new Date(timestamp).toString() + " " + prompt + Utils.toString(outputString) + "\n");
            this.fw.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FileOutputChannel)) {
            return false;
        }
        return this.file.equals(((FileOutputChannel)o).getFile());
    }

    private Object getFile() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

