/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.JUCMonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.NodeList;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

@DTFJPlugin(version="1.*", runtime=false)
public class DeadlockCommand
extends BaseJdmpviewCommand {
    public DeadlockCommand() {
        this.addCommand("deadlock", "", "displays information about deadlocks if there are any");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("The deadlock command does not take any parameters");
            return;
        }
        this.doCommand();
    }

    public void doCommand() {
        TreeMap<Long, MonitorNode> monitorNodes = new TreeMap<Long, MonitorNode>();
        JavaRuntime jr = this.ctx.getRuntime();
        Iterator itMonitor = jr.getMonitors();
        int nodeListNum = 0;
        this.out.print("\n  deadlocks for runtime \n");
        while (itMonitor.hasNext()) {
            JavaObject threadObject;
            JavaMonitor monitor = (JavaMonitor)itMonitor.next();
            MonitorNode node = new MonitorNode(monitor);
            JavaThread owner = null;
            Long id = null;
            try {
                owner = monitor.getOwner();
            }
            catch (CorruptDataException e) {
                this.out.println("exception encountered while getting monitor owner: " + Exceptions.getCorruptDataExceptionString());
                return;
            }
            if (null == owner) continue;
            try {
                threadObject = owner.getObject();
            }
            catch (CorruptDataException e) {
                this.out.println("exception encountered while getting owner's JavaObject: " + Exceptions.getCorruptDataExceptionString());
                return;
            }
            id = new Long(threadObject.getID().getAddress());
            monitorNodes.put(id, node);
        }
        Iterator itThread = jr.getThreads();
        while (itThread.hasNext()) {
            try {
                JavaObject threadObject;
                Object o = itThread.next();
                if (!(o instanceof JavaThread)) continue;
                JavaThread jt = (JavaThread)o;
                JavaThread owner = null;
                Long id = null;
                if ((jt.getState() & 0x200) == 0) continue;
                JavaObject lock = jt.getBlockingObject();
                JUCMonitorNode node = new JUCMonitorNode(lock, jr);
                try {
                    owner = Utils.getParkBlockerOwner(lock, jr);
                    if (owner == null) {
                        continue;
                    }
                }
                catch (MemoryAccessException e) {
                    this.out.println("exception encountered while getting monitor owner: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                try {
                    threadObject = owner.getObject();
                }
                catch (CorruptDataException e) {
                    this.out.println("exception encountered while getting owner's JavaObject: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                id = new Long(threadObject.getID().getAddress());
                monitorNodes.put(id, node);
            }
            catch (CorruptDataException cde) {
                this.out.println("\nwarning, corrupt data encountered during scan for java.util.concurrent locks...");
            }
            catch (DataUnavailable du) {
                this.out.println("\nwarning, data unavailable encountered during scan for java.util.concurrent locks...");
            }
        }
        for (MonitorNode currNode : monitorNodes.values()) {
            Iterator itWaiters = currNode.getEnterWaiters();
            while (itWaiters.hasNext()) {
                JavaObject threadObject;
                Object o = itWaiters.next();
                if (!(o instanceof JavaThread)) continue;
                JavaThread waiter = (JavaThread)o;
                Long id = null;
                try {
                    threadObject = waiter.getObject();
                }
                catch (CorruptDataException e) {
                    this.out.println("exception encountered while getting waiter's ImageThread: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                id = new Long(threadObject.getID().getAddress());
                MonitorNode waiterNode = (MonitorNode)monitorNodes.get(id);
                if (null == waiterNode) continue;
                waiterNode.waitingOn = currNode;
            }
        }
        Iterator values = monitorNodes.values().iterator();
        int visit = 1;
        Vector<NodeList> lists = new Vector<NodeList>();
        while (values.hasNext()) {
            MonitorNode startNode;
            MonitorNode currNode = startNode = (MonitorNode)values.next();
            if (0 != startNode.visit) continue;
            while (true) {
                MonitorNode endNode;
                currNode.visit = visit;
                if (null == currNode.waitingOn) {
                    currNode.deadlock = 1;
                    break;
                }
                if (this.isDeadlocked(currNode.waitingOn)) {
                    NodeList split;
                    endNode = currNode.waitingOn;
                    currNode = startNode;
                    NodeList branchList = null;
                    while (currNode != endNode) {
                        if (null == branchList) {
                            branchList = new NodeList(currNode, nodeListNum++);
                        }
                        currNode.deadlock = 3;
                        currNode = currNode.waitingOn;
                        branchList.add(currNode);
                        if (currNode == endNode) continue;
                        currNode.inList = branchList;
                    }
                    if (endNode.inList.isLoop()) {
                        lists.insertElementAt(branchList, lists.indexOf(endNode.inList));
                        break;
                    }
                    NodeList oldList = endNode.inList;
                    if (null == (split = endNode.inList.attachOrSplit(branchList, nodeListNum++))) break;
                    lists.insertElementAt(split, lists.indexOf(oldList));
                    lists.insertElementAt(branchList, lists.indexOf(oldList));
                    break;
                }
                if (currNode.waitingOn.visit == visit) {
                    currNode = endNode = currNode.waitingOn;
                    NodeList loopList = new NodeList(currNode, nodeListNum++);
                    lists.insertElementAt(loopList, 0);
                    do {
                        currNode.deadlock = 2;
                        currNode = currNode.waitingOn;
                        loopList.add(currNode);
                        currNode.inList = loopList;
                    } while (currNode != endNode);
                    currNode = startNode;
                    NodeList branchList = null;
                    while (currNode != endNode) {
                        if (null == branchList) {
                            branchList = new NodeList(currNode, nodeListNum++);
                            lists.insertElementAt(branchList, 0);
                        }
                        currNode.deadlock = 3;
                        currNode = currNode.waitingOn;
                        branchList.add(currNode);
                        if (currNode == endNode) continue;
                        currNode.inList = branchList;
                    }
                    break;
                }
                currNode = currNode.waitingOn;
            }
            ++visit;
        }
        if (lists.isEmpty()) {
            this.out.print("\n");
            this.out.print("\t no deadlocks detected");
            this.out.print("\n");
            return;
        }
        boolean lastListWasLoop = true;
        for (NodeList list : lists) {
            if (list.isLoop()) {
                this.out.print("\n    deadlock loop:\n");
                lastListWasLoop = true;
            } else if (lastListWasLoop) {
                this.out.print("\n\n    deadlock branch(es):\n");
                lastListWasLoop = false;
            }
            this.out.print("\t  " + list.toString());
            this.out.print("\n");
        }
        this.out.print("\n");
    }

    private boolean isDeadlocked(MonitorNode node) {
        return 2 == node.deadlock || 3 == node.deadlock;
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("displays information about deadlocks if there are any\n\nparameters: none\n\nThe \"deadlock\" command shows detailed information about deadlocks or \"no deadlocks detected\" if there are no deadlocks.  A deadlock situation consists of one or more deadlock loops and zero or more branches attached to those loops.  This command prints out each branch attached to a loop and then the loop itself.  If there is a split in a deadlock branch, separate branches will be created for each side of the split in the branch.  Deadlock branches start with a monitor that has no threads waiting on it and the continues until it reaches a monitor that exists in another deadlock branch or loop.  Deadlock loops start and end with the same monitor.\n\nMonitors are represented by their owner and the object associated with the given monitor.  For example, \"3435 (0x45ae67)\" represents the monitor that is owned by the thread with id 3435 and is associated the object at address 0x45ae67.  Objects can be viewed by using a command like \"x/j 0x45ae67\" and threads can be viewed using a command like \"info thread 3435\".\n");
    }
}

