/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.File;
import java.io.PrintStream;

@DTFJPlugin(version=".*", runtime=false)
public class PwdCommand
extends BaseJdmpviewCommand {
    public PwdCommand() {
        this.addCommand("pwd", "", "displays the current working directory");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("\"pwd\" does not take any parameters");
            return;
        }
        File pwd = (File)this.ctx.getProperties().get("pwd");
        out.print("\n");
        out.print("\t" + pwd.getPath());
        out.print("\n\n");
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("displays the current working directory\n\nparameters: none\n\ndisplays the current working directory, which is the directory where log files are stored; see the help for \"cd\" for more information\n");
    }
}

