/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class WhatisCommand
extends BaseJdmpviewCommand {
    public WhatisCommand() {
        this.addCommand("whatis", "[hex address]", "gives information about what is stored at the given memory address");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length == 0) {
            out.println("missing address argument");
            return;
        }
        Long lAddressInDecimal = Utils.longFromString(args[0]);
        if (null == lAddressInDecimal) {
            out.println("cannot convert \"" + args[0] + "\" to numeric value");
            return;
        }
        long addressInDecimal = lAddressInDecimal;
        this.findInRuntime(addressInDecimal);
        out.print("\n");
    }

    private void findInRuntime(long address) {
        Iterator itHeap = this.ctx.getRuntime().getHeaps();
        int count = 1;
        while (itHeap.hasNext()) {
            JavaHeap jh = (JavaHeap)itHeap.next();
            this.out.print("\theap #" + count + " - name: ");
            this.out.print(jh.getName() + "\n");
            this.findInHeap(jh, address);
            ++count;
        }
    }

    private void findInHeap(JavaHeap jh, long address) {
        if (this.isWithinImageSections(jh.getSections(), null, false, address)) {
            if (!this.isStartOfObj(jh.getObjects(), address) && !this.isWithinObjectRange(jh.getObjects(), address)) {
                this.out.print("\t\t0x" + Long.toHexString(address) + " is orphaned on the heap.\n");
            }
        } else {
            this.out.print("\t\t0x" + Long.toHexString(address) + " is not within this heap.\n");
            long bound = 12L;
            this.checkClassInRange(jh.getObjects(), bound, address);
            this.checkMethodInRange(jh.getObjects(), address);
        }
    }

    private void checkMethodInRange(Iterator objects, long address) {
        while (objects.hasNext()) {
            JavaClass jClass;
            JavaObject jObject = (JavaObject)objects.next();
            try {
                jClass = jObject.getJavaClass();
            }
            catch (CorruptDataException cde) {
                continue;
            }
            Iterator methods = jClass.getDeclaredMethods();
            while (methods.hasNext()) {
                JavaMethod jMethod = (JavaMethod)methods.next();
                Iterator bytecodeSections = jMethod.getBytecodeSections();
                Iterator compiledSections = jMethod.getCompiledSections();
                if (this.isWithinImageSections(bytecodeSections, jMethod, false, address)) {
                    return;
                }
                if (!this.isWithinImageSections(compiledSections, jMethod, true, address)) continue;
                return;
            }
        }
    }

    private void checkClassInRange(Iterator objects, long bound, long address) {
        while (objects.hasNext()) {
            String className;
            JavaClass jClass;
            JavaObject jObject = (JavaObject)objects.next();
            try {
                jClass = jObject.getJavaClass();
                className = jClass.getName();
            }
            catch (CorruptDataException cde) {
                continue;
            }
            long startAddress = jClass.getID().getAddress();
            long endAddress = startAddress + bound;
            if (address == startAddress) {
                this.out.print("\t0x" + Long.toHexString(address) + " is the address of the java/lang/Class object for " + className);
                return;
            }
            if (!this.isWithinRange(startAddress, endAddress, address)) continue;
            this.out.print("0x" + Long.toHexString(address) + " is within the java/lang/Class object for " + className);
            return;
        }
    }

    private boolean isWithinObjectRange(Iterator objects, long address) {
        while (objects.hasNext()) {
            long endAddress;
            long startAddress;
            String className;
            JavaObject jObject = (JavaObject)objects.next();
            try {
                className = jObject.getJavaClass().getName();
                startAddress = jObject.getID().getAddress();
                endAddress = startAddress + jObject.getSize();
            }
            catch (CorruptDataException cde) {
                continue;
            }
            if (!this.isWithinRange(startAddress, endAddress, address)) continue;
            this.out.print("\t\t0x" + Long.toHexString(address) + " is within an object on the heap:\n" + "\t\t\toffset " + (address - startAddress) + " within " + className + " instance @ 0x" + Long.toHexString(startAddress) + "\n");
            return true;
        }
        return false;
    }

    private boolean isWithinRange(long startAddress, long endAddress, long address) {
        return address <= endAddress && address > startAddress;
    }

    private boolean isStartOfObj(Iterator objects, long address) {
        long corruptObjectCount = 0L;
        while (objects.hasNext()) {
            String className;
            Object obj = objects.next();
            if (obj instanceof CorruptData) {
                ++corruptObjectCount;
                continue;
            }
            JavaObject jObject = (JavaObject)obj;
            if (address != jObject.getID().getAddress()) continue;
            try {
                className = jObject.getJavaClass().getName();
            }
            catch (CorruptDataException cde) {
                className = "<corrupt class name>";
            }
            this.out.print("\t\t0x" + Long.toHexString(address) + " is the start of an object of type " + className);
            return true;
        }
        if (corruptObjectCount > 0L) {
            this.out.println("\t\t[skipped " + corruptObjectCount + " corrupt object(s) in heap]");
        }
        return false;
    }

    private boolean isWithinImageSections(Iterator heapImageSections, Object memType, boolean isMethodCompiled, long address) {
        while (heapImageSections.hasNext()) {
            long size;
            ImageSection imageSection = (ImageSection)heapImageSections.next();
            long baseAddress = imageSection.getBaseAddress().getAddress();
            long endAddress = baseAddress + (size = imageSection.getSize());
            if (address > endAddress || address < baseAddress) continue;
            if (null == memType) {
                this.out.print("\t\t0x" + Long.toHexString(address) + " is within heap segment: " + Long.toHexString(baseAddress) + " -- " + Long.toHexString(endAddress) + "\n");
                return true;
            }
            if (!(memType instanceof JavaMethod)) continue;
            String methodName = "N/A";
            String methodSig = "N/A";
            String className = "N/A";
            try {
                methodName = ((JavaMethod)memType).getName();
                methodSig = ((JavaMethod)memType).getSignature();
                className = ((JavaMethod)memType).getDeclaringClass().getName();
            }
            catch (CorruptDataException cde) {
            }
            catch (DataUnavailable du) {
                // empty catch block
            }
            String codeType = isMethodCompiled ? "compiled code" : "byte code";
            this.out.print("\t0x" + Long.toHexString(address) + " is within the " + codeType + " range: " + Long.toHexString(baseAddress) + " -- " + Long.toHexString(endAddress) + "\n\t" + "...of method " + methodName + " with signature " + methodSig + "\n\t" + "...in class " + className + "\n");
            return true;
        }
        return false;
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("gives information about what is stored at the given memory address\n\nparameters: <hex_address>\n\nthe whatis command examines the memory location at <hex_address> and tries to find out more information about this address - for example whether it is within an object in a heap or within the byte codes associated with a class method.");
    }
}

