/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.ClassOutput;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DTFJPlugin(version="1.*", runtime=false)
public class InfoClassCommand
extends BaseJdmpviewCommand {
    private static Map<JavaRuntime, Map<JavaClass, ClassStatistics>> classInstanceCounts;

    public InfoClassCommand() {
        this.addCommand("info class", "[Java class name] [-sort:<name|count|size>]", "Provides information about the specified Java class");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        String className = null;
        Comparator<JavaClass> sortOrder = new ClassNameComparator();
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (classInstanceCounts == null) {
            this.cacheRuntimeClasses();
            this.countClassInstances();
        }
        for (String arg : args) {
            if ("-sort:size".equals(arg)) {
                sortOrder = new TotalSizeComparator();
                continue;
            }
            if ("-sort:count".equals(arg)) {
                sortOrder = new InstanceCountComparator();
                continue;
            }
            if ("-sort:name".equals(arg)) {
                sortOrder = new ClassNameComparator();
                continue;
            }
            className = arg;
        }
        if (className == null) {
            this.printAllRuntimeClasses(sortOrder);
        } else {
            this.printSingleRuntimeClassInfo(className);
        }
    }

    private void printSingleRuntimeClassInfo(String className) {
        JavaClass jc;
        JavaRuntime jr = this.ctx.getRuntime();
        Long objAddress = Utils.longFromStringWithPrefix(className);
        JavaClass[] classes = null;
        if (objAddress != null) {
            jc = Utils.getClassGivenAddress(objAddress, jr);
            if (jc != null) {
                classes = new JavaClass[]{jc};
            }
        } else {
            classes = Utils.getClassGivenName(className, jr, this.out);
        }
        if (null == classes || classes.length == 0) {
            this.out.print("\t  could not find class with name \"" + className + "\"\n\n");
        } else if (classes.length == 1) {
            jc = classes[0];
            this.printClassDetails(jr, className, jc);
        } else {
            this.out.println("name = " + className + " found " + classes.length + " on different class loaders");
            for (int i = 0; i < classes.length; ++i) {
                JavaClass jc2 = classes[i];
                ClassOutput.printRuntimeClassAndLoader(jc2, this.out);
            }
            this.out.println("Use info class with the class ID to print out information on a specific class.");
            this.out.println("For example: info class 0x" + Long.toHexString(classes[0].getID().getAddress()));
        }
    }

    private void printClassDetails(JavaRuntime jr, String className, JavaClass jc) {
        String modifiersInfo;
        String classLoaderId;
        String superClassId;
        String spaces = "    ";
        String cdeInfo = "N/A (CorruptDataException occurred)";
        try {
            this.out.print("name = " + jc.getName());
        }
        catch (CorruptDataException dce) {
            this.out.print("name = " + cdeInfo);
        }
        this.out.print("\n\n\t");
        this.out.print("ID = " + Utils.toHex(jc.getID()));
        try {
            JavaClass superClass = jc.getSuperclass();
            superClassId = null == superClass ? "<no superclass>" : Utils.toHex(superClass.getID());
        }
        catch (CorruptDataException dce) {
            superClassId = cdeInfo;
        }
        this.out.print(spaces);
        this.out.print("superID = " + superClassId);
        try {
            JavaClassLoader jClassLoader = jc.getClassLoader();
            JavaObject jo = jClassLoader.getObject();
            classLoaderId = jo != null ? Utils.toHex(jo.getID()) : "<data unavailable>";
        }
        catch (CorruptDataException cde) {
            classLoaderId = cdeInfo;
        }
        this.out.print(spaces);
        this.out.print("\n\t");
        this.out.print("classLoader = " + classLoaderId);
        try {
            modifiersInfo = Utils.getClassModifierString(jc);
        }
        catch (CorruptDataException cde) {
            modifiersInfo = cdeInfo;
        }
        this.out.print(spaces);
        this.out.print("modifiers: " + modifiersInfo);
        this.out.print("\n\n");
        try {
            if (jc.isPacked()) {
                this.out.print("\tThis is a packed class\n\n");
            }
        }
        catch (CorruptDataException e) {
            this.out.print("\tCannot determine if this is a packed class, corrupt data\n\n");
        }
        catch (DataUnavailable e) {
            this.out.print("\tCannot determine if this is a packed class, data unavailable\n\n");
        }
        ClassStatistics d = this.getClassStatisticsFor(jr, jc);
        this.out.print("\tnumber of instances:     " + d.getCount() + "\n");
        this.out.print("\ttotal size of instances on the heap: " + d.getSize() + " bytes");
        this.out.print("\n\n");
        this.printClassHierarchy(jc);
        this.out.print("\n");
        this.printFields(jc);
        this.out.print("\n");
        this.printMethods(jc);
    }

    private void printClassHierarchy(JavaClass jClass) {
        Stack<String> stack = new Stack<String>();
        while (null != jClass) {
            try {
                stack.add(jClass.getName());
                jClass = jClass.getSuperclass();
            }
            catch (CorruptDataException cde) {
                stack.add("N/A (CorruptDataException occurred)");
                break;
            }
        }
        this.printStack(stack);
    }

    private void printStack(Stack<String> stack) {
        this.out.print("Inheritance chain....\n\n");
        String tab = "\t";
        String spaces = "";
        while (stack.size() > 0) {
            this.out.print(tab + spaces + stack.pop() + "\n");
            spaces = spaces + "   ";
        }
    }

    private void printFields(JavaClass jClass) {
        this.out.print("Fields......\n\n");
        ClassOutput.printStaticFields(jClass, this.out);
        ClassOutput.printNonStaticFields(jClass, this.out);
    }

    private void printMethods(JavaClass jClass) {
        this.out.print("Methods......\n\n");
        ClassOutput.printMethods(jClass.getDeclaredMethods(), this.out);
        this.out.print("\n");
    }

    private void cacheRuntimeClasses() {
        classInstanceCounts = new HashMap<JavaRuntime, Map<JavaClass, ClassStatistics>>();
        long corruptClassCount = 0L;
        HashMap<JavaClass, ClassStatistics> classesOfThisRuntime = new HashMap<JavaClass, ClassStatistics>();
        JavaRuntime runtime = this.ctx.getRuntime();
        classInstanceCounts.put(runtime, classesOfThisRuntime);
        Iterator itClassLoader = runtime.getJavaClassLoaders();
        while (itClassLoader.hasNext()) {
            JavaClassLoader jcl = (JavaClassLoader)itClassLoader.next();
            Iterator itClass = jcl.getDefinedClasses();
            while (itClass.hasNext()) {
                Object obj = itClass.next();
                if (obj instanceof JavaClass) {
                    classesOfThisRuntime.put((JavaClass)obj, new ClassStatistics());
                    continue;
                }
                ++corruptClassCount;
            }
        }
        if (corruptClassCount > 0L) {
            this.out.print("Warning, found " + corruptClassCount + " corrupt classes during classloader walk\n");
        }
    }

    private void printAllRuntimeClasses(Comparator<JavaClass> sortOrder) {
        Iterator<Object> itClass;
        JavaRuntime jr = this.ctx.getRuntime();
        Collection<JavaClass> javaClasses = InfoClassCommand.getRuntimeClasses(jr);
        long objCount = 0L;
        long totalSize = 0L;
        if (sortOrder == null) {
            itClass = javaClasses.iterator();
        } else {
            LinkedList<JavaClass> sortedList = new LinkedList<JavaClass>();
            Iterator<JavaClass> itr = javaClasses.iterator();
            while (itr.hasNext()) {
                sortedList.add(itr.next());
            }
            Collections.sort(sortedList, sortOrder);
            itClass = sortedList.iterator();
        }
        if (itClass.hasNext()) {
            this.printClassListHeader();
        } else {
            this.out.print("\n\t No information found for loaded classes\n");
        }
        while (itClass.hasNext()) {
            JavaClass jc = itClass.next();
            ClassStatistics d = this.getClassStatisticsFor(jr, jc);
            totalSize += d.getSize();
            objCount += (long)d.getCount();
            this.printOneClass(jc, d);
        }
        this.out.print("\n");
        this.out.print("\t Total number of objects: " + objCount + "\n");
        this.out.print("\t Total size of objects: " + totalSize + "\n");
    }

    private static Collection<JavaClass> getRuntimeClasses(JavaRuntime jr) {
        return classInstanceCounts.get(jr).keySet();
    }

    private ClassStatistics getClassStatisticsFor(JavaRuntime jr, JavaClass jc) {
        return classInstanceCounts.get(jr).get(jc);
    }

    private void countClassInstances() {
        JavaRuntime runtime = this.ctx.getRuntime();
        Map<JavaClass, ClassStatistics> thisRuntimeClasses = classInstanceCounts.get(runtime);
        Collection<JavaClass> javaClasses = InfoClassCommand.getRuntimeClasses(runtime);
        long corruptObjectCount = 0L;
        long corruptClassCount = 0L;
        long corruptClassNameCount = 0L;
        Iterator itHeap = runtime.getHeaps();
        while (itHeap.hasNext()) {
            Object heap = itHeap.next();
            if (heap instanceof CorruptData) {
                this.out.println("[skipping corrupt heap]");
                continue;
            }
            JavaHeap jh = (JavaHeap)heap;
            Iterator itObject = jh.getObjects();
            while (itObject.hasNext()) {
                Object next = itObject.next();
                if (next instanceof JavaObject) {
                    JavaObject jo = (JavaObject)next;
                    ClassStatistics stats = null;
                    try {
                        JavaClass jc = jo.getJavaClass();
                        if (javaClasses.contains(jc)) {
                            stats = thisRuntimeClasses.get(jc);
                        } else {
                            stats = new ClassStatistics();
                            thisRuntimeClasses.put(jc, stats);
                            try {
                                String classname = jc.getName();
                                this.out.println("Warning, class: " + classname + " found when walking the heap was missing from classloader walk");
                            }
                            catch (CorruptDataException cde) {
                                ++corruptClassNameCount;
                            }
                        }
                        stats.incrementCount();
                        try {
                            stats.addToSize(jo.getSize());
                        }
                        catch (CorruptDataException cde) {
                            ++corruptObjectCount;
                        }
                    }
                    catch (CorruptDataException cde) {
                        ++corruptClassCount;
                    }
                    continue;
                }
                ++corruptObjectCount;
            }
        }
        if (corruptObjectCount != 0L) {
            this.out.println("Warning, found " + corruptObjectCount + " corrupt objects during heap walk");
        }
        if (corruptClassCount != 0L) {
            this.out.println("Warning, found " + corruptClassCount + " corrupt class references during heap walk");
        }
        if (corruptClassNameCount != 0L) {
            this.out.println("Warning, found " + corruptClassNameCount + " corrupt class names during heap walk");
        }
    }

    private void printClassListHeader() {
        this.out.print("\n" + Utils.prePadWithSpaces("instances", 16));
        this.out.print(Utils.prePadWithSpaces("total size on heap", 20));
        this.out.print(Utils.prePadWithSpaces("Packed?", 14));
        this.out.print("  class name");
        this.out.print("\n");
    }

    private void printOneClass(JavaClass jc, ClassStatistics datum) {
        String className;
        try {
            className = jc.getName();
        }
        catch (CorruptDataException cde) {
            className = Exceptions.getCorruptDataExceptionString();
        }
        this.out.print(Utils.prePadWithSpaces(String.valueOf(datum.getCount()), 16));
        this.out.print(Utils.prePadWithSpaces(String.valueOf(datum.getSize()), 20));
        try {
            if (jc.isPacked()) {
                this.out.print(Utils.prePadWithSpaces("yes ", 14));
            } else {
                this.out.print(Utils.prePadWithSpaces("   ", 14));
            }
        }
        catch (DataUnavailable e) {
            this.out.print(Utils.prePadWithSpaces("<unknown>", 14));
        }
        catch (CorruptDataException e) {
            this.out.print(Utils.prePadWithSpaces("<unknown>", 14));
        }
        this.out.print("  " + className);
        this.out.print("\n");
    }

    private static int cmp(long n1, long n2) {
        if (n1 == n2) {
            return 0;
        }
        if (n1 > n2) {
            return 1;
        }
        return -1;
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("Prints inheritance chain and other data for a given class\n\nParameters: none, class name or ID, sort flags\n\nIf name or id parameters are omitted then \"info class\", prints the number of instances of each class and the total size of all instances of each class as well as the total number of instances of all classes and the total size of all objects.\nThis output may be sorted using the -sort:name, -sort:size or -sort:count flags.\n\nIf a class name or hex address is passed to \"info class\", it prints the following information about that class:\n  - name\n  - ID\n  - superclass ID\n  - class loader ID\n  - modifiers\n  - number of instances and total size of instances\n  - inheritance chain\n  - fields with modifiers (and values for static fields)\n  - methods with modifiers\nIf multiple classes with the same name (on different class loaders) are found then the class ID and class loader are printed for each class. Use info class with the class ID to print out information on a specific class.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassNameComparator
    implements Comparator<JavaClass> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(JavaClass o1, JavaClass o2) {
            String s1 = "";
            String s2 = "";
            try {
                s1 = o1.getName();
            }
            catch (CorruptDataException cde) {
                // empty catch block
            }
            try {
                s2 = o2.getName();
            }
            catch (CorruptDataException cde) {
                // empty catch block
            }
            return s1.compareTo(s2);
        }
    }

    public static class ClassStatistics {
        private int count = 0;
        private long totalSize = 0L;

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.totalSize;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void addToSize(long sizeToAdd) {
            this.totalSize += sizeToAdd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InstanceCountComparator
    implements Comparator<JavaClass> {
        private InstanceCountComparator() {
        }

        @Override
        public int compare(JavaClass o1, JavaClass o2) {
            long s1 = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), o1).getCount();
            long s2 = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), o2).getCount();
            return InfoClassCommand.cmp(s1, s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TotalSizeComparator
    implements Comparator<JavaClass> {
        private TotalSizeComparator() {
        }

        @Override
        public int compare(JavaClass o1, JavaClass o2) {
            long s1 = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), o1).getSize();
            long s2 = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), o2).getSize();
            return InfoClassCommand.cmp(s1, s2);
        }
    }
}

