/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoSystemCommand
extends BaseJdmpviewCommand {
    public InfoSystemCommand() {
        this.addCommand("info sys", "", "shortened form of info system");
        this.addCommand("info system", "", "displays information about the system the core dump is from");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length != 0) {
            out.println("\"info system\" command does not take any parameters");
            return;
        }
        this.doCommand();
    }

    public void doCommand() {
        String createTimeStr;
        SimpleDateFormat fmt;
        try {
            this.out.println("\nMachine OS:\t" + this.ctx.getImage().getSystemType());
        }
        catch (DataUnavailable exc) {
            this.out.println("\nMachine OS:\tdata unavailable");
        }
        catch (CorruptDataException exc) {
            this.out.println("\nMachine OS:\tdata corrupted");
        }
        Properties imageProperties = this.ctx.getImage().getProperties();
        if (imageProperties.containsKey("Hypervisor")) {
            this.out.println("Hypervisor:\t" + imageProperties.getProperty("Hypervisor"));
        }
        try {
            this.out.println("Machine name:\t" + this.ctx.getImage().getHostName());
        }
        catch (DataUnavailable exc) {
            this.out.println("Machine name:\tdata unavailable");
        }
        catch (CorruptDataException exc) {
            this.out.println("Machine name:\tdata corrupted");
        }
        this.out.println("Machine IP address(es):");
        try {
            Iterator itIPAddresses = this.ctx.getImage().getIPAddresses();
            while (itIPAddresses.hasNext()) {
                Object addr = itIPAddresses.next();
                if (addr instanceof InetAddress) {
                    this.out.println("\t\t" + ((InetAddress)addr).getHostAddress());
                    continue;
                }
                if (!(addr instanceof CorruptData)) continue;
                this.out.println("\t\tdata corrupted");
            }
        }
        catch (DataUnavailable du) {
            this.out.println("\t\tdata unavailable");
        }
        try {
            this.out.println("System memory:\t" + this.ctx.getImage().getInstalledMemory());
        }
        catch (DataUnavailable exc) {
            this.out.println("System memory:\tdata unavailable");
        }
        try {
            long createTimeMillis = this.ctx.getImage().getCreationTime();
            if (createTimeMillis != 0L) {
                fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
                createTimeStr = fmt.format(new Date(createTimeMillis));
                this.out.println("\nDump creation time: " + createTimeStr);
            } else {
                this.out.println("\nDump creation time: data unavailable");
            }
        }
        catch (DataUnavailable d) {
            this.out.println("\nDump creation time: data unavailable");
        }
        try {
            long createTimeNanos = this.ctx.getImage().getCreationTimeNanos();
            if (createTimeNanos != 0L) {
                this.out.println("Dump creation time (nanoseconds): " + createTimeNanos);
            } else {
                this.out.println("Dump creation time (nanoseconds): data unavailable");
            }
        }
        catch (DataUnavailable du) {
            this.out.println("Dump creation time (nanoseconds): data unavailable");
        }
        catch (CorruptDataException cde) {
            this.out.println("Dump creation time (nanoseconds): data corrupted");
        }
        this.out.println("\nJava version:");
        if (this.ctx.getRuntime() != null) {
            try {
                this.out.println(this.ctx.getRuntime().getVersion());
            }
            catch (CorruptDataException e) {
                this.out.println("version data corrupted");
            }
        } else {
            this.out.println("\tmissing, unknown or unsupported JRE");
        }
        try {
            long startTimeMillis = this.ctx.getRuntime().getStartTime();
            if (startTimeMillis != 0L) {
                fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
                createTimeStr = fmt.format(new Date(startTimeMillis));
                this.out.println("\nJVM start time: " + createTimeStr);
            } else {
                this.out.println("\nJVM start time: data unavailable");
            }
        }
        catch (DataUnavailable d) {
            this.out.println("\nJVM start time: data unavailable");
        }
        catch (CorruptDataException cde) {
            this.out.println("\nJVM start time (nanoseconds): data corrupted");
        }
        try {
            long startTimeNanos = this.ctx.getRuntime().getStartTimeNanos();
            if (startTimeNanos != 0L) {
                this.out.println("JVM start time (nanoseconds): " + startTimeNanos);
            } else {
                this.out.println("JVM start time (nanoseconds): data unavailable");
            }
        }
        catch (DataUnavailable du) {
            this.out.println("JVM start time (nanoseconds): data unavailable");
        }
        catch (CorruptDataException cde) {
            this.out.println("JVM start time (nanoseconds): data corrupted");
        }
        boolean kernelSettingPrinted = false;
        for (String name : new String[]{"/proc/sys/kernel/sched_compat_yield", "/proc/sys/kernel/core_pattern", "/proc/sys/kernel/core_uses_pid"}) {
            if (!imageProperties.containsKey(name)) continue;
            if (!kernelSettingPrinted) {
                this.out.println("\nLinux Kernel Settings:");
            }
            this.out.println(name + " = " + imageProperties.getProperty(name));
            kernelSettingPrinted = true;
        }
        this.out.println();
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("displays information about the system the core dump is from\n\nparameters: none\n\nprints information about the system the core dump is from:\n  - operating system\n  - host name and IP addresses\n  - amount of memory\n  - virtual machine(s) present\n");
    }
}

