/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.classic;

import com.ibm.jvm.dtfjview.heapdump.HeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.LongArrayReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class ClassicHeapDumpFormatter
extends HeapDumpFormatter {
    private static final String EOF_HEADER = "// EOF: Total 'Objects',Refs(null) :";
    private static final String BREAKDOWN_HEADER = "// Breakdown - Classes:";
    private static final String VERSION_HEADER = "// Version: ";
    private final BufferedWriter _out;
    private int _classCount = 0;
    private int _allObjectCount = 0;
    private int _objectArraysCount = 0;
    private int _primitiveArraysCount = 0;
    private int _referenceCount = 0;
    private int _nullReferenceCount = 0;
    private boolean _closed = false;
    private boolean is64bit = false;

    public ClassicHeapDumpFormatter(Writer out, String version, boolean is64bit) throws IOException {
        super(version, is64bit);
        this._out = new BufferedWriter(out);
        this.is64bit = is64bit;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this._out.write(VERSION_HEADER + this._version);
        this._out.newLine();
    }

    private void writeReferences(ReferenceIterator references) throws IOException {
        if (references == null) {
            return;
        }
        references.reset();
        if (!references.hasNext()) {
            this._out.write("\t");
            this._out.newLine();
            return;
        }
        StringBuffer referenceString = new StringBuffer();
        referenceString.append("\t");
        boolean first = true;
        while (references.hasNext()) {
            Long thisRef = references.next();
            if (first) {
                first = false;
            } else {
                referenceString.append(" ");
            }
            referenceString.append(this.toHexString(thisRef));
            ++this._referenceCount;
            if (thisRef != 0L) continue;
            ++this._nullReferenceCount;
        }
        referenceString.append(" ");
        this._out.write(referenceString.toString());
        this._out.newLine();
    }

    private String toHexString(long value) {
        if (value == 0L) {
            return "0x0";
        }
        if (this.is64bit) {
            return "0x" + String.format("%016X", value);
        }
        return "0x" + String.format("%08X", value);
    }

    public void addClass(long address, String name, long superClassAddress, int size, long instanceSize, int hashCode, ReferenceIterator references) throws IOException {
        this.checkClosed();
        this._out.write(this.toHexString(address) + " [" + size + "] CLS " + name);
        this._out.newLine();
        this.writeReferences(references);
        ++this._classCount;
        ++this._allObjectCount;
    }

    private void checkClosed() {
        if (this._closed) {
            throw new UnsupportedOperationException("This dump has been closed");
        }
    }

    private void writeEntry(long address, long size, String className, ReferenceIterator references) throws IOException {
        this._out.write(this.toHexString(address) + " [" + size + "] OBJ " + className);
        this._out.newLine();
        this.writeReferences(references);
        ++this._allObjectCount;
    }

    public void addObject(long address, long classAddress, String className, int size, int hashCode, ReferenceIterator references) throws IOException {
        this.checkClosed();
        this.writeEntry(address, size, className, references);
    }

    private static ReferenceIterator addReference(final ReferenceIterator original, final long extra) {
        return new ReferenceIterator(){
            private boolean _returnedExtra = false;

            public boolean hasNext() {
                if (this._returnedExtra) {
                    return original.hasNext();
                }
                return true;
            }

            public Long next() {
                if (this._returnedExtra) {
                    return original.next();
                }
                this._returnedExtra = true;
                return new Long(extra);
            }

            public void reset() {
                original.reset();
                this._returnedExtra = false;
            }
        };
    }

    public void addObjectArray(long address, long arrayClassAddress, String arrayClassName, long elementClassAddress, String elementClassName, long size, int numberOfElements, int hashCode, ReferenceIterator references) throws IOException {
        this.checkClosed();
        this.writeEntry(address, size, arrayClassName, references);
        ++this._objectArraysCount;
    }

    public void addPrimitiveArray(long address, long arrayClassAddress, int type, long size, int hashCode, int numberOfElements) throws IOException, IllegalArgumentException {
        this.checkClosed();
        LongArrayReferenceIterator references = new LongArrayReferenceIterator(new long[0]);
        this.writeEntry(address, size, this.getPrimitiveArrayName(type), references);
        ++this._primitiveArraysCount;
    }

    private String getPrimitiveArrayName(int type) {
        switch (type) {
            case 0: {
                return "[Z";
            }
            case 1: {
                return "[C";
            }
            case 2: {
                return "[F";
            }
            case 3: {
                return "[D";
            }
            case 4: {
                return "[B";
            }
            case 5: {
                return "[S";
            }
            case 6: {
                return "[I";
            }
            case 7: {
                return "[J";
            }
        }
        throw new IllegalArgumentException("Unknown primitive type code: " + type);
    }

    public void close() throws IOException {
        this.printBreakdown();
        this.printEOFSummary();
        this._out.close();
        this._closed = true;
    }

    private void printEOFSummary() throws IOException {
        StringBuffer buffer = new StringBuffer(EOF_HEADER);
        buffer.append(this._allObjectCount);
        buffer.append(",");
        buffer.append(this._referenceCount);
        buffer.append("(");
        buffer.append(this._nullReferenceCount);
        buffer.append(")");
        this._out.write(buffer.toString());
        this._out.newLine();
    }

    private void printBreakdown() throws IOException {
        int objectsCount = this._allObjectCount - this._primitiveArraysCount - this._objectArraysCount - this._classCount;
        StringBuffer buffer = new StringBuffer(BREAKDOWN_HEADER);
        buffer.append(this._classCount);
        buffer.append(", Objects:");
        buffer.append(objectsCount);
        buffer.append(", ObjectArrays:");
        buffer.append(this._objectArraysCount);
        buffer.append(", PrimitiveArrays:");
        buffer.append(this._primitiveArraysCount);
        this._out.write(buffer.toString());
        this._out.newLine();
    }
}

