/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import java.io.DataOutput;
import java.io.IOException;

public class LongPrimitiveArrayRecord
extends PortableHeapDumpRecord {
    private final int _type;
    private final int _numberOfElements;
    private final int _hashCode;
    private final boolean _is64Bit;
    private final long _instanceSize;
    private final boolean _is32BitHash;

    public LongPrimitiveArrayRecord(long address, long previousAddress, int type, int numberOfElements, int hashCode, boolean is64Bit, long instanceSize, boolean is32BitHash) {
        super(address, previousAddress, null);
        this._type = type;
        this._numberOfElements = numberOfElements;
        this._hashCode = hashCode;
        this._is64Bit = is64Bit;
        this._instanceSize = instanceSize;
        this._is32BitHash = is32BitHash;
        if (type < 0 || type > 7) {
            throw new IllegalArgumentException("Unrecognised type code: " + type);
        }
    }

    protected void writeHeapDump(DataOutput out) throws IOException {
        out.writeByte(7);
        int flag = 0;
        flag = (byte)(flag | this._type << 5);
        byte arrayLengthSize = PortableHeapDumpRecord.sizeofReference(this._numberOfElements);
        if (arrayLengthSize < this._gapSize) {
            arrayLengthSize = this._gapSize;
        }
        if (arrayLengthSize != 0) {
            flag = (byte)(flag | 0x10);
        }
        flag = (byte)(flag | 2);
        out.writeByte(flag);
        if (arrayLengthSize > 0) {
            if (this._is64Bit) {
                out.writeLong(this._gapPreceding);
                out.writeLong(this._numberOfElements);
            } else {
                out.writeInt((int)this._gapPreceding);
                out.writeInt(this._numberOfElements);
            }
        } else {
            out.writeByte((byte)this._gapPreceding);
            out.writeByte(this._numberOfElements);
        }
        if (this._is32BitHash) {
            out.writeInt(this._hashCode);
        } else {
            out.writeShort(this._hashCode);
        }
        out.writeInt((int)(this._instanceSize / 4L));
    }
}

