/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.HeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.portable.ClassRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.LongPrimitiveArrayRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.ObjectArrayRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.ObjectRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpClassCache;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpHeader;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.PrimitiveArrayRecord;
import java.io.DataOutputStream;
import java.io.IOException;

public class PortableHeapDumpFormatter
extends HeapDumpFormatter {
    public static final String MAGIC_STRING = "portable heap dump";
    public static final int PHD_VERSION_NUMBER = 6;
    public static final byte START_OF_HEADER_TAG = 1;
    public static final byte END_OF_HEADER_TAG = 2;
    public static final byte START_OF_DUMP_TAG = 2;
    public static final byte END_OF_DUMP_TAG = 3;
    public static final byte HASHCODE_RANDOM_TAG = 3;
    public static final byte FULL_VERSION_TAG = 4;
    public static final int IS_64_BIT_HEADER_FLAG = 1;
    public static final int ALL_OBJECTS_HASHED_FLAG = 2;
    public static final int IS_J9_HEADER_FLAG = 4;
    public static final byte CLASS_RECORD_TAG = 6;
    public static final byte SHORT_OBJECT_RECORD_TAG = -128;
    public static final byte MEDIUM_OBJECT_RECORD_TAG = 64;
    public static final byte LONG_OBJECT_RECORD_TAG = 4;
    public static final byte OBJECT_ARRAY_RECORD_TAG = 8;
    public static final byte PRIMITIVE_ARRAY_RECORD_TAG = 32;
    public static final byte LONG_PRIMITIVE_ARRAY_RECORD_TAG = 7;
    private final DataOutputStream _out;
    private final PortableHeapDumpClassCache _classCache = new PortableHeapDumpClassCache();
    private final boolean _is32BitHash;
    private long _lastAddress = 0L;
    private boolean _closed = false;

    public PortableHeapDumpFormatter(DataOutputStream output, String version, boolean is64Bit, boolean is32BitHash) throws IOException {
        super(version, is64Bit);
        this._out = output;
        this._is32BitHash = is32BitHash;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        PortableHeapDumpHeader header = new PortableHeapDumpHeader(this._version, this._is64Bit, this._is32BitHash);
        header.writeHeapDump(this._out);
    }

    private void checkClosed() {
        if (this._closed) {
            throw new UnsupportedOperationException("Dump is closed");
        }
    }

    public void addClass(long address, String name, long superClassAddress, int size, long instanceSize, int hashCode, ReferenceIterator references) throws IOException {
        this.checkClosed();
        ClassRecord record = new ClassRecord(address, this._lastAddress, name, superClassAddress, instanceSize, hashCode, this._is64Bit, PortableHeapDumpFormatter.filterNullReferences(references), this._is32BitHash);
        record.writeHeapDump(this._out);
        this._lastAddress = address;
    }

    public void addObject(long address, long classAddress, String className, int size, int hashCode, ReferenceIterator references) throws IOException {
        ObjectRecord record = ObjectRecord.getObjectRecord(address, this._lastAddress, classAddress, hashCode, PortableHeapDumpFormatter.filterNullReferences(references), this._classCache, this._is64Bit, this._is32BitHash);
        record.writeHeapDump(this._out);
        this._lastAddress = address;
    }

    public void addObjectArray(long address, long arrayClassAddress, String arrayClassName, long elementClassAddress, String elementClassName, long size, int numberOfElements, int hashCode, ReferenceIterator references) throws IOException {
        ObjectArrayRecord record = new ObjectArrayRecord(address, this._lastAddress, elementClassAddress, hashCode, numberOfElements, PortableHeapDumpFormatter.filterNullReferences(references), this._is64Bit, size, this._is32BitHash);
        record.writeHeapDump(this._out);
        this._lastAddress = address;
    }

    public void addPrimitiveArray(long address, long arrayClassAddress, int type, long size, int hashCode, int numberOfElements) throws IOException, IllegalArgumentException {
        PortableHeapDumpRecord record;
        if (this._is32BitHash) {
            record = hashCode == 0 ? new PrimitiveArrayRecord(address, this._lastAddress, type, numberOfElements, hashCode, this._is64Bit, size, this._is32BitHash) : new LongPrimitiveArrayRecord(address, this._lastAddress, type, numberOfElements, hashCode, this._is64Bit, size, this._is32BitHash);
            record = new PrimitiveArrayRecord(address, this._lastAddress, type, numberOfElements, hashCode, this._is64Bit, size, this._is32BitHash);
        } else {
            record = new PrimitiveArrayRecord(address, this._lastAddress, type, numberOfElements, hashCode, this._is64Bit, size, this._is32BitHash);
        }
        ((PortableHeapDumpRecord)record).writeHeapDump(this._out);
        this._lastAddress = address;
    }

    public void close() throws IOException {
        this._closed = true;
        this._out.writeByte(3);
        this._out.close();
    }

    private static ReferenceIterator filterNullReferences(final ReferenceIterator input) {
        return new ReferenceIterator(){
            private Long next;

            public boolean hasNext() {
                while (this.next == null && input.hasNext()) {
                    Long potential = input.next();
                    if (potential == 0L) continue;
                    this.next = potential;
                }
                return this.next != null;
            }

            public Long next() {
                if (!this.hasNext()) {
                    return null;
                }
                Long toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            public void reset() {
                input.reset();
                this.next = null;
            }
        };
    }
}

