/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedCommand {
    private String command;
    private String[] arguments;

    public static ParsedCommand parse(String commandLine) {
        String[] components = ParsedCommand.separateAndReorganizeTokens(commandLine);
        String command = components[0];
        String[] arguments = new String[components.length - 1];
        for (int i = 1; i < components.length; ++i) {
            arguments[i - 1] = components[i];
        }
        return new ParsedCommand(command, arguments);
    }

    public ParsedCommand(String command, String[] arguments) {
        this.setCommand(command);
        this.setArguments(arguments);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public String getCombinedCommandLine() {
        StringBuilder sb = new StringBuilder(this.getCommand());
        for (String argument : this.arguments) {
            if (0 <= argument.indexOf(" ") || 0 <= argument.indexOf("\t")) {
                argument = 0 <= argument.indexOf("\"") ? "'" + argument + "'" : "\"" + argument + "\"";
            }
            sb.append(" ").append(argument);
        }
        return sb.toString();
    }

    private static String[] separateAndReorganizeTokens(String line) {
        ArrayList<String> alTokens = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int length = line.length();
        while (i < length) {
            char c;
            if ('\"' == (c = line.charAt(i++)) || '\'' == c) {
                if (i < line.length() && c == line.charAt(i)) {
                    sb.append(c).append(c);
                    ++i;
                    continue;
                }
                char quotation = c;
                while (i < line.length() && (c = line.charAt(i++)) != quotation) {
                    sb.append(c);
                }
                continue;
            }
            if (" \t\n\r\f".indexOf(c) >= 0) {
                if (sb.length() <= 0) continue;
                alTokens.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            if ('|' == c) {
                if (sb.length() > 0) {
                    alTokens.add(sb.toString());
                    sb = new StringBuffer();
                }
                alTokens.add("|");
                continue;
            }
            if (i < length && '|' == line.charAt(i)) {
                sb.append(c);
                alTokens.add(sb.toString());
                sb = new StringBuffer();
                alTokens.add("|");
                ++i;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            alTokens.add(sb.toString());
        }
        ArrayList<String> formatted = ParsedCommand.reorganize(alTokens);
        return formatted.toArray(new String[formatted.size()]);
    }

    private static ArrayList<String> reorganize(ArrayList<String> al) {
        return ParsedCommand.reorganize(al, 0, false);
    }

    private static ArrayList<String> reorganize(ArrayList<String> al, int startIndex, boolean piped) {
        ArrayList<String> alNew = new ArrayList<String>();
        for (int i = startIndex; i < al.size(); ++i) {
            String token = al.get(i);
            if (token.equals("|") || token.equals(">") || token.equals(">>")) {
                ArrayList<String> pipe = ParsedCommand.reorganize(al, i + 1, token.equals("|"));
                piped = false;
                for (int x = pipe.size() - 1; x >= 0; --x) {
                    alNew.add(0, pipe.get(x));
                }
                if (token.equals("|")) break;
                alNew.add(0, token);
                break;
            }
            if (piped) {
                if (!ToolsRegistry.isPipeLineEnabled(token, null)) {
                    alNew.add("run");
                    if (!token.equalsIgnoreCase("-head") && !token.equalsIgnoreCase("-tail")) {
                        alNew.add("-head");
                    }
                }
                piped = false;
            }
            alNew.add(token);
        }
        return alNew;
    }
}

