/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdFileTool
extends Tool {
    public static final String[] AS_COMMENT_INDICATORS = new String[]{"//", "#"};
    public static final String COMMAND = "cmdfile";
    public static final String ARGUMENT_DESCRIPTION = "<commandFilePath> [charset]";
    public static final String HELP_DESCRIPTION = "To execute all the commands in a file.";
    public static final String USAGE = "cmdfile\t<commandFilePath> [charset]\tTo execute all the commands in a file.\n     Options:\n          <commandFilePath> : the path to a file which specifies a series of jdmpview commands.  \n               These commands are read and run sequentially.\n               Empty lines or lines starting with \"//\" or \"#\" will be ignored.\n     [charset] : the character set for the commands specified in the command file.\n          The character set name must be a supported charset as defined in java.nio.charset.Charset. For example, US-ASCII.";
    private String defaultCharset = null;

    public CmdFileTool(String charset) {
        this.defaultCharset = charset;
    }

    public static List<String> parseCmdFile(File cmdFile, String charset) throws UnsupportedEncodingException, IOException {
        String[] cmds;
        ArrayList<String> commands = new ArrayList<String>();
        for (String cmd : cmds = FileUtils.read(cmdFile, charset)) {
            if ((cmd = cmd.trim()).length() <= 0 || cmd.startsWith("//") || cmd.startsWith("#")) continue;
            commands.add(cmd);
        }
        return commands;
    }

    @Override
    public boolean accept(String command, String[] args) {
        return command.equalsIgnoreCase(COMMAND);
    }

    @Override
    public void process(String command, String[] args, PrintStream out) throws CommandException {
        if (args.length == 0) {
            out.println(USAGE);
            return;
        }
        File file = new File(args[0]);
        if (!file.exists() || !file.isFile()) {
            out.println("The specified command file " + file.getAbsolutePath() + " does not exist or is not a file");
            return;
        }
        if (file.length() > Integer.MAX_VALUE) {
            out.println("The specified command file " + file.getAbsolutePath() + " is too large to be read");
            return;
        }
        String charset = this.defaultCharset;
        if (args.length == 2) {
            charset = args[1];
        } else if (args.length > 2) {
            out.println(USAGE);
            return;
        }
        try {
            List<String> commands = CmdFileTool.parseCmdFile(file, charset);
            for (String cmd : commands) {
                out.println(Session.prompt + cmd);
                try {
                    ToolsRegistry.process(cmd, out);
                }
                catch (CommandException e) {
                    out.println(e.getMessage());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            out.println("The supplied charset " + charset + " for reading the command file is not supported");
        }
        catch (IOException e) {
            out.println("Error reading from command file " + file.getAbsolutePath());
        }
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }
}

