/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.io.PrintStream;
import java.util.LinkedList;

public class HistoryTool
extends Tool {
    public static final String COMMAND = "history";
    public static final String COMMAND_SHORT = "his";
    public static final int DEFAULT_DISPLAY_N = 20;
    public static final String ARGUMENT_DESCRIPTION = "[-r] [N]";
    public static final String HELP_DESCRIPTION = "     If option -r is used, the Nth history command (default to the last one) will be run;\n     otherwise, at most N (default 20) history commands will be displayed.";
    public static final String USAGE = "history|his\t[-r] [N]\n     If option -r is used, the Nth history command (default to the last one) will be run;\n     otherwise, at most N (default 20) history commands will be displayed.";
    private LinkedList<String> history = new LinkedList();
    private int defaultExecutingIndex = -1;

    public void record(String cmd) {
        this.history.add(cmd);
        this.defaultExecutingIndex = this.history.size() - 1;
    }

    public void process(String command, String[] args, PrintStream out) throws CommandException {
        int n = 20;
        boolean executeCommand = false;
        if (args.length == 0) {
            this.showHistoryCommands(20, out);
            return;
        }
        if (args.length > 0) {
            if (args[0].startsWith("-r")) {
                executeCommand = true;
                n = this.defaultExecutingIndex;
                if (args[0].length() > 2) {
                    try {
                        n = Integer.parseInt(args[0].substring(2));
                    }
                    catch (NumberFormatException e) {
                        this.printDetailedHelp(out);
                        return;
                    }
                } else if (args.length > 1) {
                    try {
                        n = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        this.printDetailedHelp(out);
                        return;
                    }
                }
            } else {
                try {
                    n = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    this.printDetailedHelp(out);
                    return;
                }
            }
        }
        if (executeCommand) {
            this.defaultExecutingIndex = n - 1;
            this.executeHistoryCommand(n, out);
        } else {
            this.showHistoryCommands(n, out);
        }
    }

    public boolean accept(String command, String[] args) {
        return command.equalsIgnoreCase(COMMAND_SHORT) || command.equalsIgnoreCase(COMMAND);
    }

    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }

    public String getCommandName() {
        return COMMAND;
    }

    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private void executeHistoryCommand(int n, PrintStream out) throws CommandException {
        if (this.history.size() == 0) {
            out.println("The history repository is empty.");
            return;
        }
        if (n < 0 || n > this.history.size() - 1) {
            out.println("The number " + n + " is not a valid sequence number in history repository.");
            return;
        }
        ToolsRegistry.process(this.history.get(n), out);
    }

    private void showHistoryCommands(int counter, PrintStream out) {
        if (counter <= 0) {
            out.println("The number " + counter + " is not a valid counter.");
            return;
        }
        if (this.history.size() == 0) {
            out.println("The history repository is empty.");
            return;
        }
        counter = Math.min(counter, this.history.size());
        for (int index = this.history.size() - counter; index < this.history.size(); ++index) {
            out.println(index + " : " + this.history.get(index));
        }
    }
}

