/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class OutFileTool
extends Tool
implements IPipe {
    public static final String COMMAND_OVERWRITE = ">";
    public static final String COMMAND_APPEND = ">>";
    public static final String ARGUMENT_DESCRIPTION = "<targetFilePath>";
    public static final String HELP_DESCRIPTION = "to be used at the end of a command to redirect messages to a file (overwrite|append).";
    public static final String USAGE = ">|>>\t<targetFilePath>\tto be used at the end of a command to redirect messages to a file (overwrite|append).";

    public boolean accept(String command, String[] args) {
        return command.equalsIgnoreCase(COMMAND_OVERWRITE) || command.equalsIgnoreCase(COMMAND_APPEND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String command, String[] args, PrintStream redirector) throws CommandException {
        String filename;
        Attributes attributes = this.readAttributes(command, args);
        if (attributes == null) {
            redirector.println(USAGE);
            return;
        }
        if (attributes.filePath == null) {
            redirector.println("Missing file name for redirection");
            redirector.println(USAGE);
        }
        if ((filename = attributes.filePath.trim()).charAt(filename.length() - 1) == File.separatorChar) {
            redirector.println("Invalid redirection path - missing filename");
            redirector.println(USAGE);
        }
        PrintStream fileOut = null;
        try {
            fileOut = this.getOutputFile(attributes);
            ToolsRegistry.process(attributes.nextCommand, attributes.nextCommandArgs, fileOut);
        }
        catch (IOException e) {
            redirector.println("Problem running command: ");
            redirector.println(e.getMessage());
        }
        finally {
            if (fileOut != null) {
                fileOut.flush();
                fileOut.close();
            }
        }
    }

    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }

    public String getCommandName() {
        return ">|>>";
    }

    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private PrintStream getOutputFile(Attributes attributes) throws IOException {
        String parentDirectories;
        File dir;
        PrintStream outStream = null;
        String redirectionFilename = attributes.filePath;
        File outFile = new File(redirectionFilename);
        if (redirectionFilename.indexOf(File.separator) > -1 && !(dir = new File(parentDirectories = redirectionFilename.substring(0, redirectionFilename.lastIndexOf(File.separator)))).exists() && !dir.mkdirs()) {
            throw new IOException("Could not create some of the requested directories: " + parentDirectories);
        }
        outStream = attributes.append && outFile.exists() ? new PrintStream(new FileOutputStream(outFile, true)) : new PrintStream(outFile);
        return outStream;
    }

    private Attributes readAttributes(String command, String[] args) {
        String filePath = null;
        String ddrCommand = null;
        String[] ddrCommandArgs = null;
        if (args.length < 2) {
            return null;
        }
        int index = 0;
        filePath = args[index++];
        ddrCommand = args[index++];
        ddrCommandArgs = new String[args.length - index];
        for (int i = 0; i < ddrCommandArgs.length; ++i) {
            ddrCommandArgs[i] = args[i + index];
        }
        return new Attributes(filePath, ddrCommand, ddrCommandArgs, command.equalsIgnoreCase(COMMAND_APPEND));
    }

    private class Attributes {
        private String filePath = null;
        private String nextCommand = null;
        private String[] nextCommandArgs = null;
        private boolean append = false;

        public Attributes(String filePath, String ddrCommand, String[] ddrCommandArgs, boolean append) {
            this.filePath = filePath;
            this.nextCommand = ddrCommand;
            this.nextCommandArgs = ddrCommandArgs;
            this.append = append;
        }
    }
}

