/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest;

import com.ibm.gsk.ikeyman.certrequest.AbstractCertificateRequestStore;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.FileModificationTracker;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory$EntryInterface;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BasicCertificateRequestFile
extends AbstractCertificateRequestStore {
    private static final String REQUEST_STORE_EXTENSION = ".qer";
    private static final String REQUEST_FILE_EXTENSION = ".crq";
    private static final String KEY_FILE_EXTENSION = ".bdr";
    private static final int RANDOM_BYTES = 2;
    private static final int CHARS_PER_BYTE = 2;
    private FileName fileName;
    private String storePassword;
    private List aliases;
    private FileModificationTracker tracker;

    private BasicCertificateRequestFile(File file, String string, boolean bl) throws KeyManagerException {
        Debug.entering(new Object[]{file, string, bl});
        this.fileName = new FileName(file);
        this.storePassword = string;
        this.tracker = new FileModificationTracker(file.getAbsolutePath());
        if (bl) {
            this.aliases = new ArrayList();
        } else {
            this.rebuildAliasList();
        }
        Debug.exiting();
    }

    public void refresh() throws KeyManagerException {
        Debug.entering();
        this.tracker.loaded();
        this.rebuildAliasList();
        Debug.exiting();
    }

    public void add(CertificateRequestKeyItem certificateRequestKeyItem) throws KeyManagerException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object object;
        Debug.entering(new Object[]{certificateRequestKeyItem});
        String string = BasicCertificateRequestFile.makeUniqueName(certificateRequestKeyItem.getLabel());
        try {
            object = new PrivateKeyInfo(certificateRequestKeyItem.getPrivateKey().getEncoded());
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(this.storePassword.toCharArray(), object, "MD5", "DES");
        }
        catch (Exception exception) {
            Debug.throwing(exception);
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PRIVATE_KEY_ENCRYPTION_ERROR, exception, new String[]{certificateRequestKeyItem.getLabel()});
        }
        object = this.makeKeyFileName(string);
        String string2 = this.makeRequestFileName(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            encryptedPrivateKeyInfo.encode((OutputStream)fileOutputStream);
            fileOutputStream.close();
            certificateRequestKeyItem.extract(string2, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.throwing(fileNotFoundException);
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{object});
        }
        catch (IOException iOException) {
            Debug.throwing(iOException);
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PRIVATE_KEY_ENCODING_ERROR, (Throwable)iOException);
        }
        this.aliases.add(string);
        Debug.exiting();
    }

    private static String makeUniqueName(String string) {
        Debug.entering(new Object[]{string});
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[2];
        secureRandom.nextBytes(byArray);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] >> 4 & 0xF));
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] & 0xF));
        }
        Debug.exiting(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private void rebuildAliasList() throws KeyManagerException {
        BufferedReader bufferedReader;
        Debug.entering();
        this.tracker.loaded();
        this.aliases = new ArrayList();
        try {
            bufferedReader = new BufferedReader(new FileReader(this.fileName.toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.throwing(fileNotFoundException);
            return;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.aliases.add(string);
            }
        }
        catch (IOException iOException) {
            Debug.throwing(iOException);
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, iOException, new String[]{this.fileName.getName()});
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        Debug.exiting();
    }

    public void delete() throws KeyManagerException {
        Debug.entering();
        for (Object object : this.aliases) {
            this.delete((String)object);
        }
        File file = new File(this.fileName.getFile());
        if (file.exists() && !file.delete()) {
            Object object;
            object = new KeyManagerException(KeyManagerException$ExceptionReason.FILE_DELETION_FAILED, new String[]{this.fileName.getName()});
            Debug.throwing((Throwable)object);
            throw object;
        }
        Debug.exiting();
    }

    public void delete(String string) throws KeyManagerException {
        Debug.entering(new Object[]{string});
        if (!this.contains(string)) {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.NO_REQUEST_FOR_LABEL, new String[]{string});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        String string2 = this.getFullLabel(string);
        this.deleteCertificateRequestFiles(string2);
        this.aliases.remove(string2);
        Debug.exiting();
    }

    private String getFullLabel(String string) {
        Debug.entering(new Object[]{string});
        for (String string2 : this.aliases) {
            if (!string2.startsWith(string)) continue;
            Debug.exiting(string2);
            return string2;
        }
        Debug.exiting(null);
        return null;
    }

    private void deleteCertificateRequestFiles(String string) throws KeyManagerException {
        Debug.entering(new Object[]{string});
        String string2 = this.makeRequestFileName(string);
        File file = new File(string2);
        if (!file.delete()) {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.FILE_DELETION_FAILED, new String[]{string2});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        String string3 = this.makeKeyFileName(string);
        file = new File(string3);
        if (!file.delete()) {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.FILE_DELETION_FAILED, new String[]{string3});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        Debug.exiting();
    }

    private String makeKeyFileName(String string) {
        Debug.entering(new Object[]{string});
        String string2 = this.fileName.getDirectory() + File.separator + string + KEY_FILE_EXTENSION;
        Debug.exiting(string2);
        return string2;
    }

    private String makeRequestFileName(String string) {
        Debug.entering(new Object[]{string});
        String string2 = this.fileName.getDirectory() + File.separator + string + REQUEST_FILE_EXTENSION;
        Debug.exiting(string2);
        return string2;
    }

    public CertificateRequestKeyItem getItem(String string) throws KeyManagerException {
        Debug.entering(new Object[]{string});
        if (this.contains(string)) {
            Comparable<File> comparable;
            CertificationRequest certificationRequest;
            Serializable serializable;
            String string2 = this.getFullLabel(string);
            String string3 = this.makeKeyFileName(string2);
            String string4 = this.makeRequestFileName(string2);
            try {
                serializable = new File(string4);
                if (!serializable.exists() || !serializable.canRead()) {
                    KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_REQUEST_FILE_NOT_FOUND, new String[]{string4});
                    Debug.throwing(keyManagerException);
                    throw keyManagerException;
                }
                certificationRequest = new CertificationRequest(string4, true);
            }
            catch (IOException iOException) {
                Debug.throwing(iOException);
                throw new KeyManagerException(KeyManagerException$ExceptionReason.CERT_REQUEST_FILE_CORRUPTED, iOException, new String[]{string4});
            }
            try {
                comparable = new File(string3);
                if (!comparable.exists() || !comparable.canRead()) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_FILE_NOT_FOUND, new String[]{string3});
                }
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(string3, false);
                byte[] byArray = encryptedPrivateKeyInfo.decrypt(this.storePassword.toCharArray());
                serializable = PrivateKeyInfo.parseKey((DerValue)new DerValue(byArray));
            }
            catch (Exception exception) {
                Debug.throwing(exception);
                throw new KeyManagerException(KeyManagerException$ExceptionReason.PRIVATE_KEY_DECRYPTION_ERROR, exception, new String[]{string});
            }
            comparable = EntryFactory.loadCertificateRequestItem(string, certificationRequest, (PrivateKey)serializable);
            Debug.exiting(comparable);
            return comparable;
        }
        KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.NO_REQUEST_FOR_LABEL, new String[]{string});
        Debug.throwing(keyManagerException);
        throw keyManagerException;
    }

    public void save() throws KeyManagerException {
        Debug.entering();
        if (this.aliases.size() > 0) {
            LockedFileOutputStream lockedFileOutputStream;
            try {
                lockedFileOutputStream = new LockedFileOutputStream(this.fileName.toString());
            }
            catch (IOException iOException) {
                Debug.throwing(iOException);
                throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, iOException, new String[]{this.fileName.getName()});
            }
            PrintStream printStream = new PrintStream(lockedFileOutputStream);
            for (String string : this.aliases) {
                printStream.println(string);
            }
            printStream.close();
        } else {
            File file = new File(this.fileName.toString());
            if (file.exists()) {
                file.delete();
            }
        }
        Debug.exiting();
    }

    public static EntryInterfaceFactory$EntryInterface createRequestFile(String string, String string2, Class clazz) throws KeyManagerException {
        Debug.entering(new Object[]{string, string2});
        File file = new File(string + REQUEST_STORE_EXTENSION);
        BasicCertificateRequestFile basicCertificateRequestFile = new BasicCertificateRequestFile(file, string2, true);
        Debug.exiting(basicCertificateRequestFile);
        return basicCertificateRequestFile;
    }

    public static EntryInterfaceFactory$EntryInterface loadRequestFile(String string, String string2, Class clazz) throws KeyManagerException {
        Debug.entering(new Object[]{string, string2});
        File file = new File(string + REQUEST_STORE_EXTENSION);
        BasicCertificateRequestFile basicCertificateRequestFile = new BasicCertificateRequestFile(file, string2, false);
        Debug.exiting(basicCertificateRequestFile);
        return basicCertificateRequestFile;
    }

    public List getAliases() {
        Debug.entering();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.aliases) {
            Debug.log("{0}", new Object[]{string});
            arrayList.add(string.subSequence(0, string.length() - 4).toString());
        }
        Debug.exiting(arrayList);
        return arrayList;
    }

    public void changePassword(CommandParameters commandParameters) throws KeyManagerException {
        Debug.entering(new Object[]{commandParameters});
        String string = commandParameters.getNewPassword();
        ArrayList<CertificateRequestKeyItem> arrayList = new ArrayList<CertificateRequestKeyItem>();
        for (String object : this.getAliases()) {
            arrayList.add(this.getItem(object));
        }
        this.storePassword = string;
        for (CertificateRequestKeyItem certificateRequestKeyItem : arrayList) {
            this.delete(certificateRequestKeyItem.getLabel());
            this.add(certificateRequestKeyItem);
        }
        Debug.exiting();
    }

    public boolean needsRefresh() {
        Debug.entering();
        boolean bl = this.tracker.needsRefresh();
        Debug.exiting(bl);
        return bl;
    }

    public void add(Entry entry) throws KeyManagerException {
        this.add((CertificateRequestKeyItem)entry);
    }

    public Collection getAliases() {
        return this.getAliases();
    }

    public Entry getItem(String string) throws KeyManagerException {
        return this.getItem(string);
    }
}

