/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.KeyStoreLoaderFactory$KeyStoreLoader;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validator;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.CommandValidationException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEvent;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.event.ProviderEvent;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.sequence.AConverter;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FilePermissions;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public abstract class Command {
    protected static boolean controlObjectsEnabled = false;
    private final Constants.CommandType type;
    private final ValidatorFactory$Validator validator;
    private final ParameterMap map;
    private final Map defaults;
    protected KeyStoreLoaderFactory$KeyStoreLoader loader;

    protected Command(ParameterMap parameterMap, ValidatorFactory$Validator validatorFactory$Validator, Map map) {
        Debug.entering(new Object[]{parameterMap, validatorFactory$Validator, map});
        this.type = parameterMap.getCommandType();
        this.validator = validatorFactory$Validator;
        this.map = parameterMap;
        this.defaults = map;
        Debug.exiting();
    }

    public static void setControlObjectsEnabled(boolean bl) {
        Debug.entering(new Object[]{bl});
        controlObjectsEnabled = bl;
        Debug.exiting();
    }

    protected KeyStoreItem getKeystoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor});
        KeyStoreItem keyStoreItem = this.loader.getKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor);
        Debug.exiting(keyStoreItem);
        return keyStoreItem;
    }

    protected KeyStoreItem getValidKeystoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor});
        KeyStoreItem keyStoreItem = this.loader.getValidKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor);
        Debug.exiting(keyStoreItem);
        return keyStoreItem;
    }

    protected void closeKeyStoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor});
        this.loader.closeKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor);
        Debug.exiting();
    }

    protected final void fireKeyManagerEventDatabaseOpened(KeyManagerEventListener keyManagerEventListener, KeyStoreItem keyStoreItem) throws KeyManagerException {
        Debug.entering(new Object[]{keyManagerEventListener, keyStoreItem});
        if (keyManagerEventListener != null) {
            keyManagerEventListener.databaseOpened(new KeyManagerEvent(this, keyStoreItem.getInfo()));
        }
        Debug.exiting();
    }

    protected final void fireKeyManagerEventDatabaseChanged(KeyManagerEventListener keyManagerEventListener, KeyStoreItem keyStoreItem) throws KeyManagerException {
        Debug.entering(new Object[]{keyManagerEventListener, keyStoreItem});
        if (keyManagerEventListener != null) {
            keyManagerEventListener.databaseChanged(new KeyManagerEvent(this, keyStoreItem.getInfo()));
        }
        Debug.exiting();
    }

    protected final void fireKeyManagerEventDatabaseClosed(KeyManagerEventListener keyManagerEventListener, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        Debug.entering(new Object[]{keyManagerEventListener, databaseDescriptorFactory$DatabaseDescriptor});
        if (keyManagerEventListener != null) {
            keyManagerEventListener.databaseClosed(new KeyManagerEvent(this, new KeyStoreInfo(databaseDescriptorFactory$DatabaseDescriptor, null, null, null)));
        }
        Debug.exiting();
    }

    protected final void fireKeyManagerEventProviderAdded(KeyManagerEventListener keyManagerEventListener, String string) throws KeyManagerException {
        Debug.entering(new Object[]{keyManagerEventListener, string});
        if (keyManagerEventListener != null) {
            keyManagerEventListener.providerAdded(new ProviderEvent(this, string));
        }
        Debug.exiting();
    }

    public final ControlObjectFactory$ControlObject invoke(KeyStoreLoaderFactory$KeyStoreLoader keyStoreLoaderFactory$KeyStoreLoader, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{keyStoreLoaderFactory$KeyStoreLoader, keyManagerEventListener, displayer});
        try {
            this.validator.validate(this.map.getParameters());
        }
        catch (CommandValidationException commandValidationException) {
            Debug.throwing(commandValidationException);
            commandValidationException.addDetail(this.getUsageString());
            throw commandValidationException;
        }
        if (this.defaults != null) {
            for (Constants$Parameter constants$Parameter : this.defaults.keySet()) {
                Object v;
                if (this.map.containsKey(constants$Parameter)) continue;
                if (constants$Parameter.name().equalsIgnoreCase("size") && this.map.containsKey(Constants$Parameter.SigAlg) && this.map.get(Constants$Parameter.SigAlg).toString().toUpperCase().contains("ECDSA")) {
                    this.defaults.put(Constants$Parameter.Size, KeymanSettings$Setting.DefaultECKeySize.getInteger() + "");
                }
                if ((v = this.defaults.get(constants$Parameter)) == null) continue;
                Debug.log("Adding default value {0} for parameter {1}", new Object[]{v, constants$Parameter});
                this.map.put(constants$Parameter, v);
            }
        }
        if (this.map.containsKey(Constants$Parameter.Stashed)) {
            this.map.remove(Constants$Parameter.Stashed);
            this.map.put(Constants$Parameter.Password, this.getPasswordFromStash(CommandFactory.getStashFileName((String)this.map.get(Constants$Parameter.DatabaseName))));
        }
        if (this.map.containsKey(Constants$Parameter.TargetStashed)) {
            this.map.remove(Constants$Parameter.TargetStashed);
            try {
                this.map.put(Constants$Parameter.TargetPassword, this.getPasswordFromStash(CommandFactory.getStashFileName((String)this.map.get(Constants$Parameter.Target))));
            }
            catch (KeyManagerException keyManagerException) {
                if (keyManagerException.getReason() == KeyManagerException$ExceptionReason.INPUT_FILE_NOT_FOUND) {
                    try {
                        if (this.map.containsKey(Constants$Parameter.StashV1Password)) {
                            ByteSequenceXorFactory.stashKeyDbPwd((String)this.map.get(Constants$Parameter.Password), CommandFactory.getStashFileName((String)this.map.get(Constants$Parameter.Target)), true);
                        } else {
                            ByteSequenceXorFactory.stashKeyDbPwd((String)this.map.get(Constants$Parameter.Password), CommandFactory.getStashFileName((String)this.map.get(Constants$Parameter.Target)), false);
                        }
                    }
                    catch (IOException iOException) {
                        throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR);
                    }
                    this.map.put(Constants$Parameter.StashPassword, true);
                    this.map.put(Constants$Parameter.TargetPassword, this.map.get(Constants$Parameter.Password));
                }
                throw keyManagerException;
            }
        }
        this.loader = keyStoreLoaderFactory$KeyStoreLoader;
        Object object = null;
        try {
            object = this.run(this.map.getCommandParameters(), keyManagerEventListener, displayer);
        }
        catch (KeyManagerException keyManagerException) {
            if (keyManagerException.getMessage() != null && keyManagerException.getMessage().contains("TrustedCertEntry not supported")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NOT_SUPPORTED_ACTION);
            }
            throw keyManagerException;
        }
        finally {
            FilePermissions.setLogFilePermissions();
        }
        Debug.exiting(object);
        return object;
    }

    public String getUsageString() {
        Debug.entering();
        String string = this.validator.toString();
        string = string + "\n\n" + this.getDefaultsString();
        Debug.exiting(string);
        return string;
    }

    private String getDefaultsString() {
        Debug.entering();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.defaults != null) {
            stringBuffer.append(Messages.getString("Message.Defaults") + " ");
            Iterator iterator = this.defaults.keySet().iterator();
            while (iterator.hasNext()) {
                Constants$Parameter constants$Parameter = (Constants$Parameter)iterator.next();
                stringBuffer.append(constants$Parameter + " = " + this.defaults.get(constants$Parameter));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        Debug.exiting(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private String getPasswordFromStash(String string) throws KeyManagerException {
        ByteBuffer byteBuffer;
        Charset charset;
        CharBuffer charBuffer;
        byte[] byArray = new byte[193];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            if (((InputStream)fileInputStream).read(byArray) < 129) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_OBJECT, new String[]{string});
            }
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INPUT_FILE_NOT_FOUND, new String[]{string});
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR_MSG, new String[]{iOException.getMessage()});
        }
        byArray = AConverter.rr(byArray);
        int n = 0;
        for (int i = 0; i < 129; ++i) {
            byArray[i] = (byte)(byArray[i] ^ 0xF5);
            if (byArray[i] != 0 || n != 0) continue;
            n = i;
            break;
        }
        if (!(charBuffer = (charset = Charset.forName("UTF-8")).decode(byteBuffer = ByteBuffer.wrap(byArray, 0, n))).hasArray()) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_OBJECT, new String[]{string});
        }
        char[] cArray = new char[n];
        System.arraycopy(charBuffer.array(), 0, cArray, 0, n);
        Command.wipeArray(byArray);
        Command.wipeArray(charBuffer.array());
        return new String(cArray);
    }

    private static void wipeArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    private static void wipeArray(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
    }

    protected abstract ControlObjectFactory$ControlObject run(CommandParameters var1, KeyManagerEventListener var2, Displayer var3) throws KeyManagerException, CancelledException;
}

