/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

class CommandFactory$CreateCertRequestCommand
extends Command {
    private static final Map defaults = new HashMap();

    public CommandFactory$CreateCertRequestCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.DatabaseName, Constants$Parameter.Crypto}), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.RelativeSlotNumber, Constants$Parameter.TokenLabel}), ValidatorFactory.itemPresent(Constants$Parameter.Crypto)), ValidatorFactory.required(Constants$Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName)), ValidatorFactory.optional(Constants$Parameter.DN, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Size, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SigAlg, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanDnsName, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanEmailAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanIpAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.EKU, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.KU, ValidatorFactory.always())}), defaults);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        ControlObjectFactory$ControlObject controlObjectFactory$ControlObject;
        block3: {
            Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
            CommandFactory.access$000(commandParameters.getFile());
            KeyStoreItem keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
            if (keyStoreItem.getAliases().contains(commandParameters.getLabel())) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.ENTRY_EXISTS_FOR_LABEL, new String[]{commandParameters.getLabel()});
            }
            KeyPair keyPair = keyStoreItem.getKeyCreator().generateKeyPair(commandParameters);
            CertificateRequestKeyItem certificateRequestKeyItem = EntryFactory.newCertificateRequestItem(commandParameters, keyPair, commandParameters.getSigAlg().toString(), keyStoreItem.getKeyCreator().getProvider());
            keyStoreItem.add(certificateRequestKeyItem);
            controlObjectFactory$ControlObject = null;
            try {
                certificateRequestKeyItem.extract(commandParameters.getFile(), null);
                CommandFactory.access$100(commandParameters.getFile());
                this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
                controlObjectFactory$ControlObject = ControlObjectFactory.newMessage(MessageFormat.format(Messages.getString("Message.NewCertRequest"), commandParameters.getFile()));
            }
            catch (KeyManagerException keyManagerException) {
                if (certificateRequestKeyItem == null) break block3;
                keyStoreItem.delete(certificateRequestKeyItem);
                throw keyManagerException;
            }
        }
        Debug.exiting(controlObjectFactory$ControlObject);
        return controlObjectFactory$ControlObject;
    }

    static {
        defaults.put(Constants$Parameter.Size, KeymanSettings$Setting.DefaultKeySize.getInteger());
        defaults.put(Constants$Parameter.SigAlg, KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM);
    }
}

