/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandFactory$CompoundCommand;
import com.ibm.gsk.ikeyman.command.CommandFactory$FileDeletionCommand;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$ValidationCondition;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.KeyStoreItemFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS12DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.io.IOException;

class CommandFactory$CreateDbCommand
extends Command {
    public CommandFactory$CreateDbCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(Constants$Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.StashPassword, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Populate, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Label, ValidatorFactory.and(new ValidatorFactory$ValidationCondition[]{ValidatorFactory.itemPresent(Constants$Parameter.Populate)})), ValidatorFactory.optional(Constants$Parameter.StashV1Password, ValidatorFactory.always())}), null);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        KeyStoreItem keyStoreItem;
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        CommandFactory.access$000(commandParameters.getDatabaseName());
        ControlObjectFactory$ControlObject controlObjectFactory$ControlObject = null;
        DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor = null;
        try {
            databaseDescriptorFactory$DatabaseDescriptor = commandParameters.getSourceDescriptor(CommandFactory.access$200());
            FileName fileName = databaseDescriptorFactory$DatabaseDescriptor.getFileName();
            if (fileName.getFileExtension().equals("")) {
                fileName.setExtension(databaseDescriptorFactory$DatabaseDescriptor.getType().getDefaultExtension());
                databaseDescriptorFactory$DatabaseDescriptor.setFileName(fileName.toString());
            }
            keyStoreItem = KeyStoreItemFactory.createKeyStore(databaseDescriptorFactory$DatabaseDescriptor);
            if (databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12) || databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12S2)) {
                if (commandParameters.isParameterPresent(Constants$Parameter.StashPassword) || KeymanSettings$Setting.DefaultPasswordStashingState.getBoolean().booleanValue()) {
                    if (commandParameters.isParameterPresent(Constants$Parameter.StashV1Password) || KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue()) {
                        ByteSequenceXorFactory.stashKeyDbPwd(commandParameters.getPassword(), CommandFactory.getStashFileName(commandParameters.getDatabaseName()), true);
                    } else {
                        ByteSequenceXorFactory.stashKeyDbPwd(commandParameters.getPassword(), CommandFactory.getStashFileName(commandParameters.getDatabaseName()), false);
                    }
                } else if (((DatabaseDescriptorFactory$PKCS12DatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor).isUseStash()) {
                    if (((DatabaseDescriptorFactory$PKCS12DatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor).isUseV1Stash() || KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue()) {
                        ByteSequenceXorFactory.stashKeyDbPwd(databaseDescriptorFactory$DatabaseDescriptor.getPassword(), CommandFactory.getStashFileName(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString()), true);
                    } else {
                        ByteSequenceXorFactory.stashKeyDbPwd(databaseDescriptorFactory$DatabaseDescriptor.getPassword(), CommandFactory.getStashFileName(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString()), false);
                    }
                }
            }
            this.fireKeyManagerEventDatabaseOpened(keyManagerEventListener, keyStoreItem);
            Debug.exiting(null);
        }
        catch (KeyManagerException keyManagerException) {
            if (controlObjectsEnabled && keyManagerException.getReason() == KeyManagerException$ExceptionReason.OUTPUT_FILE_EXISTS) {
                CommandFactory$CompoundCommand commandFactory$CompoundCommand = new CommandFactory$CompoundCommand(new Command[]{new CommandFactory$FileDeletionCommand(new String[]{commandParameters.getDatabaseName()}), this});
                controlObjectFactory$ControlObject = ControlObjectFactory.newChoiceCommand(Messages.getString("Question.ReplaceExistingFile"), commandFactory$CompoundCommand, null);
                Debug.exiting(controlObjectFactory$ControlObject);
                ControlObjectFactory$ControlObject controlObjectFactory$ControlObject2 = controlObjectFactory$ControlObject;
                return controlObjectFactory$ControlObject2;
            }
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR);
        }
        finally {
            CommandFactory.access$100(commandParameters.getDatabaseName());
        }
        boolean bl = false;
        try {
            bl = commandParameters.isPopulate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
            CommandFactory.access$300(commandParameters, keyStoreItem);
            this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
        }
        return controlObjectFactory$ControlObject;
    }
}

