/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.util.Debug;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

class CommandFactory$CreateSecretKeyCommand
extends Command {
    public CommandFactory$CreateSecretKeyCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.DatabaseName, Constants$Parameter.Crypto}), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.RelativeSlotNumber, Constants$Parameter.TokenLabel}), ValidatorFactory.itemPresent(Constants$Parameter.Crypto)), ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Label, Constants$Parameter.LabelRange}), ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.KeyAlgorithm, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.KeySize, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName)), ValidatorFactory.optional(Constants$Parameter.EKU, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.KU, ValidatorFactory.always())}), null);
    }

    protected ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
        if (!keyStoreItem.supportsEntry(SecretKeyItem.class)) {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_TYPE_FOR_ACTION, new String[]{Constants$CommandType.CreateSecretKey.toString(), keyStoreItem.getDescriptor().getType().toString()});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        Map map = keyStoreItem.getKeyCreator().generateSecretKeys(commandParameters);
        Set set = map.keySet();
        for (String string : set) {
            SecretKeyItem secretKeyItem = EntryFactory.newSecretKey(string, (SecretKey)map.get(string));
            keyStoreItem.add(secretKeyItem);
        }
        this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
        Debug.exiting(null);
        return null;
    }
}

