/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.KeyUsageExtension;
import java.io.IOException;
import java.util.Vector;

class CommandFactory$RecreateCertRequestCommand
extends Command {
    public CommandFactory$RecreateCertRequestCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.DatabaseName, Constants$Parameter.Crypto}), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.RelativeSlotNumber, Constants$Parameter.TokenLabel}), ValidatorFactory.itemPresent(Constants$Parameter.Crypto)), ValidatorFactory.required(Constants$Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName)), ValidatorFactory.optional(Constants$Parameter.EKU, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.KU, ValidatorFactory.always())}), null);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        CommandFactory.access$000(commandParameters.getTarget());
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
        Entry entry = keyStoreItem.getItem(commandParameters.getLabel());
        if (entry instanceof CertificateKeyItem) {
            CertificateKeyItem certificateKeyItem = (CertificateKeyItem)entry;
            CertificateRequestKeyItem certificateRequestKeyItem = certificateKeyItem.toCertRequest(commandParameters, keyStoreItem.getKeyCreator().getProvider());
            certificateRequestKeyItem.extract(commandParameters.getTarget(), null);
        } else if (entry instanceof CertificateRequestItem) {
            CertificateRequestItem certificateRequestItem = (CertificateRequestItem)entry;
            try {
                KeyUsageExtension keyUsageExtension;
                Vector vector;
                CertificationRequestInfo certificationRequestInfo = certificateRequestItem.getRequest().getCertRequestInfo();
                Object object = certificationRequestInfo.getAttributes().getAttribute(PKCSOID.EXTENSION_REQUEST_OID);
                CertificateExtensions certificateExtensions = null;
                if (object != null) {
                    certificateExtensions = (CertificateExtensions)((PKCSAttribute)object).getAttributeValue();
                    try {
                        certificateExtensions.delete("ExtKeyUsage");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        certificateExtensions.delete("KeyUsage");
                    }
                    catch (Exception exception) {}
                } else {
                    certificateExtensions = new CertificateExtensions();
                }
                if ((vector = commandParameters.getExtendedKeyUsage()).size() > 0) {
                    certificateExtensions.set("ExtKeyUsage", (Object)new ExtKeyUsageExtension(vector));
                }
                if ((keyUsageExtension = commandParameters.getKeyUsage()) != null) {
                    certificateExtensions.set("KeyUsage", (Object)keyUsageExtension);
                }
                keyStoreItem.delete(entry);
                keyStoreItem.add(certificateRequestItem);
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_OPERATION, new String[]{commandParameters.getLabel()});
            }
            certificateRequestItem.extract(commandParameters.getTarget(), null);
        } else {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ENTRY_TYPE, new String[]{commandParameters.getLabel()});
        }
        CommandFactory.access$100(commandParameters.getTarget());
        this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
        Debug.exiting(null);
        return null;
    }
}

