/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.cli;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.Constants$CommandObject;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.cli.CommandParser$CommandTypeParser;
import com.ibm.gsk.ikeyman.command.cli.CommandParser$ExtendedCommandTypeParser;
import com.ibm.gsk.ikeyman.command.cli.CommandParser$SimpleCommandTypeParser;
import com.ibm.gsk.ikeyman.command.cli.ExtractorFactory$Extractor;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory$Token;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory$Tokeniser;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory$TokeniserItem;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CommandParser {
    private ParameterMap parameters;
    private static final List commandTypeParsers = new ArrayList();
    private static final List parameterExtractors = new ArrayList();

    public Command getCommand() throws KeyManagerException {
        return CommandFactory.getCommand(this.parameters);
    }

    public static String getProgramUsage() {
        StringBuffer stringBuffer = new StringBuffer(CommandParser$CommandTypeParser.getUsageHeader());
        for (CommandParser$CommandTypeParser commandParser$CommandTypeParser : commandTypeParsers) {
            stringBuffer.append(commandParser$CommandTypeParser.getUsage());
        }
        return stringBuffer.toString();
    }

    public static CommandParser parseCommand(String[] stringArray) throws KeyManagerException {
        Debug.entering(stringArray);
        Object[] objectArray = new String[stringArray.length];
        boolean bl = false;
        String string = "";
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-size")) {
                bl = true;
                if (stringArray.length <= i + 1 || stringArray[i + 1].startsWith("-")) continue;
                string = stringArray[++i];
                continue;
            }
            objectArray[n++] = stringArray[i];
        }
        if (bl) {
            objectArray[n] = "-size";
            if (objectArray.length > n + 1) {
                objectArray[n + 1] = string;
            }
        }
        TokeniserFactory$Tokeniser tokeniserFactory$Tokeniser = TokeniserFactory.newArrayTokeniser(new TokeniserFactory$TokeniserItem[]{TokeniserFactory.newSimpleTokeniser(2), TokeniserFactory.newParameterTokeniser("-")});
        Stack stack = tokeniserFactory$Tokeniser.tokenise(objectArray);
        CommandParser commandParser = new CommandParser();
        commandParser.parse(stack);
        Debug.exiting(commandParser);
        return commandParser;
    }

    private CommandParser$CommandTypeParser getParser(String string) {
        for (CommandParser$CommandTypeParser commandParser$CommandTypeParser : commandTypeParsers) {
            if (!commandParser$CommandTypeParser.canParse(string)) continue;
            return commandParser$CommandTypeParser;
        }
        return null;
    }

    private void parse(Stack stack) throws KeyManagerException {
        Debug.entering(new Object[]{stack});
        if (stack.isEmpty()) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_OPTIONS_SPECIFIED, new String[]{CommandParser.getProgramUsage()});
        }
        TokeniserFactory$Token tokeniserFactory$Token = (TokeniserFactory$Token)stack.pop();
        CommandParser$CommandTypeParser commandParser$CommandTypeParser = this.getParser((String)tokeniserFactory$Token.getTag());
        if (commandParser$CommandTypeParser == null) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_OBJECT, new String[]{CommandParser.getProgramUsage(), (String)tokeniserFactory$Token.getTag()});
        }
        Constants$CommandType constants$CommandType = commandParser$CommandTypeParser.getCommandType(stack);
        Debug.log("command type = {0}", new Object[]{constants$CommandType});
        this.parameters = new ParameterMap(constants$CommandType);
        this.parseParameters(stack);
        Debug.exiting();
    }

    private void parseParameters(Stack stack) throws KeyManagerException {
        Debug.entering(new Object[]{stack});
        while (!stack.isEmpty()) {
            Debug.log("next token: {0}", new Object[]{stack.peek()});
            ExtractorFactory$Extractor extractorFactory$Extractor = this.getExtractor((TokeniserFactory$Token)stack.peek());
            extractorFactory$Extractor.extract(stack, this.parameters);
        }
        Debug.exiting();
    }

    private ExtractorFactory$Extractor getExtractor(TokeniserFactory$Token tokeniserFactory$Token) throws KeyManagerException {
        for (ExtractorFactory$Extractor extractorFactory$Extractor : parameterExtractors) {
            if (!extractorFactory$Extractor.canExtract(tokeniserFactory$Token)) continue;
            return extractorFactory$Extractor;
        }
        this.parameters.getCommandType();
        throw new KeyManagerException(KeyManagerException$ExceptionReason.UNKNOWN_PARAMETER, new String[]{(String)tokeniserFactory$Token.getTag(), CommandFactory.getCommand(this.parameters).getUsageString()});
    }

    public ParameterMap getParameters() {
        return this.parameters;
    }

    static {
        for (Constants$CommandObject enum_ : new Constants$CommandObject[]{Constants$CommandObject.KeyDB, Constants$CommandObject.Cert, Constants$CommandObject.CertReq, Constants$CommandObject.SecKey}) {
            if (!enum_.isEnabled()) continue;
            commandTypeParsers.add(new CommandParser$ExtendedCommandTypeParser(enum_));
        }
        for (Constants$CommandObject constants$CommandObject : new Constants$CommandObject[]{Constants$CommandObject.Version, Constants$CommandObject.Locale, Constants$CommandObject.Help}) {
            if (!constants$CommandObject.isEnabled()) continue;
            commandTypeParsers.add(new CommandParser$SimpleCommandTypeParser(constants$CommandObject));
        }
        for (Enum enum_ : Constants$Parameter.values()) {
            ExtractorFactory$Extractor extractorFactory$Extractor = ((Constants$Parameter)enum_).getExtractor();
            if (extractorFactory$Extractor == null) continue;
            parameterExtractors.add(extractorFactory$Extractor);
        }
    }
}

