/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory$EntryBag;
import com.ibm.gsk.ikeyman.keystore.EntryFilterFactory$EntryFilter;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$KeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ProtectionParameterCreatorFactory$ProtectionParameterCreator;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

abstract class EntryBagFactory$AbstractKeyStoreBag
implements EntryBagFactory$EntryBag {
    protected KeyStoreProxyCreatorFactory$KeyStoreProxy keyStore;
    protected EntryFilterFactory$EntryFilter entryFilter;
    protected Collection aliases;
    protected ProtectionParameterCreatorFactory$ProtectionParameterCreator protectionCreater;
    protected String password;

    public EntryBagFactory$AbstractKeyStoreBag(KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxy, EntryFilterFactory$EntryFilter entryFilter, ProtectionParameterCreatorFactory$ProtectionParameterCreator protectionParameterCreator, String string) throws KeyManagerException {
        this.keyStore = keyStoreProxy;
        this.entryFilter = entryFilter;
        this.protectionCreater = protectionParameterCreator;
        this.password = string;
        this.refreshAliases();
    }

    public void add(Entry entry) throws KeyManagerException {
        this.setKeyStoreEntry(entry.getLabel(), entry.toKeyStoreEntry(), this.protectionCreater.getParameter(this.password));
    }

    private void setKeyStoreEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyManagerException {
        try {
            this.keyStore.getKeyStore().setEntry(string, entry, protectionParameter);
            this.keyStore.setHasChanged(true);
            this.refreshAliases();
        }
        catch (KeyStoreException keyStoreException) {
            String string2 = KeymanUtil.getStackTraceString(keyStoreException);
            if (string2.contains("Illegal key size")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)keyStoreException);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_STORE_ENTRY_SET_ERROR, keyStoreException, new String[]{string});
        }
    }

    protected void refreshAliases() throws KeyManagerException {
        try {
            ArrayList<String> arrayList = Collections.list(this.keyStore.getKeyStore().aliases());
            this.aliases = new TreeSet(ComparatorFactory.newCollatedStringComparator());
            for (String string : arrayList) {
                if (!this.entryFilter.isEntry(this.keyStore.getKeyStore(), string, this.password)) continue;
                this.aliases.add(string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
    }

    protected void deleteAliaseswithLabel(String string) throws KeyManagerException {
    }

    public void delete(String string) throws KeyManagerException {
        try {
            if (!this.contains(string)) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_ENTRY_FOR_LABEL, new String[]{string});
            }
            this.keyStore.getKeyStore().deleteEntry(string);
            this.keyStore.setHasChanged(true);
            this.deleteAliaseswithLabel(string);
            this.refreshAliases();
        }
        catch (KeyStoreException keyStoreException) {
            if (keyStoreException.getMessage().contains("Uninitialized")) {
                throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.DELETION_FAILED, keyStoreException, new String[]{string});
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PKCS11_ERROR, pKCS11Exception, new String[]{string, pKCS11Exception.getMessage()});
        }
    }

    public void delete(Entry entry) throws KeyManagerException {
        try {
            this.delete(entry.getLabel());
        }
        catch (KeyManagerException keyManagerException) {
            if (keyManagerException.getReason() == KeyManagerException$ExceptionReason.NO_ENTRY_FOR_LABEL) {
                return;
            }
            throw keyManagerException;
        }
    }

    public boolean contains(String string) {
        boolean bl = this.aliases.contains(string);
        return bl;
    }

    public Entry getItem(String string) throws KeyManagerException {
        if (this.getAliases().contains(string)) {
            Entry entry = this.makeEntry(string);
            return entry;
        }
        throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_ENTRY_FOR_LABEL, new String[]{string});
    }

    public Collection getItems() throws KeyManagerException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (String string : this.aliases) {
            arrayList.add(this.getItem(string));
        }
        return arrayList;
    }

    public void refresh() throws KeyManagerException {
        this.refreshAliases();
    }

    public Collection getAliases() {
        return this.aliases;
    }

    public void changePassword(CommandParameters commandParameters) throws KeyManagerException {
        if (commandParameters.isParameterPresent(Constants$Parameter.NewPassword)) {
            this.password = commandParameters.getNewPassword();
            this.keyStore.setHasChanged(true);
        }
    }

    public boolean needsRefresh() {
        boolean bl = this.keyStore.needsRefresh();
        return bl;
    }

    public int compare(Entry entry, Entry entry2) {
        return entry.compareTo(entry2);
    }

    public EntryBagFactory$EntryBag getEntryBag(Class clazz) {
        if (this.getSupportedTypes().contains(clazz)) {
            return this;
        }
        return null;
    }

    protected abstract Entry makeEntry(String var1) throws KeyManagerException;

    public int compare(Object object, Object object2) {
        return this.compare((Entry)object, (Entry)object2);
    }
}

