/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType$SupportType;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.PKCS11TokenInfo;
import com.ibm.pkcs11.nat.NativePKCS11;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class KeymanUtil {
    private static final String IBMJCE_PROVIDER_NAME = "IBMJCE";
    private static final String SUNJCE_PROVIDER_NAME = "SunJCE";
    private static final String SUN_PROVIDER_NAME = "SUN";
    private static final String JCE_PROVIDER_FIPS_NAME = "IBMJCEFIPS";
    public static final String DSA_TYPE = "DSA";
    public static final String EC_TYPE = "EC";
    public static final String RSA_TYPE = "RSA";
    private static final String PKCS11_PREFIX = "IBMPKCS11Impl-";
    private static String hostName = null;
    private static String JCEProvider = null;
    private static String SUNProvider = null;
    private static Comparator comparator = ComparatorFactory.newCollatedStringComparator();
    private static final String SECURE_RANDOM_IBM = "IBMSecureRandom";
    private static final String SECURE_RANDOM_ORACLE = "SHA1PRNG";
    private static final String X509_FORMAT_IBM = "X509";
    private static final String X509_FORMAT_ORACLE = "X.509";
    private static final boolean IBMJCE_FOUND = KeymanUtil.checkForIBMJCEProvider();
    private static final Map algorithmOIDs = new TreeMap(ComparatorFactory.newIgnoreCaseStringComparator());
    public static final String[] ISO_3166_ORDERED_COUNTRY_CODES = new String[]{"  ", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZR", "ZW"};
    private static final String KEY_STORE_PREFIX = "KeyStore.";
    private static final String CMS_PROVIDER_CLASSNAME = "com.ibm.security.cmskeystore.CMSProvider";

    private static boolean isIBMJava() {
        Provider[] providerArray;
        for (Provider provider : providerArray = Security.getProviders()) {
            if (!provider.getName().startsWith(IBMJCE_PROVIDER_NAME) && !provider.getName().startsWith("IBMJSSE2") && !provider.getName().startsWith("IBMJGSSProvider") && !provider.getName().startsWith("IBMCertPath")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForIBMJCEProvider() {
        Provider[] providerArray;
        for (Provider provider : providerArray = Security.getProviders()) {
            Debug.log("Checking provider {0}", new Object[]{provider});
            if (!provider.getName().startsWith(IBMJCE_PROVIDER_NAME) || Security.getProvider(provider.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isIBMJCE() {
        return IBMJCE_FOUND;
    }

    public static String getSecureRandomAlgIBM() {
        return SECURE_RANDOM_IBM;
    }

    public static String getSecureRandomAlgOracle() {
        return SECURE_RANDOM_ORACLE;
    }

    public static String getX509FormatIBM() {
        return X509_FORMAT_IBM;
    }

    public static String getX509FormatOracle() {
        return X509_FORMAT_ORACLE;
    }

    public static String getIndentedString(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        return string;
    }

    public static String getLocalisedColon() {
        if (Locale.getDefault().getLanguage().equals(new Locale("fr", "", "").getLanguage())) {
            return " :";
        }
        return ":";
    }

    public static String getLocalisedDateTimeToString(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(date);
    }

    public static String getLocalisedDateToString(Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        return dateFormat.format(date);
    }

    public static String getSupportedDatabaseTypes() {
        Constants$DatabaseType[] constants$DatabaseTypeArray;
        String string = "";
        for (Constants$DatabaseType constants$DatabaseType : constants$DatabaseTypeArray = Constants$DatabaseType.values(Constants$DatabaseType$SupportType.Opening)) {
            string = string + constants$DatabaseType + "\n";
        }
        return string;
    }

    public static Provider[] getProviders() {
        return Security.getProviders();
    }

    public static String[] getProviderList() {
        Provider[] providerArray = KeymanUtil.getProviders();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        for (Provider provider : providerArray) {
            arrayList.add(n++ + ". " + provider.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getHostName() {
        if (hostName == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                InetAddress inetAddress2 = InetAddress.getByName(inetAddress.getHostAddress());
                hostName = inetAddress2.getHostName();
                String string = System.getProperty("os.name");
                if (string != null && string.startsWith("Windows 9")) {
                    try {
                        ServerSocket serverSocket = new ServerSocket(11111);
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                hostName = "";
            }
        }
        return hostName;
    }

    public static String getJCEProviderName() {
        Debug.entering();
        if (JCEProvider == null) {
            if (IBMJCE_FOUND) {
                if (KeymanSettings$Setting.DefaultFIPSModeProcessing.getBoolean().booleanValue()) {
                    JCEProvider = JCE_PROVIDER_FIPS_NAME;
                } else {
                    Provider[] providerArray = Security.getProviders();
                    boolean bl = false;
                    for (Provider provider : providerArray) {
                        Debug.log("Checking provider {0}", new Object[]{provider});
                        if (provider.getName().startsWith("IBMCMSProvider")) {
                            bl = true;
                            continue;
                        }
                        if (provider.getName().startsWith(JCE_PROVIDER_FIPS_NAME)) {
                            JCEProvider = JCE_PROVIDER_FIPS_NAME;
                            break;
                        }
                        if (!provider.getName().startsWith(IBMJCE_PROVIDER_NAME)) continue;
                        JCEProvider = IBMJCE_PROVIDER_NAME;
                        break;
                    }
                    if (!bl) {
                        // empty if block
                    }
                }
                if (Security.getProvider(JCEProvider) == null) {
                    JCEProvider = null;
                }
            } else {
                JCEProvider = SUNJCE_PROVIDER_NAME;
                SUNProvider = SUN_PROVIDER_NAME;
                if (Security.getProvider(SUNJCE_PROVIDER_NAME) == null) {
                    JCEProvider = null;
                }
                if (Security.getProvider(SUNProvider) == null) {
                    SUNProvider = null;
                }
                if (JCEProvider == null || SUNProvider == null) {
                    JCEProvider = null;
                }
            }
        }
        Debug.exiting(JCEProvider);
        return JCEProvider;
    }

    public static void validateJCEProvider() throws KeyManagerException {
        if (KeymanUtil.getJCEProviderName() == null) {
            if (KeymanUtil.isIBMJava()) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_JCE_PROVIDER, new String[]{KeymanSettings$Setting.DefaultFIPSModeProcessing.getBoolean() != false ? JCE_PROVIDER_FIPS_NAME : IBMJCE_PROVIDER_NAME, KeymanSettings$Setting.DefaultFIPSModeProcessing.getPropertyKey()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_JCE_PROVIDER, new String[]{SUNProvider == null ? SUN_PROVIDER_NAME : SUNJCE_PROVIDER_NAME, ""});
        }
    }

    public static ObjectIdentifier getAlgorithmOid(String string) throws KeyManagerException {
        if (algorithmOIDs.containsKey(string)) {
            return (ObjectIdentifier)algorithmOIDs.get(string);
        }
        try {
            return AlgorithmId.get((String)string).getOID();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{string});
        }
    }

    public static String getCmsVersion() {
        Provider provider = Security.getProvider("IBMCMSProvider");
        return provider == null ? Messages.getString("Label.NoCMSProvider") : Messages.getString("Label.CMSProviderVersion") + " 2." + (int)provider.getVersion();
    }

    public static String getJavaVersion() {
        return Messages.getString("Label.JavaVersion") + " " + System.getProperty("java.version");
    }

    public static String getKeyType(String string) {
        if (string.contains("ECDSA")) {
            return EC_TYPE;
        }
        if (string.contains(DSA_TYPE)) {
            return DSA_TYPE;
        }
        return RSA_TYPE;
    }

    public static String getKeyType() {
        return KeymanUtil.getKeyType(KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM);
    }

    public static AlgorithmId getSignatureAlgorithm(String string) throws KeyManagerException {
        try {
            return AlgorithmId.get((String)string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, new String[]{string, noSuchAlgorithmException.getMessage()});
        }
    }

    public static String getSignatureDigest(PrivateKey privateKey, String string) throws KeyManagerException {
        try {
            AlgorithmId algorithmId = AlgorithmId.get((String)string);
            String string2 = KeymanUtil.isPKCS11Key(privateKey) ? "PKCS11Direct" : "";
            return string2 + algorithmId.getName();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.toString()});
        }
    }

    private static boolean isPKCS11Key(PrivateKey privateKey) {
        return privateKey.getClass().toString().toLowerCase().contains("pkcs11") && !privateKey.getClass().toString().toLowerCase().contains("pkcs11impl");
    }

    private static String match(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return string2;
        }
        return stringArray[0];
    }

    public static char getHotKeyChar(String string) {
        int n = string.indexOf("&");
        if (n != -1) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    public static String getMenuItemLabel(String string) {
        return string.replace("&", "");
    }

    public static boolean isMacSystem() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static boolean isWindowsSystem() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static Collection getPKCS11TokenList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("")) {
            Provider[] providerArray;
            for (Provider provider : providerArray = Security.getProviders()) {
                if (!provider.getName().startsWith(PKCS11_PREFIX)) continue;
                arrayList.add(provider.getName().substring(PKCS11_PREFIX.length()));
            }
        } else {
            PKCS11Slot[] pKCS11SlotArray;
            NativePKCS11 nativePKCS11 = new NativePKCS11(string);
            nativePKCS11.libInitialize();
            for (PKCS11Slot pKCS11Slot : pKCS11SlotArray = nativePKCS11.getSlotList(true)) {
                PKCS11TokenInfo pKCS11TokenInfo = pKCS11Slot.getTokenInfo();
                String string2 = pKCS11TokenInfo.label();
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static int compareStrings(String string, String string2) {
        return comparator.compare(string, string2);
    }

    public static String getVersionString() {
        String string = KeymanSettings.PROGRAM_VERSION;
        String string2 = KeymanUtil.getCmsVersion();
        String string3 = KeymanUtil.getJavaVersion();
        return string + "\n" + string2 + "\n" + string3 + "\n\n" + Messages.getString("Message.Copyright") + "\n" + Messages.getString("Message.Copyright2");
    }

    public static String[] parseJvmArgs(String[] stringArray) throws KeyManagerException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        String[] stringArray2 = stringArray;
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            if (bl && string.startsWith("-D")) {
                String string2;
                Scanner scanner = new Scanner(new StringReader(string.substring(2)));
                scanner.useDelimiter("=");
                String string3 = scanner.hasNext() ? scanner.next() : null;
                String string4 = string2 = scanner.hasNext() ? scanner.next() : null;
                if (string3 != null && string2 != null) {
                    System.setProperty(string3, string2);
                    continue;
                }
                KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_VALUE_FOR_PARAMETER, new String[]{"-D<property name>=<value>", string});
                Debug.throwing(keyManagerException);
                throw keyManagerException;
            }
            bl = false;
            if (!bl2 && !bl3 && string.equals("-locale")) {
                bl2 = true;
                continue;
            }
            if (bl2 && !bl3) {
                bl3 = true;
                KeymanSettings.LOCALE = new Locale(string);
                KeymanSettings.USE_LOCALE = true;
                continue;
            }
            vector.add(string);
        }
        if (!vector.isEmpty()) {
            stringArray2 = new String[vector.size()];
            vector.toArray(stringArray2);
        }
        Debug.init();
        return stringArray2;
    }

    public static int computeKeySize(PublicKey publicKey) {
        int n = 0;
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n = ((DSAPublicKey)publicKey).getY().bitLength();
        } else if (publicKey instanceof ECPublicKey) {
            n = ((ECPublicKey)publicKey).getParams().getCurve().getA().bitLength();
        }
        return n;
    }

    public static void addCMSProvider() throws KeyManagerException {
        Object obj;
        Object object;
        Class<?> clazz;
        String string = CMS_PROVIDER_CLASSNAME.toString();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CLASS_NOT_FOUND, classNotFoundException, new String[]{string});
        }
        try {
            object = clazz.getConstructor(new Class[0]);
            obj = ((Constructor)object).newInstance(new String[0]);
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CANNOT_INSTANTIATE_OBJECT, exception, new String[]{string});
        }
        if (obj instanceof Provider) {
            object = (Provider)obj;
            int n = Security.addProvider((Provider)object);
            Set<Object> set = ((Provider)object).keySet();
            for (String string2 : set) {
                if (!string2.startsWith(KEY_STORE_PREFIX)) continue;
                String string3 = string2.substring(KEY_STORE_PREFIX.length());
                try {
                    KeyStore.getInstance(string3, ((Provider)object).getName());
                    break;
                }
                catch (Exception exception) {
                    Security.removeProvider(((Provider)object).getName());
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_STORE_INSTANTIATION_ERROR, exception, new String[]{string3});
                }
            }
        }
    }

    static {
        algorithmOIDs.put("SHA256withRSA", AlgorithmId.sha256WithRSAEncryption_oid);
        algorithmOIDs.put("SHA384withRSA", AlgorithmId.sha384WithRSAEncryption_oid);
        algorithmOIDs.put("SHA512withRSA", AlgorithmId.sha512WithRSAEncryption_oid);
    }
}

