/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.security.capi.JarVerifierImpl;
import com.ibm.security.capi.Key;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.action.PutAllAction;

public final class IBMCAC
extends Provider {
    private static final long serialVersionUID = 8622598936488630849L;
    private static final String INFO = "IBM Crypto API for CAC JCE provider";
    static boolean debug = false;
    static String DEBUGHEADER = "IBMCAC-";
    private static volatile boolean integrityVerified;

    public IBMCAC() {
        super("IBMCAC", 1.0, INFO);
        Map<Object, Object> map = System.getSecurityManager() == null ? this : new HashMap();
        map.put("SecureRandom.Windows-PRNG", "com.ibm.security.capi.PRNG");
        map.put("KeyStore.Windows-MY", "com.ibm.security.capi.KeyStore$MY");
        map.put("KeyStore.Windows-ROOT", "com.ibm.security.capi.KeyStore$ROOT");
        map.put("KeyStore.WIExplorerMy", "com.ibm.security.capi.KeyStore$MY");
        map.put("Signature.SHA1withRSA", "com.ibm.security.capi.RSASignature$SHA1");
        map.put("Signature.SHA256withRSA", "com.ibm.security.capi.RSASignature$SHA256");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA256withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", "SHA256withRSA");
        map.put("Signature.SHA384withRSA", "com.ibm.security.capi.RSASignature$SHA384");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", "SHA384withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", "SHA384withRSA");
        map.put("Signature.SHA512withRSA", "com.ibm.security.capi.RSASignature$SHA512");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", "SHA512withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", "SHA512withRSA");
        map.put("Signature.MD5withRSA", "com.ibm.security.capi.RSASignature$MD5");
        map.put("Signature.MD2withRSA", "com.ibm.security.capi.RSASignature$MD2");
        map.put("Signature.NONEwithRSA", "com.ibm.security.capi.RSASignature$Raw");
        map.put("Signature.RSAforSSL", "com.ibm.security.capi.RSASignature$Raw");
        map.put("Signature.SHA1withRSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.SHA256withRSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.SHA384withRSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.SHA512withRSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.MD5withRSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.MD2withRSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.RSAforSSL SupportedKeyClasses", "com.ibm.security.capi.Key");
        map.put("Signature.SHA1withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA256withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA384withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA512withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.MD5withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.MD2withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.NONEwithRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.RSAforSSL SupportedKeyFormats", "MSCAPI");
        map.put("KeyPairGenerator.RSA", "com.ibm.security.capi.RSAKeyPairGenerator");
        map.put("KeyPairGenerator.RSA KeySize", "2048");
        map.put("Cipher.RSA", "com.ibm.security.capi.RSACipher");
        map.put("Cipher.RSA/ECB/PKCS1Padding", "com.ibm.security.capi.RSACipher");
        map.put("Cipher.RSA SupportedModes", "ECB");
        map.put("Cipher.RSA SupportedPaddings", "PKCS1PADDING");
        map.put("Cipher.RSA SupportedKeyClasses", "com.ibm.security.capi.Key");
        if (map != this) {
            AccessController.doPrivileged(new PutAllAction(this, map));
        }
    }

    static void verifySelfIntegrity(Class c) {
        if (integrityVerified) {
            return;
        }
        IBMCAC.doVerifySelfIntegrity(c);
    }

    private static synchronized void doVerifySelfIntegrity(Class c) {
        String CERT = "-----BEGIN CERTIFICATE-----\nMIIDVzCCAxWgAwIBAgIEQCFoGzALBgcqhkjOOAQDBQAwYDELMAkGA1UEBhMCVVMxGDAWBgNVBAoTD0lCTSBDb3Jwb3JhdGlvbjEZMBcGA1UECxMQSUJNIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0xMjEwMTExNDQ4NTJaFw0xODEwMTAxNDQ4NTJaMGgxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9JQk0gQ29ycG9yYXRpb24xGTAXBgNVBAsTEElCTSBDb2RlIFNpZ25pbmcxJDAiBgNVBAMTG0lCTSBDb2RlIFNpZ25pbmcgLSBQcm92aWRlcjCCAbgwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3UjzvRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7qdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8VIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrUWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEkO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GFAAKBgQCNJlh24PDu1Qy/3LQSKu9NAgQPTgETn4Uf2BXvAE6XvIRviEegg4WXtAZ3cF2maflCYFS6IyRewu9VD3aZwy6qZoKbeu1du/lEYdGEOftH3C7m6+CwwKWSMB3UEGyF1HS71NiDcEmVmKbsAaTQa8p1oHQa5mnnhbcXOWR4bqtOrKNTMFEwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUxNfMP3n5xnMAp4AiwoyVTZ9AdEowHwYDVR0jBBgwFoAUxNfMP3n5xnMAp4AiwoyVTZ9AdEowCwYHKoZIzjgEAwUAAy8AMCwCFDYX7PqxuIaWqrGPaDWma2H3rFcPAhRmRKCpRG4W7VcdsEtAPZKTgF4Dvw==\n-----END CERTIFICATE-----";
        integrityVerified = JarVerifierImpl.doVerification(c, "-----BEGIN CERTIFICATE-----\nMIIDVzCCAxWgAwIBAgIEQCFoGzALBgcqhkjOOAQDBQAwYDELMAkGA1UEBhMCVVMxGDAWBgNVBAoTD0lCTSBDb3Jwb3JhdGlvbjEZMBcGA1UECxMQSUJNIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0xMjEwMTExNDQ4NTJaFw0xODEwMTAxNDQ4NTJaMGgxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9JQk0gQ29ycG9yYXRpb24xGTAXBgNVBAsTEElCTSBDb2RlIFNpZ25pbmcxJDAiBgNVBAMTG0lCTSBDb2RlIFNpZ25pbmcgLSBQcm92aWRlcjCCAbgwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3UjzvRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7qdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8VIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrUWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEkO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GFAAKBgQCNJlh24PDu1Qy/3LQSKu9NAgQPTgETn4Uf2BXvAE6XvIRviEegg4WXtAZ3cF2maflCYFS6IyRewu9VD3aZwy6qZoKbeu1du/lEYdGEOftH3C7m6+CwwKWSMB3UEGyF1HS71NiDcEmVmKbsAaTQa8p1oHQa5mnnhbcXOWR4bqtOrKNTMFEwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUxNfMP3n5xnMAp4AiwoyVTZ9AdEowHwYDVR0jBBgwFoAUxNfMP3n5xnMAp4AiwoyVTZ9AdEowCwYHKoZIzjgEAwUAAy8AMCwCFDYX7PqxuIaWqrGPaDWma2H3rFcPAhRmRKCpRG4W7VcdsEtAPZKTgF4Dvw==\n-----END CERTIFICATE-----");
        if (!integrityVerified) {
            throw new ProviderException("The IBMCAC provider may have been tampered with.");
        }
    }

    private static String getDebugDate(String className) {
        String versionDate = "Unknown";
        try {
            Class<?> thisClass = Class.forName(className);
            Package thisPackage = thisClass.getPackage();
            String versionInfo = thisPackage.getImplementationVersion();
            int index = versionInfo.indexOf("_");
            versionDate = versionInfo.substring(index + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versionDate;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("ibmcac");
                debug = Boolean.getBoolean("com.ibm.security.cac.debug");
                if (debug) {
                    System.out.println("IBMCAC Build-Level: -" + IBMCAC.getDebugDate("com.ibm.security.capi.IBMCAC"));
                    System.out.println("loading IBMCAC provider");
                }
                return null;
            }
        });
    }

    private static class IBMCACService
    extends Provider.Service {
        private final Provider provider;
        private final String algorithm;

        IBMCACService(Provider provider, String type, String algorithm, String className, String[] al) {
            super(provider, type, algorithm, className, IBMCACService.toList(al), null);
            this.provider = provider;
            this.algorithm = algorithm;
        }

        private static List<String> toList(String[] aliases) {
            return aliases == null ? null : Arrays.asList(aliases);
        }

        @Override
        public boolean supportsParameter(Object param) {
            if (param == null) {
                return false;
            }
            if (!(param instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String alg = this.getAlgorithm();
            String type = this.getType();
            Key key = (Key)param;
            String keyAlg = key.getAlgorithm();
            return key instanceof Key;
        }

        @Override
        public String toString() {
            return super.toString() + "\nprovider = " + this.provider + "\nalgorithm = " + this.algorithm;
        }
    }
}

