/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class JarVerifierImpl {
    private static final boolean debug = false;
    private URL jarURL;

    JarVerifierImpl(URL jarURL) {
        this.jarURL = jarURL;
    }

    void verify(X509Certificate trustedSigner) throws JarException, IOException {
        try {
            this.verifyJars(this.jarURL, null, trustedSigner);
        }
        catch (NoSuchProviderException nspe) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException ce) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
    }

    private void verifyJars(URL jarURL, Vector verifiedJarsCache, X509Certificate trustedSigner) throws NoSuchProviderException, CertificateException, IOException {
        String jarURLString = jarURL.toString();
        if (verifiedJarsCache == null || !verifiedJarsCache.contains(jarURLString)) {
            String supportingJars = this.verifySingleJar(jarURL, trustedSigner);
            if (verifiedJarsCache != null) {
                verifiedJarsCache.addElement(jarURLString);
            }
            if (supportingJars != null) {
                if (verifiedJarsCache == null) {
                    verifiedJarsCache = new Vector<String>();
                    verifiedJarsCache.addElement(jarURLString);
                }
                this.verifyManifestClassPathJars(jarURL, supportingJars, verifiedJarsCache, trustedSigner);
            }
        }
    }

    private void verifyManifestClassPathJars(URL baseURL, String supportingJars, Vector verifiedJarsCache, X509Certificate trustedSigner) throws NoSuchProviderException, CertificateException, IOException {
        String[] jarFileNames = JarVerifierImpl.parseAttrClasspath(supportingJars);
        try {
            for (int i = 0; i < jarFileNames.length; ++i) {
                URL url = new URL(baseURL, jarFileNames[i]);
                this.verifyJars(url, verifiedJarsCache, trustedSigner);
            }
        }
        catch (MalformedURLException mue) {
            MalformedURLException ex = new MalformedURLException("The JAR file " + baseURL.toString() + " contains invalid URLs in its Class-Path attribute");
            ex.initCause(mue);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifySingleJar(URL jarURL, X509Certificate trustedSigner) throws NoSuchProviderException, CertificateException, IOException {
        final URL url = jarURL.getProtocol().equalsIgnoreCase("jar") ? jarURL : new URL("jar:" + jarURL.toString() + "!/");
        JarFile jf = null;
        try {
            try {
                jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        return conn.getJarFile();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                SecurityException se = new SecurityException("Cannot verify " + url.toString());
                se.initCause(pae);
                throw se;
            }
            byte[] buffer = new byte[8192];
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                entriesVec.addElement(je);
                try (InputStream is = jf.getInputStream(je);){
                    int n;
                    while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                    }
                }
            }
            Manifest man = jf.getManifest();
            if (man == null) {
                throw new JarException(jarURL.toString() + " is not signed.");
            }
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                X509Certificate[] certChain;
                JarEntry je = e.nextElement();
                if (je.isDirectory()) continue;
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    if (je.getName().startsWith("META-INF")) continue;
                    throw new JarException(jarURL.toString() + " has unsigned entries - " + je.getName());
                }
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = JarVerifierImpl.getAChain(certs, startIndex)) != null) {
                    if (trustedSigner.equals(certChain[0])) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                throw new JarException(jarURL.toString() + " is not signed by a trusted signer.");
            }
            String string = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            return string;
        }
        finally {
            if (jf != null) {
                jf = null;
            }
        }
    }

    private static String[] parseAttrClasspath(String supportingJars) throws JarException {
        supportingJars = supportingJars.trim();
        int endIndex = supportingJars.indexOf(32);
        String name = null;
        Vector<String> values = new Vector<String>();
        boolean done = false;
        do {
            if (endIndex > 0) {
                name = supportingJars.substring(0, endIndex);
                supportingJars = supportingJars.substring(endIndex + 1).trim();
                endIndex = supportingJars.indexOf(32);
            } else {
                name = supportingJars;
                done = true;
            }
            if (!name.endsWith(".jar")) {
                throw new JarException("The provider contains un-verifiable components");
            }
            values.addElement(name);
        } while (!done);
        Object[] result = new String[values.size()];
        values.copyInto(result);
        return result;
    }

    private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
        int i;
        if (startIndex > certs.length - 1) {
            return null;
        }
        for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
        }
        int certChainSize = i - startIndex + 1;
        X509Certificate[] ret = new X509Certificate[certChainSize];
        for (int j = 0; j < certChainSize; ++j) {
            ret[j] = (X509Certificate)certs[startIndex + j];
        }
        return ret;
    }

    static boolean doVerification(final Class cc, String PROVIDERCERT) {
        X509Certificate providerCert;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            byte[] b = PROVIDERCERT.getBytes("UTF8");
            providerCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(b));
        }
        catch (Exception e) {
            return false;
        }
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource s1 = cc.getProtectionDomain().getCodeSource();
                return s1.getLocation();
            }
        });
        if (url == null) {
            return false;
        }
        JarVerifierImpl jv = new JarVerifierImpl(url);
        try {
            jv.verify(providerCert);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

