/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.security.capi.IBMCAC;
import com.ibm.security.capi.Key;
import com.ibm.security.capi.RSAPrivateKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.KeyException;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.UUID;
import sun.security.action.GetPropertyAction;

abstract class KeyStore
extends KeyStoreSpi {
    private CertificateFactory certificateFactory = null;
    private static final String KEYSTORE_COMPATIBILITY_MODE_PROP = "com.ibm.security.capi.keyStoreCompatibilityMode";
    private final boolean keyStoreCompatibilityMode;
    private Collection<KeyEntry> entries = new ArrayList<KeyEntry>();
    private final String storeName;

    KeyStore(String storeName) {
        String prop = AccessController.doPrivileged(new GetPropertyAction(KEYSTORE_COMPATIBILITY_MODE_PROP));
        this.keyStoreCompatibilityMode = !"false".equalsIgnoreCase(prop);
        this.storeName = storeName;
    }

    @Override
    public java.security.Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null) {
            return null;
        }
        if (password != null && !this.keyStoreCompatibilityMode) {
            throw new UnrecoverableKeyException("Password must be null");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        for (KeyEntry entry : this.entries) {
            if (!alias.equals(entry.getAlias())) continue;
            return entry.getPrivateKey();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (alias == null) {
            return null;
        }
        for (KeyEntry entry : this.entries) {
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            return (Certificate[])certChain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            return null;
        }
        for (KeyEntry entry : this.entries) {
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            return certChain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (alias == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public void engineSetKeyEntry(String alias, java.security.Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (alias == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "KeyStore: SetKey:" + alias);
        }
        if (password != null && !this.keyStoreCompatibilityMode) {
            throw new KeyStoreException("Password must be null");
        }
        if (key instanceof RSAPrivateCrtKey) {
            KeyEntry entry = null;
            boolean found = false;
            for (KeyEntry e : this.entries) {
                if (!alias.equals(e.getAlias())) continue;
                found = true;
                entry = e;
                break;
            }
            if (!found) {
                entry = new KeyEntry(alias, null, (X509Certificate[])chain);
                this.entries.add(entry);
            }
            entry.setAlias(alias);
            try {
                entry.setPrivateKey((RSAPrivateCrtKey)key);
                entry.setCertificateChain((X509Certificate[])chain);
            }
            catch (KeyException ke) {
                throw new KeyStoreException(ke);
            }
            catch (CertificateException ce) {
                throw new KeyStoreException(ce);
            }
        } else {
            throw new UnsupportedOperationException("Cannot assign the key to the given alias.");
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Cannot assign the encoded key to the given alias.");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (alias == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "KeyStore: SetCertificate:" + alias);
        }
        if (cert instanceof X509Certificate) {
            X509Certificate[] chain = new X509Certificate[]{(X509Certificate)cert};
            KeyEntry entry = null;
            boolean found = false;
            for (KeyEntry e : this.entries) {
                if (!alias.equals(e.getAlias())) continue;
                found = true;
                entry = e;
                break;
            }
            if (!found) {
                entry = new KeyEntry(alias, null, chain);
                this.entries.add(entry);
            }
            if (entry.getPrivateKey() == null) {
                entry.setAlias(alias);
                try {
                    entry.setCertificateChain(chain);
                }
                catch (CertificateException ce) {
                    throw new KeyStoreException(ce);
                }
            }
        } else {
            throw new UnsupportedOperationException("Cannot assign the certificate to the given alias.");
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (alias == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "KeyStore: delete:" + alias);
        }
        for (KeyEntry entry : this.entries) {
            Key privateKey;
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            if (certChain != null) {
                try {
                    byte[] encoding = certChain[0].getEncoded();
                    this.removeCertificate(this.getName(), alias, encoding, encoding.length);
                }
                catch (CertificateException e) {
                    throw new KeyStoreException("Cannot remove entry: " + e);
                }
            }
            if ((privateKey = entry.getPrivateKey()) != null) {
                this.destroyKeyContainer(Key.getContainerName(privateKey.getHCryptProvider()));
            }
            this.entries.remove(entry);
            break;
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<KeyEntry> iter = this.entries.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public String nextElement() {
                KeyEntry entry = (KeyEntry)iter.next();
                return entry.getAlias();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Enumeration<String> enumerator = this.engineAliases();
        while (enumerator.hasMoreElements()) {
            String a = enumerator.nextElement();
            if (!a.equals(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (alias == null) {
            return false;
        }
        for (KeyEntry entry : this.entries) {
            if (!alias.equals(entry.getAlias())) continue;
            return entry.getPrivateKey() != null;
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        for (KeyEntry entry : this.entries) {
            if (!alias.equals(entry.getAlias())) continue;
            return entry.getPrivateKey() == null;
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (KeyEntry entry : this.entries) {
            if (entry.certChain == null || !entry.certChain[0].equals(cert)) continue;
            return entry.getAlias();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore output stream must be null");
        }
        if (password != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore password must be null");
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore input stream must be null");
        }
        if (password != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore password must be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider.IBMCAC"));
        }
        this.entries.clear();
        try {
            this.loadKeysOrCertificateChains(this.getName(), this.entries);
        }
        catch (KeyStoreException kse) {
            throw new IOException(kse.getMessage());
        }
    }

    private void generateCertificateChain(String alias, Collection<? extends Certificate> certCollection, Collection<KeyEntry> entries) {
        try {
            X509Certificate[] certChain = new X509Certificate[certCollection.size()];
            int i = 0;
            Iterator<? extends Certificate> iter = certCollection.iterator();
            while (iter.hasNext()) {
                certChain[i] = (X509Certificate)iter.next();
                ++i;
            }
            KeyEntry entry = new KeyEntry(alias, null, certChain);
            entries.add(entry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void generateRSAKeyAndCertificateChain(String alias, long hCryptProv, long hCryptKey, int keyLength, Collection<? extends Certificate> certCollection, Collection<KeyEntry> entries) {
        try {
            X509Certificate[] certChain = new X509Certificate[certCollection.size()];
            int i = 0;
            Iterator<? extends Certificate> iter = certCollection.iterator();
            while (iter.hasNext()) {
                certChain[i] = (X509Certificate)iter.next();
                ++i;
            }
            KeyEntry entry = new KeyEntry(alias, new RSAPrivateKey(hCryptProv, hCryptKey, keyLength), certChain);
            entries.add(entry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void generateCertificate(byte[] data, Collection<Certificate> certCollection) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            if (this.certificateFactory == null) {
                this.certificateFactory = CertificateFactory.getInstance("X.509");
            }
            Collection<? extends Certificate> c = this.certificateFactory.generateCertificates(bis);
            certCollection.addAll(c);
        }
        catch (CertificateException certificateException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getName() {
        return this.storeName;
    }

    private native void loadKeysOrCertificateChains(String var1, Collection<KeyEntry> var2) throws KeyStoreException;

    private native void storeCertificate(String var1, String var2, byte[] var3, int var4, long var5, long var7) throws CertificateException, KeyStoreException;

    private native void removeCertificate(String var1, String var2, byte[] var3, int var4) throws CertificateException, KeyStoreException;

    private native void destroyKeyContainer(String var1) throws KeyStoreException;

    private native byte[] generatePrivateKeyBlob(int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9) throws KeyException;

    private native RSAPrivateKey storePrivateKey(byte[] var1, String var2, int var3) throws KeyStoreException;

    class KeyEntry {
        private Key privateKey;
        private X509Certificate[] certChain;
        private String alias;

        KeyEntry(Key key, X509Certificate[] chain) {
            this(null, key, chain);
        }

        KeyEntry(String alias, Key key, X509Certificate[] chain) {
            this.privateKey = key;
            this.certChain = chain;
            this.alias = alias == null ? Integer.toString(chain[0].hashCode()) : alias;
        }

        String getAlias() {
            return this.alias;
        }

        void setAlias(String alias) {
            this.alias = alias;
        }

        Key getPrivateKey() {
            return this.privateKey;
        }

        void setPrivateKey(RSAPrivateCrtKey key) throws KeyException, KeyStoreException {
            byte[] modulusBytes = key.getModulus().toByteArray();
            int keyBitLength = modulusBytes[0] == 0 ? (modulusBytes.length - 1) * 8 : modulusBytes.length * 8;
            byte[] keyBlob = KeyStore.this.generatePrivateKeyBlob(keyBitLength, modulusBytes, key.getPublicExponent().toByteArray(), key.getPrivateExponent().toByteArray(), key.getPrimeP().toByteArray(), key.getPrimeQ().toByteArray(), key.getPrimeExponentP().toByteArray(), key.getPrimeExponentQ().toByteArray(), key.getCrtCoefficient().toByteArray());
            this.privateKey = KeyStore.this.storePrivateKey(keyBlob, "{" + UUID.randomUUID().toString() + "}", keyBitLength);
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }

        void setCertificateChain(X509Certificate[] chain) throws CertificateException, KeyStoreException {
            for (int i = 0; i < chain.length; ++i) {
                byte[] encoding = chain[i].getEncoded();
                if (i == 0 && this.privateKey != null) {
                    KeyStore.this.storeCertificate(KeyStore.this.getName(), this.alias, encoding, encoding.length, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
                    continue;
                }
                KeyStore.this.storeCertificate(KeyStore.this.getName(), this.alias, encoding, encoding.length, 0L, 0L);
            }
            this.certChain = chain;
        }
    }

    public static final class MY
    extends KeyStore {
        public MY() {
            super("MY");
        }
    }

    public static final class ROOT
    extends KeyStore {
        public ROOT() {
            super("ROOT");
        }
    }
}

