/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import java.io.Serializable;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandomSpi;

public final class PRNG
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 4129268715132691532L;

    private static native byte[] generateSeed(int var0, byte[] var1);

    @Override
    protected void engineSetSeed(byte[] seed) {
        if (seed != null) {
            PRNG.generateSeed(-1, seed);
        }
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        if (bytes != null && PRNG.generateSeed(0, bytes) == null) {
            throw new ProviderException("Error generating random bytes");
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        if (numBytes > 0) {
            byte[] seed = PRNG.generateSeed(numBytes, null);
            if (seed == null) {
                throw new ProviderException("Error generating seed bytes");
            }
            return seed;
        }
        if (numBytes == 0) {
            return new byte[0];
        }
        throw new InvalidParameterException("Invalid seed length");
    }
}

