/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.crypto.fips.provider.RSAPrivateCrtKey;
import com.ibm.security.capi.Key;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.ProviderException;

public class RSAPrivateKey
extends Key
implements PrivateKey,
java.security.interfaces.RSAPrivateCrtKey {
    private static final long serialVersionUID = 5336117729775923087L;
    private byte[] privateKeyBlob = null;
    private byte[] encoding = null;
    private BigInteger modulus = null;
    private BigInteger privateExponent = null;
    private BigInteger publicExponent = null;
    private BigInteger primeP = null;
    private BigInteger primeQ = null;
    private BigInteger primeExponentP = null;
    private BigInteger primeExponentQ = null;
    private BigInteger crtCoefficient = null;

    RSAPrivateKey(long hCryptProv, long hCryptKey, int keyLength) {
        super(hCryptProv, hCryptKey, keyLength);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public String toString() {
        return "RSAPrivateKey [size=" + this.keyLength + " bits, type=" + RSAPrivateKey.getKeyType(this.hCryptKey) + ", container=" + RSAPrivateKey.getContainerName(this.hCryptProv) + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    @Override
    public BigInteger getModulus() {
        try {
            if (this.modulus == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.modulus = new BigInteger(1, this.getNativeModulus(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        try {
            if (this.privateExponent == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.privateExponent = new BigInteger(1, this.getNativePrivateExponent(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.privateExponent;
    }

    @Override
    public BigInteger getPublicExponent() {
        try {
            if (this.publicExponent == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.publicExponent = new BigInteger(1, this.getNativePublicExponent(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        try {
            if (this.primeP == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.primeP = new BigInteger(1, this.getNativePrimeP(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        try {
            if (this.primeQ == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.primeQ = new BigInteger(1, this.getNativePrimeQ(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        try {
            if (this.primeExponentP == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.primeExponentP = new BigInteger(1, this.getNativePrimeExponentP(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        try {
            if (this.primeExponentQ == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.primeExponentQ = new BigInteger(1, this.getNativePrimeExponentQ(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        try {
            if (this.crtCoefficient == null) {
                this.privateKeyBlob = this.getNativePrivateKeyBlob(this.hCryptKey);
                this.crtCoefficient = new BigInteger(1, this.getNativeCrtCoefficient(this.privateKeyBlob));
            }
        }
        catch (KeyException ke) {
            throw new ProviderException(ke);
        }
        return this.crtCoefficient;
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            try {
                this.encoding = new RSAPrivateCrtKey(this.getModulus(), this.getPrivateExponent(), this.getPublicExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient()).getEncoded();
            }
            catch (KeyException keyException) {
                // empty catch block
            }
        }
        return this.encoding;
    }

    private native byte[] getNativePrivateKeyBlob(long var1) throws KeyException;

    private native byte[] getNativeModulus(byte[] var1) throws KeyException;

    private native byte[] getNativePrivateExponent(byte[] var1) throws KeyException;

    private native byte[] getNativePublicExponent(byte[] var1) throws KeyException;

    private native byte[] getNativePrimeP(byte[] var1) throws KeyException;

    private native byte[] getNativePrimeQ(byte[] var1) throws KeyException;

    private native byte[] getNativePrimeExponentP(byte[] var1) throws KeyException;

    private native byte[] getNativePrimeExponentQ(byte[] var1) throws KeyException;

    private native byte[] getNativeCrtCoefficient(byte[] var1) throws KeyException;
}

