/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.capi.IBMCAC;
import com.ibm.security.capi.Key;
import com.ibm.security.capi.RSAPrivateKey;
import com.ibm.security.capi.RSAPublicKey;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class RSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private String messageDigestAlgorithm;
    private boolean needsReset;
    private Key privateKey = null;
    private Key publicKey = null;

    RSASignature() {
        this.messageDigest = null;
        this.messageDigestAlgorithm = null;
    }

    RSASignature(String digestName) {
        try {
            this.messageDigest = MessageDigest.getInstance(digestName);
            this.messageDigestAlgorithm = this.messageDigest.getAlgorithm();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Key type not supported");
        }
        java.security.interfaces.RSAPublicKey rsaKey = (java.security.interfaces.RSAPublicKey)key;
        if (!(key instanceof RSAPublicKey)) {
            BigInteger modulus = rsaKey.getModulus();
            BigInteger exponent = rsaKey.getPublicExponent();
            RSAKeyFactory.checkKeyLengths((int)(modulus.bitLength() + 7 & 0xFFFFFFF8), (BigInteger)exponent, (int)-1, (int)16384);
            byte[] modulusBytes = modulus.toByteArray();
            byte[] exponentBytes = exponent.toByteArray();
            int keyBitLength = modulusBytes[0] == 0 ? (modulusBytes.length - 1) * 8 : modulusBytes.length * 8;
            byte[] keyBlob = RSASignature.generatePublicKeyBlob(keyBitLength, modulusBytes, exponentBytes);
            try {
                this.publicKey = RSASignature.importPublicKey(keyBlob, keyBitLength);
            }
            catch (KeyStoreException e) {
                throw new InvalidKeyException(e);
            }
        } else {
            this.publicKey = (RSAPublicKey)key;
        }
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: engineInitSign");
        }
        if (!(key instanceof RSAPrivateKey)) {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "ERROR: Key type is not com.ibm.security.capi.RSAPrivateKey");
            }
            throw new InvalidKeyException("Key type not supported");
        }
        this.privateKey = (RSAPrivateKey)key;
        RSAKeyFactory.checkKeyLengths((int)(this.privateKey.length() + 7 & 0xFFFFFFF8), null, (int)512, (int)16384);
        this.publicKey = null;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            this.messageDigest.reset();
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: getDigestValue");
        }
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    protected void setDigestName(String name) {
        this.messageDigestAlgorithm = name;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.messageDigest.update(b, off, len);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        this.messageDigest.update(input);
        this.needsReset = true;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: engineSign");
        }
        byte[] hash = this.getDigestValue();
        boolean noHashOID = this instanceof Raw;
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: signHash");
            System.out.println("                     noHashOID: " + noHashOID);
            System.out.println("                     hash: " + hash.toString());
            System.out.println("                     hash.length: " + hash.length);
            System.out.println("                     messageDigestAlgorithm: " + this.messageDigestAlgorithm);
            System.out.println("                     privateKey: " + this.privateKey.toString());
            System.out.println("                     HCryptProvider: " + this.privateKey.getHCryptProvider());
            System.out.println("                     HCryptKey: " + this.privateKey.getHCryptKey());
        }
        byte[] result = null;
        try {
            result = RSASignature.signHash(noHashOID, hash, hash.length, this.messageDigestAlgorithm, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
        }
        catch (Throwable t) {
            if (IBMCAC.debug) {
                t.printStackTrace();
                System.out.println();
            }
            throw t;
        }
        if (IBMCAC.debug) {
            System.out.println("                     result: " + result.toString());
        }
        return this.convertEndianArray(result);
    }

    private byte[] convertEndianArray(byte[] byteArray) {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: convertEndianArray");
        }
        if (byteArray == null || byteArray.length == 0) {
            return byteArray;
        }
        byte[] retval = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            retval[i] = byteArray[byteArray.length - i - 1];
        }
        return retval;
    }

    private static native byte[] signHash(boolean var0, byte[] var1, int var2, String var3, long var4, long var6) throws SignatureException;

    private static native boolean verifySignedHash(byte[] var0, int var1, String var2, byte[] var3, int var4, long var5, long var7) throws SignatureException;

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: engineVerify");
        }
        byte[] hash = this.getDigestValue();
        return RSASignature.verifySignedHash(hash, hash.length, this.messageDigestAlgorithm, this.convertEndianArray(sigBytes), sigBytes.length, this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    static native byte[] generatePublicKeyBlob(int var0, byte[] var1, byte[] var2) throws InvalidKeyException;

    static native RSAPublicKey importPublicKey(byte[] var0, int var1) throws KeyStoreException;

    public static final class MD2
    extends RSASignature {
        public MD2() {
            super("MD2");
        }
    }

    public static final class MD5
    extends RSASignature {
        public MD5() {
            super("MD5");
        }
    }

    public static final class Raw
    extends RSASignature {
        private static final int RAW_RSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = b;
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            if (this.offset + len > this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            System.arraycopy(b, off, this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            if (this.offset + len > this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            if (this.offset == 20) {
                this.setDigestName("SHA1");
            } else if (this.offset == 36) {
                this.setDigestName("SHA1+MD5");
            } else if (this.offset == 32) {
                this.setDigestName("SHA-256");
            } else if (this.offset == 48) {
                this.setDigestName("SHA-384");
            } else if (this.offset == 64) {
                this.setDigestName("SHA-512");
            } else if (this.offset == 16) {
                this.setDigestName("MD5");
            } else {
                throw new SignatureException("Message digest length is not supported");
            }
            byte[] result = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, result, 0, this.offset);
            this.offset = 0;
            return result;
        }
    }

    public static final class SHA1
    extends RSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class SHA256
    extends RSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA384
    extends RSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA512
    extends RSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }
}

