/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;

public class CMSCertificate
extends X509Certificate {
    private final Certificate cert;
    private boolean trusted;

    public CMSCertificate(Certificate certificate, boolean bl) {
        this.cert = certificate;
        this.trusted = bl;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        ((X509Certificate)this.cert).checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        ((X509Certificate)this.cert).checkValidity(date);
    }

    public int getBasicConstraints() {
        return ((X509Certificate)this.cert).getBasicConstraints();
    }

    public Principal getIssuerDN() {
        return ((X509Certificate)this.cert).getIssuerDN();
    }

    public boolean[] getIssuerUniqueID() {
        return ((X509Certificate)this.cert).getIssuerUniqueID();
    }

    public boolean[] getKeyUsage() {
        return ((X509Certificate)this.cert).getKeyUsage();
    }

    public Date getNotAfter() {
        return ((X509Certificate)this.cert).getNotAfter();
    }

    public Date getNotBefore() {
        return ((X509Certificate)this.cert).getNotBefore();
    }

    public BigInteger getSerialNumber() {
        return ((X509Certificate)this.cert).getSerialNumber();
    }

    public String getSigAlgName() {
        return ((X509Certificate)this.cert).getSigAlgName();
    }

    public String getSigAlgOID() {
        return ((X509Certificate)this.cert).getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return ((X509Certificate)this.cert).getSigAlgParams();
    }

    public byte[] getSignature() {
        return ((X509Certificate)this.cert).getSignature();
    }

    public Principal getSubjectDN() {
        return ((X509Certificate)this.cert).getSubjectDN();
    }

    public boolean[] getSubjectUniqueID() {
        return ((X509Certificate)this.cert).getSubjectUniqueID();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return ((X509Certificate)this.cert).getTBSCertificate();
    }

    public int getVersion() {
        return ((X509Certificate)this.cert).getVersion();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public String toString() {
        return this.cert.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cert.verify(publicKey);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cert.verify(publicKey, string);
    }

    public Set getCriticalExtensionOIDs() {
        return ((X509Extension)((Object)this.cert)).getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return ((X509Extension)((Object)this.cert)).getExtensionValue(string);
    }

    public Set getNonCriticalExtensionOIDs() {
        return ((X509Extension)((Object)this.cert)).getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return ((X509Extension)((Object)this.cert)).hasUnsupportedCriticalExtension();
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean bl) {
        this.trusted = bl;
    }
}

