/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.ByteSequenceXorFactory;
import com.ibm.security.cmskeystore.CACertificates;
import com.ibm.security.cmskeystore.CMSCertificate;
import com.ibm.security.cmskeystore.CMSKeyStoreSpi$1;
import com.ibm.security.cmskeystore.CMSKeyStoreSpi$PEFromCBHandler;
import com.ibm.security.cmskeystore.CMSKeyStoreSpi$PEFromPwdProtection;
import com.ibm.security.cmskeystore.CMSKeyStoreSpi$PEFromStashedPwdProtection;
import com.ibm.security.cmskeystore.CMSKeyStoreSpi$PasswordExtractor;
import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSPrivateKey;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory;
import com.ibm.security.cmskeystore.CMSStoreParameter;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderFactory;
import com.ibm.security.cmskeystore.FileHeaderHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileType;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.KeyDatabaseFactory;
import com.ibm.security.cmskeystore.MagicNumberValidatorFactory;
import com.ibm.security.cmskeystore.QueryableKeyDatabase;
import com.ibm.security.cmskeystore.QueryableKeyDatabaseFactory;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory;
import com.ibm.security.cmskeystore.RecordFactory;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.cmskeystore.StashedPasswordProtection;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.sequence.AConverter;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.SequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;

public class CMSKeyStoreSpi
extends KeyStoreSpi {
    private int FIXED_RECORD_LENGTH = 5000;
    private static final IntableByteSequence ZERO = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 4));
    private static final IntableByteSequence ZERO_MD5_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 16));
    private static final IntableByteSequence ZERO_SHA1_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 20));
    private IntableByteSequence FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(this.FIXED_RECORD_LENGTH);
    private static final ByteSequence UNUSED_FILE_LABEL = ByteSequenceFactory.newConstantByteSequence((byte)0, 24);
    private static final String STASH_FILE_EXT = ".sth";
    private QueryableKeyDatabase cmsKeyDatabase;
    private Set aliases;
    private String storePassword;
    static int version = 4;
    static boolean populate = true;
    static boolean tracing = false;
    static String traceFileName = null;
    private static PrintStream tStream = null;
    protected static String ALGORITHM_ID = "";

    static CMSKeyStoreSpi$PasswordExtractor newPasswordExtractor(KeyStore.ProtectionParameter protectionParameter) {
        if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            return new CMSKeyStoreSpi$PEFromCBHandler((KeyStore.CallbackHandlerProtection)protectionParameter);
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            return new CMSKeyStoreSpi$PEFromPwdProtection((KeyStore.PasswordProtection)protectionParameter);
        }
        if (protectionParameter instanceof StashedPasswordProtection) {
            return new CMSKeyStoreSpi$PEFromStashedPwdProtection((StashedPasswordProtection)protectionParameter);
        }
        return null;
    }

    private IntableByteSequence getFixedRecordLengthSequence() {
        if (this.FIXED_RECORD_LENGTH_SEQUENCE.toInt() != this.getFixedRecordLengh()) {
            this.FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(this.getFixedRecordLengh());
        }
        return this.FIXED_RECORD_LENGTH_SEQUENCE;
    }

    private String labelFromRecord(Record record) {
        String string;
        Buffer buffer = record.getLabel();
        byte[] byArray = new byte[buffer.getHeader().toInt()];
        try {
            buffer.getContent().getInputStream().read(byArray);
            string = new String(byArray, "UTF-8");
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    private void rebuildAliasesList() throws IOException {
        if (this.cmsKeyDatabase == null) {
            return;
        }
        this.aliases = null;
        this.aliases = new TreeSet(new CMSKeyStoreSpi$1(this));
        Sequence sequence = this.cmsKeyDatabase.getRecords();
        for (Record record : sequence) {
            if (record.getRecordFlag() == RecordFlag.DELETED) continue;
            this.aliases.add(this.labelFromRecord(record));
        }
    }

    static void trace(String string) {
        if (tracing) {
            if (tStream == null) {
                tStream = System.out;
                if (traceFileName != null) {
                    try {
                        tStream = new PrintStream(new FileOutputStream(traceFileName, true));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.out.println("Using System.out for trace");
                    }
                }
            }
            tStream.println(string);
        }
    }

    public CMSKeyStoreSpi() {
        CMSKeyStoreSpi.trace("CMSKeyStoreSpi V" + version + " populate=" + populate);
    }

    public Key engineGetKey(String string, char[] cArray) throws UnrecoverableKeyException {
        CMSKeyStoreSpi.trace("engineGetKey(\"" + string + "\", password)");
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            if (!this.cmsKeyDatabase.checkPassword(cArray)) {
                throw new UnrecoverableKeyException("Incorrect Password.");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Error occured while checking the password validity: " + exception.getMessage());
        }
        Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(string));
        if (record == null) {
            return null;
        }
        RecordEncoding recordEncoding = record.getEncoding();
        if (!recordEncoding.isPrivateKeyPresent()) {
            return null;
        }
        try {
            return recordEncoding.getPrivateKey(cArray);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Error occured while extracting the private key: " + exception.getMessage());
        }
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray;
        CMSKeyStoreSpi.trace("engineGetCertificateChain(\"" + string + "\")");
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        int n = 0;
        try {
            Record record;
            certificateArray = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(string));
            CMSKeyStoreSpi.trace("# " + n + " \"" + this.labelFromRecord((Record)certificateArray) + "\"");
            arrayList.add(n++, certificateArray.getEncoding().getCertificate());
            while ((record = this.cmsKeyDatabase.getIssuerRecord((Record)certificateArray)) != null && !record.getSubjectNameHash().equals(certificateArray.getSubjectNameHash())) {
                certificateArray = record;
                CMSKeyStoreSpi.trace("# " + n + " \"" + this.labelFromRecord((Record)certificateArray) + "\"");
                arrayList.add(n++, certificateArray.getEncoding().getCertificate());
            }
        }
        catch (Exception exception) {
            return null;
        }
        certificateArray = arrayList.toArray(new Certificate[n]);
        return certificateArray;
    }

    public Certificate engineGetCertificate(String string) {
        CMSKeyStoreSpi.trace("engineGetCertificate(\"" + string + "\")");
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(string));
        if (record == null) {
            return null;
        }
        try {
            return record.getEncoding().getCertificate();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date engineGetCreationDate(String string) {
        CMSKeyStoreSpi.trace("engineGetCreationDate(\"" + string + "\")");
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Object object;
        ByteSequence byteSequence;
        Serializable serializable2;
        Object object2;
        Object object3;
        int n;
        Object object4;
        CMSKeyStoreSpi.trace("engineSetKeyEntry(\"" + string + "\", key, password, chain[" + (certificateArray != null ? certificateArray.length : 0) + "])");
        if (!key.getFormat().equals("PKCS#8")) {
            String string2 = "This keystore allows only PKCS#8 encoded private keys";
            CMSKeyStoreSpi.trace(string2);
            throw new KeyStoreException(string2);
        }
        try {
            if (cArray != null && !this.cmsKeyDatabase.checkPassword(cArray)) {
                String string3 = "Invalid password provided. Password must be null or the same as the KeyStore password.";
                CMSKeyStoreSpi.trace(string3);
                throw new KeyStoreException(string3);
            }
        }
        catch (Exception exception) {
            String string4 = "Error occurred while checking the password validity.";
            CMSKeyStoreSpi.trace(string4);
            throw new KeyStoreException(string4, exception);
        }
        if (certificateArray == null) {
            String string5 = "Certificate chain must be provided for this keystore";
            CMSKeyStoreSpi.trace(string5);
            throw new KeyStoreException(string5);
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i] instanceof X509Certificate) continue;
            String string6 = "One of the chain elements is not an X509Certificate";
            CMSKeyStoreSpi.trace(string6);
            throw new KeyStoreException(string6);
        }
        String string7 = null;
        RecordDataHashGenerator recordDataHashGenerator = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
        ArrayList<Record> arrayList = new ArrayList<Record>(certificateArray.length);
        boolean bl = false;
        if (key instanceof CMSPrivateKey) {
            bl = ((CMSPrivateKey)key).isDefault();
            CMSKeyStoreSpi.trace("isDefault = " + bl);
        }
        for (int i = certificateArray.length - 1; i > 0; --i) {
            if (this.engineGetCertificateAlias(certificateArray[i]) != null) continue;
            object4 = ((X509Certificate)certificateArray[i]).getSubjectX500Principal();
            if (object4 == null || ((X500Principal)object4).toString().equals("")) {
                String string8 = "The Subject DN of certificate #" + i + " is not in X.500 form";
                CMSKeyStoreSpi.trace(string8);
                throw new KeyStoreException(string8);
            }
            string7 = ((X500Principal)object4).toString();
            if (this.engineContainsAlias(string7)) {
                String string9 = "A signer certificate with alias: " + string7 + " already exists but it contains a different public key";
                CMSKeyStoreSpi.trace(string9);
                throw new KeyStoreException(string9);
            }
            try {
                n = this.engineContainsAlias(string) ? this.cmsKeyDatabase.getNextRecordID() - 1 : this.cmsKeyDatabase.getNextRecordID();
                object3 = string7.getBytes("UTF-8");
                object2 = IntableByteSequenceFactory.newIntableByteSequence(((Object)object3).length).append(ByteSequenceFactory.newByteSequence((byte[])object3));
                serializable2 = (X509Certificate)certificateArray[i];
                byteSequence = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(n)).append(RecordEncodingFactory.newRecordEncoding(n, serializable2, string7, true)).append(BufferFactory.newBuffer(object2.getInputStream())).append(ZERO).append(recordDataHashGenerator.generateCertificateSignatureHash((X509Certificate)serializable2)).append(recordDataHashGenerator.generateTBSCertificateHash((X509Certificate)serializable2)).append(recordDataHashGenerator.generateSubjectNameHash((X509Certificate)serializable2)).append(recordDataHashGenerator.generateSubjectPublicKeyInfoHash((X509Certificate)serializable2)).append(recordDataHashGenerator.generateIssuerAndSerialNumberHash((X509Certificate)serializable2));
                arrayList.add(RecordFactory.newRecord(byteSequence.getInputStream()));
                continue;
            }
            catch (Exception exception) {
                object3 = "Error occurred while adding the certificate chain to KeyStore.";
                CMSKeyStoreSpi.trace((String)object3);
                throw new KeyStoreException((String)object3, exception);
            }
        }
        try {
            object = string.getBytes("UTF-8");
            object4 = IntableByteSequenceFactory.newIntableByteSequence(((byte[])object).length).append(ByteSequenceFactory.newByteSequence((byte[])object));
            n = this.engineContainsAlias(string) ? this.cmsKeyDatabase.getNextRecordID() - 1 : this.cmsKeyDatabase.getNextRecordID();
            object3 = (X509Certificate)certificateArray[0];
            object2 = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(n)).append(RecordEncodingFactory.newKeyRecordEncoding(n, (Certificate)object3, (PrivateKey)key, this.storePassword.toCharArray(), string, bl)).append(BufferFactory.newBuffer(object4.getInputStream())).append(ZERO).append(recordDataHashGenerator.generateCertificateSignatureHash((X509Certificate)object3)).append(recordDataHashGenerator.generateTBSCertificateHash((X509Certificate)object3)).append(recordDataHashGenerator.generateSubjectNameHash((X509Certificate)object3)).append(recordDataHashGenerator.generateSubjectPublicKeyInfoHash((X509Certificate)object3)).append(recordDataHashGenerator.generateIssuerAndSerialNumberHash((X509Certificate)object3));
            arrayList.add(RecordFactory.newRecord(object2.getInputStream()));
        }
        catch (Exception exception) {
            object4 = "Error occurred while adding the End Entity certificate to KeyStore.";
            CMSKeyStoreSpi.trace((String)object4);
            throw new KeyStoreException((String)object4, exception);
        }
        if (this.engineContainsAlias(string)) {
            this.engineDeleteEntry(string);
        }
        if ((object = (Object)this.engineGetCertificateAlias(certificateArray[0])) != null && !((String)object).equalsIgnoreCase(string)) {
            this.engineDeleteEntry((String)object);
        }
        try {
            if (bl && (object4 = this.getDefaultKeyAlias()) != null) {
                Record record = this.cmsKeyDatabase.getRecordByLabel((String)object4);
                int n2 = record.getRecordId().toInt();
                object2 = (X509Certificate)record.getEncoding().getCertificate();
                serializable2 = record.getEncoding().getPrivateKey(this.storePassword.toCharArray());
                recordDataHashGenerator = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
                byteSequence = RecordFlag.CREATED.append(record.getRecordId()).append(RecordEncodingFactory.newKeyRecordEncoding(n2, (Certificate)object2, (PrivateKey)serializable2, this.storePassword.toCharArray(), (String)object4, false)).append(record.getLabel()).append(ZERO).append(recordDataHashGenerator.generateCertificateSignatureHash((X509Certificate)object2)).append(recordDataHashGenerator.generateTBSCertificateHash((X509Certificate)object2)).append(recordDataHashGenerator.generateSubjectNameHash((X509Certificate)object2)).append(recordDataHashGenerator.generateSubjectPublicKeyInfoHash((X509Certificate)object2)).append(recordDataHashGenerator.generateIssuerAndSerialNumberHash((X509Certificate)object2));
                arrayList.add(RecordFactory.newRecord(byteSequence.getInputStream()));
                this.engineDeleteEntry((String)object4);
            }
        }
        catch (Exception exception) {
            String string10 = "Error occurred while updating the old default certificate.";
            CMSKeyStoreSpi.trace(string10);
            throw new KeyStoreException(string10);
        }
        this.resetFixedRecordLengh();
        this.setFixedRecordLengh(this.analyzeMaxRecordLength(arrayList));
        this.setFixedRecordLengh(this.analyzeMaxRecordLength(this.cmsKeyDatabase.getRecords()));
        this.padRecords(arrayList);
        this.padRecords(this.cmsKeyDatabase.getRecords());
        try {
            object4 = SequenceFactory.newSequence(arrayList);
            Sequence sequence = this.cmsKeyDatabase.getRecords().append((Sequence)object4);
            ByteSequence byteSequence2 = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(sequence.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
            for (Serializable serializable2 : sequence) {
                byteSequence2 = byteSequence2.append((ByteSequence)serializable2);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(byteSequence2.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception);
        }
    }

    private String getDefaultKeyAlias() throws UnsupportedEncodingException, IOException {
        Sequence sequence = this.cmsKeyDatabase.getKeyRecords();
        for (Record record : sequence) {
            if (!record.getEncoding().isDefaultKey()) continue;
            return this.labelFromRecord(record);
        }
        return null;
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        CMSKeyStoreSpi.trace("engineSetKeyEntry(\"" + string + "\", byte[] key, Certificate[] chain) = unsupported function");
        throw new KeyStoreException("CMS cannot accept externally encoded PKCS#8 objects");
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        CMSKeyStoreSpi.trace("engineSetCertificateEntry(\"" + string + "\", cert)");
        try {
            String string2;
            if (!(certificate instanceof X509Certificate)) {
                String string3 = "Only X509 Certificates are expected.";
                CMSKeyStoreSpi.trace(string3);
                throw new KeyStoreException(string3);
            }
            if (this.engineContainsAlias(string)) {
                if (!this.engineIsCertificateEntry(string)) {
                    String string4 = "Alias already exists and is associated with key entry.";
                    CMSKeyStoreSpi.trace(string4);
                    throw new KeyStoreException(string4);
                }
                this.engineDeleteEntry(string);
            }
            boolean bl = true;
            if (certificate instanceof CMSCertificate) {
                bl = ((CMSCertificate)certificate).isTrusted();
                CMSKeyStoreSpi.trace("isTrusted = " + bl);
            }
            if ((string2 = this.engineGetCertificateAlias(certificate)) != null) {
                this.engineDeleteEntry(string2);
            }
            int n = this.cmsKeyDatabase.getNextRecordID();
            byte[] byArray = string.getBytes("UTF-8");
            RecordDataHashGenerator recordDataHashGenerator = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
            ByteSequence byteSequence = IntableByteSequenceFactory.newIntableByteSequence(byArray.length).append(ByteSequenceFactory.newByteSequence(byArray));
            X509Certificate x509Certificate = (X509Certificate)certificate;
            ByteSequence byteSequence2 = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(n)).append(RecordEncodingFactory.newRecordEncoding(n, x509Certificate, string, bl)).append(BufferFactory.newBuffer(byteSequence.getInputStream())).append(ZERO).append(recordDataHashGenerator.generateCertificateSignatureHash(x509Certificate)).append(recordDataHashGenerator.generateTBSCertificateHash(x509Certificate)).append(recordDataHashGenerator.generateSubjectNameHash(x509Certificate)).append(recordDataHashGenerator.generateSubjectPublicKeyInfoHash(x509Certificate)).append(recordDataHashGenerator.generateIssuerAndSerialNumberHash(x509Certificate));
            Record record = RecordFactory.newRecord(byteSequence2.getInputStream());
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(record.length());
            this.setFixedRecordLengh(this.analyzeMaxRecordLength(this.cmsKeyDatabase.getRecords()));
            this.padRecord(record);
            this.padRecords(this.cmsKeyDatabase.getRecords());
            try {
                Sequence sequence = SequenceFactory.newSequence(new Record[]{record});
                Sequence sequence2 = this.cmsKeyDatabase.getRecords().append(sequence);
                ByteSequence byteSequence3 = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(sequence2.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
                for (Record record2 : sequence2) {
                    byteSequence3 = byteSequence3.append(record2);
                }
                this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(byteSequence3.getInputStream()));
                this.updateHeaderHashes();
                this.rebuildAliasesList();
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key Insertion Failed: " + exception.getMessage(), exception);
        }
    }

    private void updateHeaderHashes() throws NoSuchAlgorithmException, IOException {
        ByteSequence byteSequence5;
        ByteSequence byteSequence2;
        CMSKeyStoreSpi.trace("updateHeaderHashes");
        FileHeader fileHeader = this.cmsKeyDatabase.getHeader();
        ByteSequence byteSequence3 = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(fileHeader).generateHash(fileHeader, this.storePassword);
        ByteSequence byteSequence4 = byteSequence2 = fileHeader.getSubSequence(0, fileHeader.length() - 2 * fileHeader.getPasswordHeaderHash().length()).append(byteSequence3).append(fileHeader.getPasswordDatabaseHash());
        for (ByteSequence byteSequence5 : this.cmsKeyDatabase.getRecords()) {
            byteSequence4 = byteSequence4.append(byteSequence5);
        }
        KeyDatabase keyDatabase = KeyDatabaseFactory.newKeyDatabase(byteSequence4.getInputStream());
        byteSequence5 = DatabaseHashGeneratorFactory.newDatabaseHashGenerator(fileHeader).generateHash(keyDatabase, this.storePassword);
        fileHeader = keyDatabase.getHeader();
        byteSequence4 = byteSequence2 = fileHeader.getSubSequence(0, fileHeader.length() - fileHeader.getPasswordDatabaseHash().length()).append(byteSequence5);
        for (Record record : keyDatabase.getRecords()) {
            byteSequence4 = byteSequence4.append(record);
        }
        this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(byteSequence4.getInputStream()));
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        try {
            CMSKeyStoreSpi.trace("engineDeleteEntry(\"" + string + "\")");
            if (!this.engineContainsAlias(string)) {
                return;
            }
            Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(string));
            Sequence sequence = this.cmsKeyDatabase.getRecords();
            int n = sequence.indexOf(record);
            Sequence sequence2 = sequence.getSubSequence(0, n).append(sequence.getSubSequence(n + 1, sequence.length()));
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(this.analyzeMaxRecordLength(sequence2));
            this.padRecords(sequence2);
            ByteSequence byteSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(sequence2.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
            for (Record record2 : sequence2) {
                byteSequence = byteSequence.append(record2);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(byteSequence.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage(), exception);
        }
    }

    public Enumeration engineAliases() {
        CMSKeyStoreSpi.trace("engineAliases() :");
        if (tracing) {
            for (String string : this.aliases) {
                CMSKeyStoreSpi.trace("alias=\"" + string + "\"");
            }
        }
        Enumeration enumeration = Collections.enumeration(this.aliases);
        return enumeration;
    }

    public boolean engineContainsAlias(String string) {
        boolean bl = this.aliases.contains(string);
        CMSKeyStoreSpi.trace("engineContainsAlias(\"" + string + "\") = " + bl);
        return bl;
    }

    public int engineSize() {
        int n = this.aliases.size();
        CMSKeyStoreSpi.trace("engineSize()=" + n);
        return n;
    }

    public boolean engineIsKeyEntry(String string) {
        Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(string));
        boolean bl = record == null ? false : record.getEncoding().isPrivateKeyPresent();
        CMSKeyStoreSpi.trace("engineIsKeyEntry(\"" + string + "\") = " + bl);
        return bl;
    }

    public boolean engineIsCertificateEntry(String string) {
        boolean bl = this.engineContainsAlias(string) && !this.engineIsKeyEntry(string);
        CMSKeyStoreSpi.trace("engineIsCertificateEntry(\"" + string + "\") = " + bl);
        return bl;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            CMSKeyStoreSpi.trace("engineGetCertificateAlias(cert) - cert not X509Certificate");
            return null;
        }
        Record record = this.cmsKeyDatabase.getRecordByCert(certificate);
        if (record == null) {
            CMSKeyStoreSpi.trace("engineGetCertificateAlias(cert) = null");
            return null;
        }
        String string = this.labelFromRecord(record);
        CMSKeyStoreSpi.trace("engineGetCertificateAlias(cert) = \"" + string + "\"");
        return string;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        Object object;
        CMSKeyStoreSpi.trace("engineStore(stream, password)");
        if (outputStream == null) {
            throw new NullPointerException();
        }
        try {
            if (cArray != null && !this.storePassword.equals(object = new String(cArray))) {
                this.updateEncryptedRecords(this.storePassword.toCharArray(), ((String)object).toCharArray());
                this.storePassword = object;
                this.updateHeaderHashes();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        object = this.cmsKeyDatabase.getIterator();
        while (object.hasNextByte()) {
            outputStream.write(object.getNextByte());
        }
    }

    private void updateEncryptedRecords(char[] cArray, char[] cArray2) throws IOException, PKCSException, CertificateEncodingException, CertificateException, NoSuchAlgorithmException {
        ByteSequence byteSequence;
        CMSKeyStoreSpi.trace("updateEncryptedRecords(changed password)");
        Sequence sequence = this.cmsKeyDatabase.getKeyRecords();
        HashMap<Integer, Record> hashMap = new HashMap<Integer, Record>(sequence.length());
        for (Object object : sequence) {
            Object object2 = this.labelFromRecord((Record)object);
            byteSequence = object.getEncoding();
            boolean bl = byteSequence.isDefaultKey();
            RecordEncoding recordEncoding = RecordEncodingFactory.newKeyRecordEncoding(object.getRecordId().toInt(), byteSequence.getCertificate(), byteSequence.getPrivateKey(cArray), cArray2, (String)object2, bl);
            ByteSequence byteSequence2 = object.getRecordFlag().append(object.getRecordId()).append(recordEncoding).append(object.getLabel()).append(ZERO).append(object.getSignatureHash()).append(object.getUnsignedCertHash()).append(object.getSubjectNameHash()).append(object.getSubjectPublicKeyInfoHash()).append(object.getIssuerAndSerialNumberHash());
            hashMap.put(object.getRecordId().toInt(), RecordFactory.newRecord(byteSequence2.getInputStream()));
        }
        this.padRecords(hashMap.values());
        this.padRecords(this.cmsKeyDatabase.getRecords());
        Object object = this.cmsKeyDatabase.getHeader();
        for (Object object2 : this.cmsKeyDatabase.getRecords()) {
            byteSequence = (Record)hashMap.get(object2.getRecordId().toInt());
            if (byteSequence != null) {
                object = object.append(byteSequence);
                continue;
            }
            object = object.append((ByteSequence)object2);
        }
        this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(object.getInputStream()));
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        CMSKeyStoreSpi.trace("engineLoad(InputStream stream, char[] password)");
        if (cArray == null) {
            throw new IllegalArgumentException("Password is requird to create a new or load an existing KeyStore");
        }
        this.cmsKeyDatabase = null;
        this.storePassword = new String(cArray);
        if (inputStream == null) {
            CMSKeyStoreSpi.trace("new keystore - version " + version);
            try {
                ByteSequence runtimeException;
                IntableByteSequence intableByteSequence;
                Object object2;
                Object object3;
                IntableByteSequence intableByteSequence2 = IntableByteSequenceFactory.newIntableByteSequence(populate ? CACertificates.CACERTS.size() : 0);
                ArrayList<Record> arrayList = new ArrayList<Record>();
                if (populate) {
                    object3 = CACertificates.getAliases();
                    int n = 0;
                    object2 = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
                    while (object3.hasNext()) {
                        String object4 = (String)object3.next();
                        byte[] byArray = object4.getBytes("UTF-8");
                        ByteSequence byteSequence = IntableByteSequenceFactory.newIntableByteSequence(byArray.length).append(ByteSequenceFactory.newByteSequence(byArray));
                        X509Certificate x509Certificate = (X509Certificate)CACertificates.getCACertificate(object4);
                        ByteSequence byteSequence2 = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(++n)).append(RecordEncodingFactory.newRecordEncoding(n, x509Certificate, object4, true)).append(BufferFactory.newBuffer(byteSequence.getInputStream())).append(ZERO).append(object2.generateCertificateSignatureHash(x509Certificate)).append(object2.generateTBSCertificateHash(x509Certificate)).append(object2.generateSubjectNameHash(x509Certificate)).append(object2.generateSubjectPublicKeyInfoHash(x509Certificate)).append(object2.generateIssuerAndSerialNumberHash(x509Certificate));
                        Record record = RecordFactory.newRecord(byteSequence2.getInputStream());
                        this.setFixedRecordLengh(record.length());
                        arrayList.add(record);
                    }
                }
                if (version == 4) {
                    intableByteSequence = ZERO_SHA1_HASH;
                    runtimeException = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.FOUR).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(intableByteSequence2).append(UNUSED_FILE_LABEL).append(intableByteSequence).append(intableByteSequence);
                } else {
                    intableByteSequence = ZERO_MD5_HASH;
                    runtimeException = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(intableByteSequence2).append(UNUSED_FILE_LABEL).append(intableByteSequence).append(intableByteSequence);
                }
                FileHeader fileHeader = FileHeaderFactory.newFileHeader(runtimeException.getInputStream());
                object3 = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(fileHeader).generateHash(fileHeader, this.storePassword);
                ByteSequence byteSequence4 = runtimeException = runtimeException.getSubSequence(0, runtimeException.length() - 2 * intableByteSequence.length()).append((ByteSequence)object3).append(intableByteSequence);
                for (Record record : arrayList) {
                    this.padRecord(record);
                    byteSequence4 = byteSequence4.append(record);
                }
                object2 = KeyDatabaseFactory.newKeyDatabase(byteSequence4.getInputStream());
                ByteSequence byteSequence = DatabaseHashGeneratorFactory.newDatabaseHashGenerator(fileHeader).generateHash((KeyDatabase)object2, this.storePassword);
                runtimeException = runtimeException.getSubSequence(0, runtimeException.length() - intableByteSequence.length()).append(byteSequence);
                byteSequence4 = populate ? runtimeException.append(byteSequence4.getSubSequence(runtimeException.length(), byteSequence4.length() - 1)) : runtimeException;
                this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(byteSequence4.getInputStream()));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        CMSKeyStoreSpi.trace("existing");
        CMSKeyStoreSpi.trace("stream.available=" + inputStream.available());
        try {
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(inputStream, true));
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(this.cmsKeyDatabase.getHeader().getFixedRecordLength().toInt());
            if (cArray != null && !this.cmsKeyDatabase.checkKeyStoreIntegrity(cArray)) {
                CMSKeyStoreSpi.trace("Incorrect Password");
                throw new IOException("Incorrect Password.");
            }
            this.cmsKeyDatabase.decodeRawRecords();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Invalid KeyStore Format.", runtimeException);
        }
        this.rebuildAliasesList();
    }

    public boolean engineEntryInstanceOf(String string, Class clazz) {
        boolean bl = false;
        if (this.engineIsKeyEntry(string)) {
            bl = clazz.isAssignableFrom(KeyStore.PrivateKeyEntry.class);
        }
        if (this.engineIsCertificateEntry(string)) {
            bl = clazz.isAssignableFrom(KeyStore.TrustedCertificateEntry.class);
        }
        CMSKeyStoreSpi.trace("engineEntryInstanceOf(\"" + string + "\", " + clazz.getName() + ") = " + bl);
        return bl;
    }

    private String getCorrectCaseLabel(String string) {
        for (String string2 : this.aliases) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return string2;
        }
        return string;
    }

    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, UnrecoverableEntryException {
        CMSKeyStoreSpi.trace("engineGetEntry(\"" + string + "\", ProtectionParameter)");
        KeyStore.Entry entry = null;
        try {
            if (!this.engineContainsAlias(string)) {
                return null;
            }
            String string2 = this.getCorrectCaseLabel(string);
            Record record = this.cmsKeyDatabase.getRecordByLabel(string2);
            if (record == null) {
                throw new KeyStoreException("Couldn't find the record with alias: \n" + string);
            }
            RecordEncoding recordEncoding = record.getEncoding();
            if (recordEncoding.isPrivateKeyPresent()) {
                Object[] objectArray;
                Object object;
                if (protectionParameter != null) {
                    object = CMSKeyStoreSpi.newPasswordExtractor(protectionParameter);
                    if (object == null) {
                        throw new UnrecoverableEntryException("Invalid Protection Parameter.");
                    }
                    objectArray = object.getPassword();
                    if (objectArray != null && !this.cmsKeyDatabase.checkPassword((char[])objectArray)) {
                        throw new UnrecoverableEntryException("Incorrect password provided.");
                    }
                }
                object = recordEncoding.getPrivateKey(this.storePassword.toCharArray());
                objectArray = this.engineGetCertificateChain(string);
                CMSPrivateKey cMSPrivateKey = CMSPrivateKeyFactory.newCMSPrivateKey((PrivateKey)object, recordEncoding.isDefaultKey());
                entry = new KeyStore.PrivateKeyEntry(cMSPrivateKey, (Certificate[])objectArray);
            } else {
                Certificate certificate = recordEncoding.getCertificate();
                CMSCertificate cMSCertificate = new CMSCertificate(certificate, recordEncoding.isTrusted());
                entry = new KeyStore.TrustedCertificateEntry(cMSCertificate);
            }
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            throw unrecoverableEntryException;
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception);
        }
        return entry;
    }

    public String engineTestLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, IllegalArgumentException, NoSuchAlgorithmException {
        this.engineLoad(loadStoreParameter);
        return ALGORITHM_ID;
    }

    public Boolean engineTestCertRecordID(String string, int n) {
        CMSKeyStoreSpi.trace("engineTestCertRecordID(\"" + string + "\", totalRecords)");
        if (!this.engineContainsAlias(string)) {
            return false;
        }
        String string2 = this.getCorrectCaseLabel(string);
        Record record = this.cmsKeyDatabase.getRecordByLabel(string2);
        if (record == null) {
            return false;
        }
        try {
            return record.getRecordId().toInt() == n && record.getEncoding().getRecordID() == n;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, IllegalArgumentException, NoSuchAlgorithmException {
        CMSKeyStoreSpi.trace("engineLoad(LoadStoreParameter loadstoreParam)");
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("CMS KeyStore requires LoadStoreParameter to load.");
        }
        if (!(loadStoreParameter instanceof CMSLoadParameter) || loadStoreParameter instanceof CMSStoreParameter) {
            throw new IllegalArgumentException("The provided LoadStoreParameter is not recognized");
        }
        CMSLoadParameter cMSLoadParameter = (CMSLoadParameter)loadStoreParameter;
        CMSKeyStoreSpi$PasswordExtractor cMSKeyStoreSpi$PasswordExtractor = CMSKeyStoreSpi.newPasswordExtractor(cMSLoadParameter.getProtectionParameter());
        if (cMSKeyStoreSpi$PasswordExtractor == null) {
            throw new IllegalArgumentException("Invalid Protection Parameter.");
        }
        FileInputStream fileInputStream = null;
        if (cMSLoadParameter.getKeyStoreFile() != null) {
            fileInputStream = new FileInputStream(cMSLoadParameter.getKeyStoreFile());
        }
        this.engineLoad(fileInputStream, cMSKeyStoreSpi$PasswordExtractor.getPassword());
        if (fileInputStream != null) {
            ((InputStream)fileInputStream).close();
        }
        cMSLoadParameter.setPasswordExpiry(this.cmsKeyDatabase.getHeader().getPasswordExpirationTime().toInt());
    }

    public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, IllegalArgumentException {
        CMSKeyStoreSpi.trace("engineSetEntry(\"" + string + "\", KeyStore.Entry, KeyStore.ProtectionParameter)");
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            Object object;
            char[] cArray = null;
            if (protectionParameter != null) {
                object = CMSKeyStoreSpi.newPasswordExtractor(protectionParameter);
                if (object == null) {
                    throw new IllegalArgumentException("Invalid Protection Parameter.");
                }
                try {
                    cArray = object.getPassword();
                    if (cArray != null && !this.cmsKeyDatabase.checkPassword(cArray)) {
                        throw new KeyStoreException("The password supplied throug the ProtectionParameter interface is invalid, it must match the KeyStore password or null");
                    }
                }
                catch (Exception exception) {
                    throw new KeyStoreException(exception);
                }
            }
            object = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(string, ((KeyStore.PrivateKeyEntry)object).getPrivateKey(), this.storePassword.toCharArray(), ((KeyStore.PrivateKeyEntry)object).getCertificateChain());
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(string, trustedCertificateEntry.getTrustedCertificate());
        } else {
            throw new KeyStoreException("Invalid Key Entry.");
        }
    }

    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, IllegalArgumentException, NoSuchAlgorithmException {
        FileLock fileLock;
        Object object;
        CMSKeyStoreSpi.trace("engineStore(LoadStoreParameter)");
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("CMS KeyStore requires LoadStoreParameter to store.");
        }
        if (!(loadStoreParameter instanceof CMSStoreParameter)) {
            throw new IllegalArgumentException("The given LoadStoreParameter is not recognized");
        }
        CMSStoreParameter cMSStoreParameter = (CMSStoreParameter)loadStoreParameter;
        KeyStore.ProtectionParameter protectionParameter = cMSStoreParameter.getProtectionParameter();
        char[] cArray = null;
        if (protectionParameter != null) {
            object = CMSKeyStoreSpi.newPasswordExtractor(protectionParameter);
            if (object == null) {
                throw new IllegalArgumentException("Invalid Protection Parameter.");
            }
            cArray = object.getPassword();
        }
        this.setPasswordExpiry(cMSStoreParameter.getPasswordExpiry());
        object = new FileOutputStream(cMSStoreParameter.getKeyStoreFile(), true);
        FileChannel fileChannel = ((FileOutputStream)object).getChannel();
        try {
            fileLock = fileChannel.tryLock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            ((FileOutputStream)object).close();
            throw new IOException("Unable to acquire file lock for " + cMSStoreParameter.getKeyStoreFile());
        }
        if (fileLock != null) {
            fileChannel.truncate(0L);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
            this.engineStore(bufferedOutputStream, cArray);
            bufferedOutputStream.close();
            if (cMSStoreParameter.isStashPassword()) {
                String string = cMSStoreParameter.getKeyStoreFile().getAbsolutePath();
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    n = string.length();
                }
                StringBuilder stringBuilder = new StringBuilder(string.subSequence(0, n)).append(STASH_FILE_EXT);
                if (cMSStoreParameter.isV1StashPassword()) {
                    this.stashKeyDbPwd(stringBuilder.toString(), true);
                } else {
                    this.stashKeyDbPwd(stringBuilder.toString(), false);
                }
            }
        } else {
            ((FileOutputStream)object).close();
            throw new IOException("Unable to acquire file lock for " + cMSStoreParameter.getKeyStoreFile());
        }
    }

    private void setPasswordExpiry(int n) throws IOException {
        try {
            Sequence sequence = this.cmsKeyDatabase.getRecords();
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(this.analyzeMaxRecordLength(sequence));
            this.padRecords(sequence);
            ByteSequence byteSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(IntableByteSequenceFactory.newIntableByteSequence(n)).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(sequence.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
            for (Record record : sequence) {
                byteSequence = byteSequence.append(record);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(byteSequence.getInputStream()));
            this.updateHeaderHashes();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private void stashKeyDbPwd(String string, boolean bl) throws IOException, NoSuchAlgorithmException {
        byte[] byArray = new byte[129];
        byte[] byArray2 = this.storePassword.getBytes("UTF-8");
        boolean bl2 = new File(string).exists();
        for (int i = 0; i < 129; ++i) {
            byArray[i] = i < byArray2.length ? byArray2[i] : (i == byArray2.length ? (byte)0 : (byte)i);
        }
        ByteSequence byteSequence = ByteSequenceFactory.newByteSequence(byArray);
        ByteSequence byteSequence2 = ByteSequenceFactory.newConstantByteSequence((byte)-11, 129);
        ByteSequence byteSequence3 = ByteSequenceXorFactory.newByteSequenceXor().xor(byteSequence, byteSequence2);
        byte[] byArray3 = new byte[129];
        ByteSequenceIterator byteSequenceIterator = byteSequence3.getIterator();
        int n = 0;
        while (byteSequenceIterator.hasNextByte()) {
            byArray3[n++] = byteSequenceIterator.getNextByte();
        }
        if (bl && bl2 && AConverter.isNew(string)) {
            bl = false;
        }
        if (!bl) {
            try {
                byteSequence3 = AConverter.cc(byArray3);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new RuntimeException("Invalid keys", invalidKeyException);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byteSequenceIterator = byteSequence3.getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            ((OutputStream)fileOutputStream).write(byteSequenceIterator.getNextByte());
        }
        ((OutputStream)fileOutputStream).close();
    }

    private void setFixedRecordLengh(int n) {
        if (n > this.FIXED_RECORD_LENGTH) {
            this.FIXED_RECORD_LENGTH = (int)(Math.ceil((double)n / 1000.0) * 1000.0);
        }
    }

    private void resetFixedRecordLengh() {
    }

    private int getFixedRecordLengh() {
        return this.FIXED_RECORD_LENGTH;
    }

    private int analyzeMaxRecordLength(Collection collection) {
        int n = 0;
        for (Record record : collection) {
            if (record.length() <= n) continue;
            n = record.length();
        }
        return n;
    }

    private int analyzeMaxRecordLength(Sequence sequence) {
        int n = 0;
        for (Record record : sequence) {
            if (record.length() <= n) continue;
            n = record.length();
        }
        return n;
    }

    private void padRecords(Sequence sequence) {
        for (Record record : sequence) {
            this.padRecord(record);
        }
    }

    private void padRecords(Collection collection) {
        for (Record record : collection) {
            this.padRecord(record);
        }
    }

    private ByteSequence padRecord(Record record) {
        return record.expand(this.getFixedRecordLengh() - record.length());
    }
}

