/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileType;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.InputStream;

final class FileHeaderFactory$FileHeaderImpl
implements FileHeader {
    private final IntableByteSequence magicNumber;
    private final VersionNumber majorVersionNumber;
    private final VersionNumber minorVersionNumber;
    private final IntableByteSequence passwordExpirationTime;
    private final FileType fileType;
    private final IntableByteSequence fixedRecordLength;
    private final IntableByteSequence recordsAllocated;
    private final ByteSequence fileLabel;
    private final ByteSequence passwordHeaderHash;
    private final ByteSequence passwordDatabaseHash;
    private final ByteSequence sequence;

    FileHeaderFactory$FileHeaderImpl(IntableByteSequence intableByteSequence, VersionNumber versionNumber, VersionNumber versionNumber2, IntableByteSequence intableByteSequence2, FileType fileType, IntableByteSequence intableByteSequence3, IntableByteSequence intableByteSequence4, ByteSequence byteSequence, ByteSequence byteSequence2, ByteSequence byteSequence3) {
        this.magicNumber = intableByteSequence;
        this.majorVersionNumber = versionNumber;
        this.minorVersionNumber = versionNumber2;
        this.passwordExpirationTime = intableByteSequence2;
        this.fileType = fileType;
        this.fixedRecordLength = intableByteSequence3;
        this.recordsAllocated = intableByteSequence4;
        this.fileLabel = byteSequence;
        this.passwordHeaderHash = byteSequence2;
        this.passwordDatabaseHash = byteSequence3;
        this.sequence = intableByteSequence.append(versionNumber).append(versionNumber2).append(intableByteSequence2).append(fileType).append(intableByteSequence3).append(intableByteSequence4).append(byteSequence).append(byteSequence2).append(byteSequence3);
    }

    public IntableByteSequence getMagicNumber() {
        return this.magicNumber;
    }

    public VersionNumber getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public VersionNumber getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public IntableByteSequence getPasswordExpirationTime() {
        return this.passwordExpirationTime;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public IntableByteSequence getFixedRecordLength() {
        return this.fixedRecordLength;
    }

    public IntableByteSequence getRecordsAllocated() {
        return this.recordsAllocated;
    }

    public ByteSequence getFileLabel() {
        return this.fileLabel;
    }

    public ByteSequence getPasswordHeaderHash() {
        return this.passwordHeaderHash;
    }

    public ByteSequence getPasswordDatabaseHash() {
        return this.passwordDatabaseHash;
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.get(n);
    }

    public int length() {
        return this.sequence.length();
    }

    public ByteSequence append(ByteSequence byteSequence) throws NullPointerException {
        if (byteSequence == null) {
            throw new NullPointerException();
        }
        if (byteSequence.length() == 0) {
            return this;
        }
        return this.sequence.append(byteSequence);
    }

    public ByteSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > this.sequence.length() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.getSubSequence(n, n2);
    }

    public int indexOf(byte by) {
        return this.sequence.indexOf(by);
    }

    public int indexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.sequence.indexOf(n, by);
    }

    public int lastIndexOf(byte by) {
        return this.sequence.lastIndexOf(by);
    }

    public int lastIndexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.sequence.lastIndexOf(n, by);
    }

    public boolean isEmpty() {
        return this.sequence.isEmpty();
    }

    public InputStream getInputStream() {
        return this.sequence.getInputStream();
    }

    public ByteSequenceIterator getIterator() {
        return this.sequence.getIterator();
    }

    public ByteSequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.sequence.getIterator(n);
    }

    public String toBinaryString() {
        return this.sequence.toBinaryString();
    }

    public String toOctalString() {
        return this.sequence.toOctalString();
    }

    public String toHexString() {
        return this.sequence.toHexString();
    }

    public String toString() {
        return this.sequence.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ByteSequence)) {
            return false;
        }
        ByteSequence byteSequence = (ByteSequence)object;
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        ByteSequenceIterator byteSequenceIterator2 = byteSequence.getIterator();
        while (byteSequenceIterator.hasNextByte() && byteSequenceIterator2.hasNextByte()) {
            byte by;
            byte by2 = byteSequenceIterator.getNextByte();
            if (by2 == (by = byteSequenceIterator2.getNextByte())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.sequence.hashCode();
    }
}

