/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

public final class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    static final long serialVersionUID = 7885790631402109830L;
    private static final BigInteger PKCS8_VERSION;
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static final String[] a;

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(a[0]);
        }
    }

    public DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(a[9]);
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException(a[1] + PKCS8_VERSION + a[5] + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(a[2]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(a[3]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(a[6]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(a[8]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(a[4]);
            }
            this.key = derValue.getData().getOctetString();
            this.a();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(a[7]);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public String getFormat() {
        return a[11];
    }

    @Override
    public String getAlgorithm() {
        return a[10];
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(this.p);
                derOutputStream3.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream3.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.x, this.p, this.g};
        return Arrays.hashCode(objectArray);
    }

    public boolean equals(Object object) {
        block16: {
            block17: {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof javax.crypto.interfaces.DHPrivateKey)) {
                    return false;
                }
                javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)object;
                DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
                if (this.x.compareTo(dHPrivateKey.getX()) != 0 || this.p.compareTo(dHParameterSpec.getP()) != 0) break block16;
                if (this.g.compareTo(dHParameterSpec.getG()) != 0) break block16;
                if (!(object instanceof DHPrivateKey)) break block17;
                return true;
            }
            boolean bl = this.hashCode() == object.hashCode();
            return bl;
        }
        return false;
    }

    public void zeroize() {
        this.x = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.g = BigInteger.ZERO;
        this.l = 0;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\t7\b@|>v\u0016\\|.#\u0005K3\u000b\u0005(\u0000\"j3\bM|.?\bI";
        int n3 = -1;
        block19: while (true) {
            char[] cArray;
            block24: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block23: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block23;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block24;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 74;
                                break;
                            }
                            case 1: {
                                n9 = 86;
                                break;
                            }
                            case 2: {
                                n9 = 102;
                                break;
                            }
                            case 3: {
                                n9 = 46;
                                break;
                            }
                            default: {
                                n9 = 19;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "<3\u0014]z%8FCz9;\u0007Zp\"lF\u0006`?&\u0016Aa>3\u0002\u00143";
                    n3 = 0;
                    continue block19;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000b:\u0001gwj?\u0015\u000e}%\"FO3\u0019\u00137{V\u0004\u0015#";
                    n3 = 1;
                    continue block19;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001a7\u0014O~/\"\u0003\\`j;\u000f]`#8\u0001";
                    n3 = 2;
                    continue block19;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000f.\u0012\\rj&\u0007\\r'3\u0012Kaj2\u0007Zr";
                    n3 = 3;
                    continue block19;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "fv\u0016Oa93\u0002\u00143";
                    n3 = 4;
                    continue block19;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0004#\nB3:7\u0014O~/\"\u0003\\`";
                    n3 = 5;
                    continue block19;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001a$\u000fXr>3KXr&#\u0003\u000e\u007f/8\u0001Z{j\"\tA3(?\u0001";
                    n3 = 6;
                    continue block19;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001a7\u0014O~/\"\u0003\\`j8\tZ3+v5kB\u001f\u0013(mV";
                    n3 = 7;
                    continue block19;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u00013\u001f\u000e}%\"FO3\u0019\u00137{V\u0004\u0015#";
                    n3 = 8;
                    continue block19;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u000e\u001e";
                    n3 = 9;
                    continue block19;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001a\u001d%}0r";
                    n3 = 10;
                    continue block19;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
        PKCS8_VERSION = BigInteger.valueOf(0L);
    }
}

