/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.DHPrivateKey;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

public final class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static final String[] a;

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(a[14]);
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(a[10]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(a[8]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(a[11]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(a[6]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(a[12]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(a[9]);
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(a[13]);
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(a[7]);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public String getFormat() {
        return a[5];
    }

    @Override
    public String getAlgorithm() {
        return a[0];
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(a[4] + this.y.toString() + "\n" + a[1] + this.p.toString() + "\n" + a[2] + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(a[3] + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.y, this.p, this.g};
        return Arrays.hashCode(objectArray);
    }

    public boolean equals(Object object) {
        block16: {
            block17: {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof javax.crypto.interfaces.DHPublicKey)) {
                    return false;
                }
                javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)object;
                DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                if (this.y.compareTo(dHPublicKey.getY()) != 0 || this.p.compareTo(dHParameterSpec.getP()) != 0) break block16;
                if (this.g.compareTo(dHParameterSpec.getG()) != 0) break block16;
                if (!(object instanceof DHPrivateKey)) break block17;
                return true;
            }
            boolean bl = this.hashCode() == object.hashCode();
            return bl;
        }
        return false;
    }

    public void zeroize() {
        this.y = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.g = BigInteger.ZERO;
        this.l = 0;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u001c9";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block27: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block26: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block26;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block27;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 88;
                                break;
                            }
                            case 1: {
                                n9 = 113;
                                break;
                            }
                            case 2: {
                                n9 = 61;
                                break;
                            }
                            case 3: {
                                n9 = 106;
                                break;
                            }
                            default: {
                                n9 = 96;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "(K7";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "?K7";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "R\u001d\u0007`@xQ\u001d";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u00113p #\u001d7t:3x5T\f\u00061\u0014\u0010\"\u00054\u001dP\u000b\u000ex!H\b\f1\u0012\u001d!\u0005!K7\u0013ZR";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0000_\bZY";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0016\u0004Q\u0006@(\u0010O\u000b\r=\u0005X\u0018\u0013";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\b\u0003T\u001c\u0001,\u0014\u0010\u001c\u00014\u0004XJ\f=\u001fZ\u001e\bx\u0005R\u0005@:\u0018Z";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0019\u001dZ#\u0004x\u0018NJ\u000e7\u0005\u001d\u000b@\u000b4l?%\u00162x";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u001d\tI\u0018\u0001x\u0001\\\u0018\u00015\u0014I\u000f\u0012x\u0015\\\u001e\u0001";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0011\u001fK\u000b\f1\u0015\u001d\u0001\u0005!Q[\u0005\u00125\u0010I";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\b\u0010O\u000b\r=\u0005X\u0018\u0013x\u001cT\u0019\u00131\u001fZ";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\b\u0010O\u000b\r=\u0005X\u0018\u0013x\u001fR\u001e@9Qn/1\r4s)%";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u001d\t^\u000f\u0013+QV\u000f\u0019x\u0015\\\u001e\u0001";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u001b\u0010S\u0004\u000f,QM\u0018\u000f<\u0004^\u000f@\u0019\"sDQx\u0014S\t\u000f<\u0018S\r";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

