/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECParameterGenerator;
import com.ibm.crypto.fips.provider.ECPrivateKey;
import com.ibm.crypto.fips.provider.ECPublicKey;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.crypto.fips.provider.PrimeCurve;
import com.ibm.crypto.fips.provider.PrimeField;
import com.ibm.crypto.fips.provider.SHA2withECDSA;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] d;

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        block15: {
            block14: {
                if (n2 < 192 || n2 > 521) break block14;
                if (n2 == 192) break block15;
                if (n2 == 224) break block15;
                if (n2 == 256) break block15;
                if (n2 == 384) break block15;
                if (n2 == 521) break block15;
            }
            throw new InvalidParameterException(d[0]);
        }
        this.a = n2;
        this.b = IBMJCEFIPS.f();
        this.c = null;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        block6: {
            block7: {
                block8: {
                    if (algorithmParameterSpec instanceof ECParameterSpec) break block6;
                    if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) break block7;
                    this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
                    if (this.c != null) break block8;
                    throw new InvalidAlgorithmParameterException(d[3]);
                }
                this.b = secureRandom;
                this.a = this.c.getCurve().getField().getFieldSize();
                return;
            }
            throw new InvalidAlgorithmParameterException(d[2]);
        }
        this.c = ECUtils.getPrimeParameterSpec((ECParameterSpec)algorithmParameterSpec);
        this.b = IBMJCEFIPS.f();
        this.a = this.c.getCurve().getField().getFieldSize();
    }

    @Override
    public KeyPair generateKeyPair() {
        String string = d[4];
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        KeyPair keyPair = this.a();
        if (!this.a(keyPair)) {
            SelfTest.failure = new FIPSRuntimeException(string);
            SelfTest.state = SelfTest.ERROR;
            throw new FIPSRuntimeException(string);
        }
        return keyPair;
    }

    protected KeyPair a() {
        if (this.b == null) {
            this.b = IBMJCEFIPS.f();
        }
        if (this.c == null) {
            this.b();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        int n3 = 64;
        BigInteger bigInteger = new BigInteger(n2 + n3, this.b);
        bigInteger = bigInteger.abs();
        try {
            PrimeCurve primeCurve = ECUtils.getPrimeCurve(this.c.getCurve());
            BigInteger bigInteger2 = ((ECFieldFp)primeCurve.getField()).getP().subtract(BigInteger.ONE);
            BigInteger bigInteger3 = bigInteger.mod(bigInteger2).add(BigInteger.ONE);
            ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger3), primeCurve.toEllipticPoint(this.c.getGenerator())).getAffine();
            ECPublicKey eCPublicKey = new ECPublicKey(eCPoint, this.c);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger3, this.c, eCPublicKey);
            KeyPair keyPair = new KeyPair(eCPublicKey, eCPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void b() {
        switch (this.a) {
            case 192: {
                PrimeField primeField = ECUtils.getField(192, ECParameterGenerator.a, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.a), ECParameterGenerator.c, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.f, ECParameterGenerator.b, 1);
                break;
            }
            case 224: {
                PrimeField primeField = ECUtils.getField(224, ECParameterGenerator.g, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.g), ECParameterGenerator.i, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.l, ECParameterGenerator.h, 1);
                break;
            }
            case 256: {
                PrimeField primeField = ECUtils.getField(256, ECParameterGenerator.m, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.m), ECParameterGenerator.o, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.r, ECParameterGenerator.n, 1);
                break;
            }
            case 384: {
                PrimeField primeField = ECUtils.getField(384, ECParameterGenerator.s, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.s), ECParameterGenerator.u, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.x, ECParameterGenerator.t, 1);
                break;
            }
            case 521: {
                PrimeField primeField = ECUtils.getField(521, ECParameterGenerator.y, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.y), ECParameterGenerator.A, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.D, ECParameterGenerator.z, 1);
            }
        }
    }

    private boolean a(KeyPair keyPair) {
        PrivateKey privateKey;
        PublicKey publicKey;
        byte[] byArray = d[1].getBytes();
        try {
            publicKey = keyPair.getPublic();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            privateKey = keyPair.getPrivate();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            SHA2withECDSA sHA2withECDSA = new SHA2withECDSA();
            sHA2withECDSA.a(privateKey);
            sHA2withECDSA.a(byArray, 0, byArray.length);
            byte[] byArray2 = sHA2withECDSA.c();
            sHA2withECDSA.a(publicKey);
            sHA2withECDSA.a(byArray, 0, byArray.length);
            if (!sHA2withECDSA.a(byArray2)) {
                ((ECPublicKey)publicKey).zeroize();
                ((ECPrivateKey)privateKey).zeroize();
                return false;
            }
        }
        catch (Exception exception) {
            ((ECPublicKey)publicKey).zeroize();
            ((ECPrivateKey)privateKey).zeroize();
            return false;
        }
        return true;
    }

    protected void finalize() {
        this.b = null;
        this.c = null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "tx\u001bUP\u0004y\u001bBP\u0004g\u0007KA\u0004h\u0017\u0018ZJoRWS\u001e*C\u0001\u0007\b*@\n\u0001\b*@\r\u0003\b*A\u0000\u0001\b*G\n\u0004";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 36;
                                break;
                            }
                            case 1: {
                                n9 = 10;
                                break;
                            }
                            case 2: {
                                n9 = 114;
                                break;
                            }
                            case 3: {
                                n9 = 56;
                                break;
                            }
                            default: {
                                n9 = 53;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "eH1|pbM:q\u007foF?vzt[ kaq\\%`b~";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "tk\u0000YXW*\u001fMFP*\u0010]\u0015Md\u0001LTJi\u0017\u0018ZB*7{eEx\u0013UPPo\u0000kEAiRWG\u0004O1\u007fPJZ\u0013JTIo\u0006]Gwz\u0017[";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "g\u007f\u0000NP\u0004d\u0013UP\u0004d\u001dL\u0015Vo\u0011WRJc\b]Q\u0004e\u0000\u0018[K~RK@Tz\u001dJAAn";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "aI6kt\u0004Y\u001b_[\u0004,RnPVc\u0014A\u0015po\u0001L\u0015bk\u001bTP@$Rl]A*;zxnI7~|tYRHGK|\u001b\\PV*\u001bK\u0015MdRY[\u0004c\u001c[ZJy\u001bKAAd\u0006\u0018FPk\u0006]\u001b\u0004X\u0017KAEx\u0006\u0018ALoRrTRkRn\\V~\u0007YY\u0004G\u0013[]Md\u0017\u0016\u0015mlRL]A*\u0017JGKxRHPVy\u001bKAW&RHYAk\u0001]\u0015Ge\u001cLTG~Rqwi*!METe\u0000L\u001b";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        d = stringArray3;
    }
}

