/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.crypto.fips.provider.PrimeCurve;
import com.ibm.crypto.fips.provider.PrimeField;
import com.ibm.crypto.fips.provider.SelfTest;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ECParameters
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private static final String[] e;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (SelfTest.isFipsRunnable()) {
            return this.a();
        }
        throw new FIPSRuntimeException();
    }

    protected byte[] a() throws IOException {
        byte[] byArray = this.encodeECParameters();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected <T extends AlgorithmParameterSpec> T a(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName(e[1]);
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)((AlgorithmParameterSpec)clazz.cast(new ECParameterSpec(this.b, this.c, this.d, this.a)));
            }
            throw new InvalidParameterSpecException(e[2]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(e[3] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(algorithmParameterSpec);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        ECParameterSpec eCParameterSpec;
        block9: {
            if (algorithmParameterSpec == null) {
                throw new InvalidParameterSpecException(e[9]);
            }
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            } else {
                if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                    String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                    eCParameterSpec = ECNamedCurve.getECParameterSpec(string);
                    if (eCParameterSpec == null) {
                        throw new InvalidParameterSpecException(e[10] + string);
                    }
                    break block9;
                }
                throw new InvalidParameterSpecException(e[8]);
            }
        }
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(byArray);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.decodeECParameters(byArray);
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        if (SelfTest.isFipsRunnable()) {
            return this.b();
        }
        throw new FIPSRuntimeException();
    }

    protected String b() {
        return e[20] + this.b.getA() + e[15] + this.b.getB() + e[19] + this.b.getField().getFieldSize() + e[17] + ECUtils.a(this.c) + e[18] + this.d.toString() + e[16] + this.a + "\n";
    }

    protected static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(e[23], IBMJCEFIPS.getInstance());
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(e[22] + generalSecurityException);
        }
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        byte[] byArray;
        byte[] byArray2;
        int n2;
        block4: {
            int n3 = ellipticCurve.getField().getFieldSize();
            n2 = n3 + 7 >> 3;
            byArray2 = ECParameters.b(eCPoint.getAffineX().toByteArray());
            byArray = ECParameters.b(eCPoint.getAffineY().toByteArray());
            if (byArray2.length <= n2 && byArray.length <= n2) break block4;
            throw new RuntimeException(e[24]);
        }
        byte[] byArray3 = new byte[1 + (n2 << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
        return byArray3;
    }

    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        block7: {
            if (byArray.length != 0 && byArray[0] == 4) break block7;
            throw new IOException(e[13]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(e[14]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    static byte[] b(byte[] byArray) {
        int n2 = 0;
        while (true) {
            if (n2 >= byArray.length - 1 || byArray[n2] != 0) break;
            ++n2;
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static DerValue encodeEllipticCurve(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.b(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.b(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(e[21] + iOException);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(e[5]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            PrimeCurve primeCurve = null;
            int n2 = 0;
            if (ECUtils.isNistPrime(((ECFieldFp)eCField).getP())) {
                n2 = 1;
            }
            primeCurve = byArray3 == null ? ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, n2) : ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, byArray3, n2);
            return primeCurve;
        }
        catch (IOException iOException) {
            throw new IOException(e[4] + iOException);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(e[0] + iOException);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(e[25]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(e[27]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = (ECFieldFp)((Object)ECUtils.getField(bigInteger.bitLength(), bigInteger, ECUtils.isNistPrime(bigInteger)));
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(e[26] + iOException);
        }
    }

    public byte[] encodeECParameters() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            if (eCNamedCurve != null) {
                return eCNamedCurve.a();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(e[12]);
            }
            DerValue derValue = ECParameters.encodePrimeFieldType((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.encodeEllipticCurve(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(e[11] + iOException);
        }
    }

    public static ECParameterSpec decodeECParameters(byte[] byArray) throws IOException {
        boolean bl = false;
        try {
            DerValue derValue;
            block5: {
                block6: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValue = derInputStream.getDerValue();
                    if (derValue.getTag() == 48) break block5;
                    if (derValue.getTag() != 6) break block6;
                    String string = derValue.getOID().toString();
                    return ECNamedCurve.getECParameterSpec(string);
                }
                throw new IOException(e[7]);
            }
            DerInputStream derInputStream = derValue.getData();
            int n2 = derInputStream.getInteger().intValue();
            DerValue derValue2 = derInputStream.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.decodePrimeFieldType(derValue2);
            DerValue derValue3 = derInputStream.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.decodeEllipticCurve(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream.getOctetString();
            ECPoint eCPoint = ECParameters.decodePoint(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                bl = true;
                n3 = derInputStream.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(e[6] + iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ECNamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        try {
            String string;
            Map<String, ECParameterSpec> map = ECNamedCurve.b();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            Iterator<Map.Entry<String, ECParameterSpec>> iterator = set.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                Map.Entry<String, ECParameterSpec> entry = iterator.next();
                string = entry.getKey();
                ECParameterSpec eCParameterSpec2 = entry.getValue();
                eCParameterSpec2 = ECUtils.getPrimeParameterSpec(eCParameterSpec2);
                eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
                BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                byte[] byArray2 = eCParameterSpec2.getCurve().getSeed();
                byte[] byArray = eCParameterSpec.getCurve().getSeed();
                if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4) || n2 != n3) continue;
                if (byArray2 != null || byArray != null) {
                    if (byArray2 == null && byArray != null || byArray2 != null && byArray == null) continue;
                    if (byArray2 != null && byArray != null) {
                        if (byArray2.length != byArray.length) continue;
                        boolean bl = true;
                        for (int n4 = 0; n4 < byArray2.length; ++n4) {
                            if (byArray2[n4] == byArray[n4]) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                    }
                }
                if (eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator()) && eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder()) && eCParameterSpec2.getCofactor() == eCParameterSpec.getCofactor()) break;
            }
            return new ECNamedCurve(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "er\u00177BTc\u001b<\u0012IdT7\\Ce\u00107bRc\u00197tIo\u00186fYz\u0011z\u001b\u001a*";
        int n3 = -1;
        block35: while (true) {
            char[] cArray;
            block40: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block39: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block39;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block40;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 32;
                                break;
                            }
                            case 1: {
                                n9 = 10;
                                break;
                            }
                            case 2: {
                                n9 = 116;
                                break;
                            }
                            case 3: {
                                n9 = 82;
                                break;
                            }
                            default: {
                                n9 = 50;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Jk\u00023\u001cSo\u0017'@I~\r|APo\u0017|wcZ\u0015 SMo\u00007@sz\u00111";
                    n3 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "id\u0015\"BRe\u0004 [A~\u0011rBAx\u0015?WTo\u0006raPo\u0017;TIi\u0015&[Od";
                    n3 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "ud\u0007'BPe\u0006&WD*\u00043@Ag\u0011&WR*\u0007\"WCc\u0012;QA~\u001d=\\\u001a*";
                    n3 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "er\u00177BTc\u001b<\u0012IdT6WCe\u00107wLf\u001d\"FIi7'@Vo\\{\b\u0000";
                    n3 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "ne\u0000rS\u0000Y1\u0003geD7\u0017";
                    n3 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "er\u00177BTc\u001b<\u0012IdT6WCe\u00107wcZ\u0015 SMo\u00007@S\"]h\u0012";
                    n3 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "ne\u0000rS\u0000Y1\u0003geD7\u0017\u0012OxT3\\\u0000E=\u0016";
                    n3 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "id\u0015\"BRe\u0004 [A~\u0011rBAx\u0015?WTo\u0006rAPo\u0017;TIi\u0015&[Od";
                    n3 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Pk\u00063_sz\u00111\u0012M\u007f\u0007&\u0012Ne\u0000rPE*\u001a'^L";
                    n3 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "ud\u001f<]WdT1GR|\u0011h\u0012";
                    n3 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "er\u00177BTc\u001b<\u0012IdT7\\Ce\u00107wcZ\u0015 SMo\u00007@S\"]h\u0012";
                    n3 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "eI2;WLn2`_\u0000o\u001a1]Ud\u00007@EnT;\\\u0000o\u001a1]Do1\u0011bAx\u0015?WTo\u0006!\u001a\t$TrwcL\u001d7^DLF?\u0012IyT<]T*\u0017'@Ro\u001a&^Y*\u0007'BPe\u0006&WD$";
                    n3 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "od\u0018+\u0012Ud\u0017=_Px\u0011!AEnT\"]Id\u0000rTOx\u00193F\u0000y\u0001\"BOx\u00007V";
                    n3 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "pe\u001d<F\u0000n\u001b7A\u0000d\u001b&\u0012Mk\u00001Z\u0000l\u001d7^D*\u0007;HE";
                    n3 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "*\u0003}0\b\u0000";
                    n3 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "*\u0003\u0017=TAi\u0000=@\u001a*";
                    n3 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "*\u0003\u00137\\Ex\u0015&]R0TX;)";
                    n3 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "*\u0003\u001b VExNr8)\u0003";
                    n3 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "*\u0003}![ZoNr";
                    n3 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "*\u0003\u0017'@VoNr8)\u0003\u0015h\u0012";
                    n3 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "er\u00177BTc\u001b<\u0012IdT7\\Ce\u00107wLf\u001d\"FIi7'@Vo\\{\b\u0000";
                    n3 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "ud\u0007'BPe\u0006&WD*\u00043@Ag\u0011&WR*\u0007\"WCc\u0012;QA~\u001d=\\\u001a*";
                    n3 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "eI";
                    n3 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "pe\u001d<F\u0000i\u001b=@Dc\u001a3FEyT6]\u0000d\u001b&\u0012Mk\u00001Z\u0000l\u001d7^D*\u0007;HE";
                    n3 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "ne\u0000rS\u0000Y1\u0003geD7\u0017";
                    n3 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "er\u00177BTc\u001b<\u0012IdT6WCe\u00107bRc\u00197tIo\u00186fYz\u0011z\u001b\u001a*";
                    n3 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "id\u0017=@Ro\u0017&\u0012oC0rWNi\u001b'\\To\u00067V\u0000n\u0001 [NmT6WCe\u00107bRc\u00197tIo\u00186fYz\u0011|";
                    n3 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        e = stringArray3;
    }
}

