/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECParameters;
import com.ibm.crypto.fips.provider.ECPublicKey;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.PrimeCurve;
import com.ibm.crypto.fips.provider.PrimeField;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import ibm.security.internal.spec.RFC5915ECPrivateKeyEncodedKeySpec;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.ECPrivateKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962695L;
    private BigInteger s;
    private ECParameterSpec params;
    private ECPublicKey publicKey = null;
    private byte[] publicKeyBytes = null;
    private static final String[] a;

    public ECPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public ECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this(bigInteger, eCParameterSpec, null);
    }

    public ECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec, ECPublicKey eCPublicKey) throws InvalidKeyException, InvalidParameterSpecException {
        this.s = bigInteger;
        this.params = eCParameterSpec;
        this.publicKey = eCPublicKey;
        if (this.publicKey == null) {
            try {
                this.publicKey = ECPrivateKey.a(bigInteger, eCParameterSpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AlgorithmParameters algorithmParameters = ECParameters.a(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, algorithmParameters);
        try {
            byte[] byArray = ECParameters.b(bigInteger.toByteArray());
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            ObjectIdentifier objectIdentifier = eCNamedCurve != null ? ECNamedCurve.getOIDFromName(eCNamedCurve.getName()) : null;
            ObjectIdentifier objectIdentifier2 = objectIdentifier;
            byte[] byArray2 = this.publicKey != null ? this.publicKey.getEncoded() : null;
            byte[] byArray3 = byArray2;
            com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(byArray, objectIdentifier2, byArray3);
            this.key = eCPrivateKey.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public ECPrivateKey(RFC5915ECPrivateKeyEncodedKeySpec rFC5915ECPrivateKeyEncodedKeySpec) throws InvalidKeyException {
        try {
            com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(rFC5915ECPrivateKeyEncodedKeySpec.getEncoded());
            this.key = rFC5915ECPrivateKeyEncodedKeySpec.getEncoded();
            this.s = new BigInteger(1, eCPrivateKey.getKeyBytes());
            ObjectIdentifier objectIdentifier = eCPrivateKey.getNamedCurve();
            if (objectIdentifier == null) {
                throw new InvalidKeyException(a[7]);
            }
            this.params = ECNamedCurve.a(objectIdentifier);
            this.publicKeyBytes = eCPrivateKey.getPublicKeyBytes();
            this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(this.params));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(invalidParameterSpecException);
        }
    }

    protected void parseKeyBits() throws IOException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                throw new IOException(a[0]);
            }
            this.params = ECUtils.getPrimeParameterSpec(algorithmParameters.getParameterSpec(ECParameterSpec.class));
            com.ibm.security.rfc5915.ECPrivateKey eCPrivateKey = new com.ibm.security.rfc5915.ECPrivateKey(this.key);
            this.s = new BigInteger(1, eCPrivateKey.getKeyBytes());
            this.publicKeyBytes = eCPrivateKey.getPublicKeyBytes();
        }
        catch (IOException iOException) {
            throw new IOException(a[1]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(a[2]);
        }
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public ECPublicKey getPublicKey() {
        block10: {
            block11: {
                if (this.publicKey != null) break block10;
                if (this.publicKeyBytes == null) break block11;
                try {
                    this.publicKey = new ECPublicKey(ECParameters.decodePoint(this.publicKeyBytes, this.params.getCurve()), this.params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.publicKey == null) {
                try {
                    this.publicKey = ECPrivateKey.a(this.s, this.params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.publicKey == null) {
                throw new RuntimeException(a[6]);
            }
        }
        return this.publicKey;
    }

    public byte[] getEncoded(String string) {
        if (string.equals(a[3])) {
            return this.getEncoded();
        }
        if (string.equals(a[4])) {
            return this.key;
        }
        throw new InvalidParameterException(a[5] + string);
    }

    private static ECPublicKey a(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        PrimeCurve primeCurve = ECUtils.getPrimeCurve(eCParameterSpec.getCurve());
        ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger), primeCurve.toEllipticPoint(eCParameterSpec.getGenerator())).getAffine();
        return new ECPublicKey(eCPoint, eCParameterSpec);
    }

    public void zeroize() {
        this.s = BigInteger.ZERO;
        this.params = null;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "f \"b)N\u0002khfS\u0002pg+F\u0017gt5\u0003\u000ewu2\u0003\u0001g&#M\u0000mb#GCkhfW\u000bg&'O\u0004mt/W\u000bo&/G\u0006lr/E\ngt";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 35;
                                break;
                            }
                            case 1: {
                                n9 = 99;
                                break;
                            }
                            case 2: {
                                n9 = 2;
                                break;
                            }
                            case 3: {
                                n9 = 6;
                                break;
                            }
                            default: {
                                n9 = 70;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "j\rtg*J\u0007\"C\u0005\u0003\u0013po0B\u0017g&-F\u001a";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "j\rtg*J\u0007\"C\u0005\u0003\u0013po0B\u0017g&-F\u001a";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "s(AUe\u001b";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "q%A3\u007f\u0012V";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "j\rtg*J\u0007\"c(@\ffo(DCcj!L\u0011kr.NC8&";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "`\fwj\"\u0003\rmrfA\u0016kj\"\u0003&A&6V\u0001no%\u0003\bg\u007f";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "j\rtg*J\u0007\"C\u0005\u0003\u0013po0B\u0017g&-F\u001a";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

