/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECParameters;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKey
extends X509Key
implements java.security.interfaces.ECPublicKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962694L;
    private ECPoint w;
    private ECParameterSpec params;
    private static final String[] a;

    public ECPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public ECPublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.w = eCPoint;
        this.params = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(eCParameterSpec));
        this.key = ECParameters.encodePoint(eCPoint, this.params.getCurve());
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                throw new InvalidKeyException(a[1]);
            }
            this.params = ECUtils.getPrimeParameterSpec(algorithmParameters.getParameterSpec(ECParameterSpec.class));
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(a[2], iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(a[0], invalidParameterSpecException);
        }
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public void zeroize() {
        this.w = new ECPoint(BigInteger.ZERO, BigInteger.ZERO);
        this.params = null;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "mx_=\u0003Mr\t\u0019,\u0004}L%";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 36;
                                break;
                            }
                            case 1: {
                                n9 = 22;
                                break;
                            }
                            case 2: {
                                n9 = 41;
                                break;
                            }
                            case 3: {
                                n9 = 92;
                                break;
                            }
                            default: {
                                n9 = 111;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "aU\t8\u0000Iw@2OTw[=\u0002AbL.\u001c\u0004{\\/\u001b\u0004tL|\nJuF8\n@6@2OP~L|\u000eHqF.\u0006P~D|\u0006@sG(\u0006B\u007fL.";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "mx_=\u0003Mr\t\u0019,\u0004}L%";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

