/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import ibm.security.internal.spec.RFC5915ECPrivateKeyEncodedKeySpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static final String[] z;

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            return new ECPrivateKey(byArray);
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            ECParameterSpec eCParameterSpec = ((ECPrivateKeySpec)keySpec).getParams();
            BigInteger bigInteger = ((ECPrivateKeySpec)keySpec).getS();
            return new ECPrivateKey(bigInteger, eCParameterSpec);
        }
        if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
            return new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
        }
        try {
            throw new InvalidKeySpecException(z[14]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                return new ECPublicKey(byArray);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPublicKeySpec)keySpec).getParams();
                ECPoint eCPoint = ((ECPublicKeySpec)keySpec).getW();
                return new ECPublicKey(eCPoint, eCParameterSpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKey eCPrivateKey = new ECPrivateKey(byArray);
                return eCPrivateKey.getPublicKey();
            }
            if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
                ECPrivateKey eCPrivateKey = new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
                return eCPrivateKey.getPublicKey();
            }
            throw new InvalidKeySpecException(z[13]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            Class<T> clazz2;
            if (key instanceof java.security.interfaces.ECPrivateKey) {
                clazz2 = Class.forName(z[7]);
                Class<T> clazz3 = Class.forName(z[2]);
                Class<T> clazz4 = Class.forName(z[9]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams())));
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                }
                if (!clazz4.isAssignableFrom(clazz)) {
                    throw new InvalidKeySpecException(z[3]);
                }
                if (key instanceof ECPrivateKey) {
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(((ECPrivateKey)key).getEncoded(z[10]))));
                }
                try {
                    ECPrivateKey eCPrivateKey = new ECPrivateKey(key.getEncoded());
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(eCPrivateKey.getEncoded(z[0]))));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException.getMessage());
                }
            }
            if (key instanceof java.security.interfaces.ECPublicKey) {
                clazz2 = Class.forName(z[4]);
                Class<T> clazz5 = Class.forName(z[8]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams())));
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                throw new InvalidKeySpecException(z[5]);
            }
            throw new InvalidKeySpecException(z[6]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[1] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            block8: {
                block9: {
                    block6: {
                        block7: {
                            if (!(key instanceof java.security.interfaces.ECPrivateKey)) break block6;
                            if (!(key instanceof ECPrivateKey)) break block7;
                            return key;
                        }
                        ECPrivateKeySpec eCPrivateKeySpec = this.engineGetKeySpec(key, ECPrivateKeySpec.class);
                        return this.engineGeneratePrivate(eCPrivateKeySpec);
                    }
                    if (!(key instanceof java.security.interfaces.ECPublicKey)) break block8;
                    if (!(key instanceof ECPublicKey)) break block9;
                    return key;
                }
                ECPublicKeySpec eCPublicKeySpec = this.engineGetKeySpec(key, ECPublicKeySpec.class);
                return this.engineGeneratePublic(eCPublicKeySpec);
            }
            throw new InvalidKeyException(z[12]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[11] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u00168\u001a0\ruK";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                block25: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block25;
                    n5 = n5;
                    if (n5 <= n4) break block26;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 68;
                            break;
                        }
                        case 1: {
                            n6 = 126;
                            break;
                        }
                        case 2: {
                            n6 = 89;
                            break;
                        }
                        case 3: {
                            n6 = 5;
                            break;
                        }
                        default: {
                            n6 = 52;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0011\u0010*pD4\u0011+qQ ^2`Md\r)`W-\u00180fU0\u00176k\u000ed";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ".\u001f/d\u001a7\u001b:pF-\n +G4\u001b:+d\u000f=\n=q*\u001d6aQ 5<|g4\u001b:";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\r\u00108uD6\u0011)w]%\n<%_!\u0007yvD!\u001d0c]'\u001f-l[*";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ".\u001f/d\u001a7\u001b:pF-\n +G4\u001b:+q\u0007.,gX-\u001d\u0012`M\u0017\u000e<f";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\r\u00108uD6\u0011)w]%\n<%_!\u0007yvD!\u001d0c]'\u001f-l[*";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\r\u00108uD6\u0011)w]%\n<%_!\u0007yqM4\u001b";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ".\u001f/d\u001a7\u001b:pF-\n +G4\u001b:+q\u0007.+lB%\n<NQ=-)`W";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ".\u001f/d\u001a7\u001b:pF-\n +G4\u001b:+lqN`@Z'\u0011=`P\u000f\u001b VD!\u001d";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "-\u001c4+G!\u001d,w]0\u0007wlZ0\u001b+kU(P*uQ'P\u000bCwqGh0q\u0007.+lB%\n<NQ=;7f[ \u001b=NQ=-)`W";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u00168\u001a0\ruK";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0007\u001f7k[0^-wU*\r5d@!^2`M~^";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0013\f6kSd\u001f5b[6\u0017-mYd\n uQ";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0011\u0010*pD4\u0011+qQ ^2`Md\r)`W-\u00180fU0\u00176k";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0011\u0010*pD4\u0011+qQ ^2`Md\r)`W-\u00180fU0\u00176k";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

