/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.crypto.provider.a7;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[3]);
        }
        this.a = n2;
        this.b = secureRandom;
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.c = ECUtils.getPrimeParameterSpec((ECParameterSpec)algorithmParameterSpec);
            this.b = secureRandom;
            this.a = this.c.getCurve().getField().getFieldSize();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[0]);
        }
        this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
        if (this.c == null) {
            throw new InvalidAlgorithmParameterException(z[1]);
        }
        this.b = secureRandom;
        this.a = this.c.getCurve().getField().getFieldSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[2]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            PrimeCurve primeCurve = ECUtils.getPrimeCurve(this.c.getCurve());
            ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger), primeCurve.toEllipticPoint(this.c.getGenerator())).getAffine();
            ECPublicKey eCPublicKey = new ECPublicKey(eCPoint, this.c);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c, eCPublicKey);
            return new KeyPair(eCPublicKey, eCPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                PrimeField primeField = ECUtils.getField(192, a7.a, true);
                Object var2_6 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, a7.E.mod(a7.a), a7.c, 1);
                this.c = new ECParameterSpec(primeCurve, a7.f, a7.b, 1);
                break;
            }
            case 224: {
                PrimeField primeField = ECUtils.getField(224, a7.g, true);
                Object var2_7 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, a7.E.mod(a7.g), a7.i, 1);
                this.c = new ECParameterSpec(primeCurve, a7.l, a7.h, 1);
                break;
            }
            case 256: {
                PrimeField primeField = ECUtils.getField(256, a7.m, true);
                Object var2_8 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, a7.E.mod(a7.m), a7.o, 1);
                this.c = new ECParameterSpec(primeCurve, a7.r, a7.n, 1);
                break;
            }
            case 384: {
                PrimeField primeField = ECUtils.getField(384, a7.s, true);
                Object var2_9 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, a7.E.mod(a7.s), a7.u, 1);
                this.c = new ECParameterSpec(primeCurve, a7.x, a7.t, 1);
                break;
            }
            case 521: {
                PrimeField primeField = ECUtils.getField(521, a7.y, true);
                Object var2_10 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, a7.E.mod(a7.y), a7.A, 1);
                this.c = new ECParameterSpec(primeCurve, a7.D, a7.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "u\u001fj7\u001fV^u#\u0001Q^z3RL\u0010k\"\u0013K\u001d}v\u001dC^]\u0015\"D\fy;\u0017Q\u001bj\u0005\u0002@\u001d89\u0000\u0005;[\u0011\u0017K.y$\u0013H\u001bl3\u0000v\u000e}5";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 37;
                            break;
                        }
                        case 1: {
                            n6 = 126;
                            break;
                        }
                        case 2: {
                            n6 = 24;
                            break;
                        }
                        case 3: {
                            n6 = 86;
                            break;
                        }
                        default: {
                            n6 = 114;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "f\u000bj \u0017\u0005\u0010y;\u0017\u0005\u0010w\"RW\u001b{9\u0015K\u0017b3\u0016\u0005\u0011jv\u001cJ\n8%\u0007U\u000ew$\u0006@\u001a";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "l<U\u0005\u0017F\u000bj3 D\u0010|9\u001f";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "u\fq;\u0017\u0005\rq,\u0017\u0005\u0013m%\u0006\u0005\u001c}v\u001dK\u001b89\u0014\u001f^)o@\t^*dF\t^*cD\t^+nF\t^-dC";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

