/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    private int b = 2048;
    SecureRandom c = null;
    private static final String[] z;

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        block17: {
            int n2;
            block16: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidAlgorithmParameterException(z[3]);
                }
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                n2 = rSAKeyGenParameterSpec.getKeysize();
                this.a = rSAKeyGenParameterSpec.getPublicExponent();
                this.c = secureRandom;
                if (n2 % 8 != 0) {
                    throw new InvalidAlgorithmParameterException(z[5]);
                }
                try {
                    RSAKeyFactory.checkKeyLengths(n2, this.a, 512, 65536);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidAlgorithmParameterException(z[1], invalidKeyException);
                }
                this.b = n2;
                if (this.a != null) break block16;
                this.a = RSAKeyGenParameterSpec.F4;
                break block17;
            }
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[4]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[2]);
            }
        }
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[9]);
        }
        try {
            RSAKeyFactory.checkKeyLengths(n2, RSAKeyGenParameterSpec.F4, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(invalidKeyException.getMessage());
        }
        this.b = n2;
        this.c = secureRandom;
        this.a = RSAKeyGenParameterSpec.F4;
    }

    public void initialize(int n2) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[7]);
        }
        this.b = n2;
        try {
            this.c = SecureRandom.getInstance(z[8]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.c = new SecureRandom();
        }
        this.a = RSAKeyGenParameterSpec.F4;
        try {
            RSAKeyFactory.checkKeyLengths(this.b, this.a, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(z[6]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger4;
        int n2;
        if (this.c == null) {
            this.c = null;
            try {
                this.c = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.c = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger4 = (bigInteger6 = new BigInteger(this.b / 2, 10, this.c)).multiply(bigInteger5 = new BigInteger(this.b / 2, 10, this.c))).bitLength()) != this.b || !bigInteger7.gcd(bigInteger = (bigInteger3 = bigInteger6.subtract(BigInteger.ONE)).multiply(bigInteger2 = bigInteger5.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger5.modInverse(bigInteger6);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger4, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger4, bigInteger8, bigInteger7, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "n;\u0016\nbD\f)<UF\u0017?6j";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 39;
                            break;
                        }
                        case 1: {
                            n6 = 121;
                            break;
                        }
                        case 2: {
                            n6 = 91;
                            break;
                        }
                        case 3: {
                            n6 = 89;
                            break;
                        }
                        default: {
                            n6 = 7;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "n\u0017-8kN\u001d{2b^Y(0}B\n";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "w\f95nDY>!wH\u0017>7s\u0007\u0014.*s\u0007\u001b>ytJ\u001875bUY/1fIY0<~\u0007\n2#b";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "w\u0018)8jTY6,tSY9<'N\u0017(-fI\u001a>yhAY\t\nFl\u001c\"\u001ebI):+fJ\u001c/<ut\t>:";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "w\f95nDY>!wH\u0017>7s\u0007\u0014.*s\u0007\u001b>y4\u0007\u0016)ykF\u000b<<u";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "j\u0016?,kR\n{*n]\u001c{4rT\r{;b\u0007\u0014.5sN\t7<'H\u001f{a";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "n\u0017-8kN\u001d{2b^Y(0}B\n";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "j\u0016?,kR\n{*n]\u001c{4rT\r{;b\u0007\u0014.5sN\t7<'H\u001f{a";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "n;\u0016\nbD\f)<UF\u0017?6j";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "j\u0016?,kR\n{*n]\u001c{4rT\r{;b\u0007\u0014.5sN\t7<'H\u001f{a";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

