/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;

public class RSAPSSSignature
extends SignatureSpi {
    protected SecureRandom a;
    double b = 0.0;
    private int c;
    private double d;
    private MessageDigest e;
    private MessageDigest f;
    private boolean g;
    private RSAPadding h;
    private RSAPrivateKey i;
    private RSAPublicKey j;
    PSSParameterSpec k = PSSParameterSpec.DEFAULT;
    private static final String[] z;

    RSAPSSSignature(PSSParameterSpec pSSParameterSpec) {
        try {
            this.engineSetParameter(pSSParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public RSAPSSSignature() {
        this(new PSSParameterSpec(z[24], z[25], MGF1ParameterSpec.SHA1, 20, 1));
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.i = null;
        this.j = rSAPublicKey;
        this.a = JCAUtil.getSecureRandom();
        this.b = rSAPublicKey.getModulus().bitLength();
        this.d = this.b - 1.0;
        this.c = (int)Math.ceil(this.d / 8.0);
        this.a(rSAPublicKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a = JCAUtil.getSecureRandom();
        this.engineInitSign(privateKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.b = rSAPrivateKey.getModulus().bitLength();
        this.d = this.b - 1.0;
        this.c = (int)Math.ceil(this.d / 8.0);
        this.i = rSAPrivateKey;
        this.j = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.h = RSAPadding.getInstance(5, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        this.a();
    }

    private void a() {
        this.e.reset();
        this.g = true;
    }

    private byte[] b() {
        this.g = true;
        return this.e.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.e.update(by);
        this.g = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.e.update(byArray, n2, n3);
        this.g = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.e.update(byteBuffer);
        this.g = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = this.encodeSignature(byArray);
            byte[] byArray3 = RSACore.rsa(byArray2, this.i);
            int n2 = ((int)this.b + 7) / 8;
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[19], generalSecurityException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.j)) {
            throw new SignatureException(z[17] + byArray.length + z[16] + RSACore.getByteLength(this.j));
        }
        int n2 = ((int)this.b + 7) / 8;
        if (byArray.length != n2) {
            throw new SignatureException(z[13] + byArray.length + z[15] + RSACore.getByteLength(this.j));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.j);
            byte[] byArray4 = this.h.unpad(byArray3);
            if (byArray4.length > this.c) {
                return false;
            }
            if (byArray4.length < this.c) {
                byte[] byArray5 = new byte[this.c];
                System.arraycopy(byArray4, 0, byArray5, this.c - byArray4.length, byArray4.length);
                byArray4 = byArray5;
            }
            boolean bl = this.decodeSignature(byArray4, byArray2);
            return bl;
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[14], iOException);
        }
    }

    public byte[] encodeSignature(byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        if (this.c < byArray.length + this.k.getSaltLength() + 2) {
            throw new SecurityException(z[6]);
        }
        byte[] byArray2 = new byte[this.k.getSaltLength()];
        this.a.nextBytes(byArray2);
        byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray4 = new byte[8 + byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + byArray.length, byArray2.length);
        this.e.reset();
        this.e.update(byArray4);
        byte[] byArray5 = this.e.digest();
        int n3 = this.c - byArray5.length - byArray2.length - 2;
        byte[] byArray6 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray6[n2] = 0;
        }
        byte[] byArray7 = new byte[this.c - byArray5.length - 1];
        if (n3 > 0) {
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        }
        byArray7[n2++] = 1;
        System.arraycopy(byArray2, 0, byArray7, n2, byArray2.length);
        byte[] byArray8 = new byte[n3 + 1 + byArray2.length];
        byArray8 = this.a(byArray5, byArray8.length);
        byte[] byArray9 = new byte[n3 + 1 + byArray2.length];
        int n4 = 0;
        for (byte by : byArray8) {
            byArray9[n4] = (byte)(by ^ byArray7[n4++]);
        }
        int n5 = 8 * this.c - (int)this.d;
        if (n5 > 0) {
            int n6 = (byte)(255 >>> n5);
            byArray9[0] = (byte)(byArray9[0] & n6);
        }
        byte[] byArray10 = new byte[this.c];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray5, 0, byArray10, byArray9.length, byArray5.length);
        byArray10[byArray9.length + byArray5.length] = -68;
        return byArray10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decodeSignature(byte[] byArray, byte[] byArray2) throws IOException, SignatureException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        byte by2;
        if (this.c < byArray2.length + 2 + this.k.getSaltLength()) {
            throw new SecurityException(z[4]);
        }
        byte by = byArray[this.c - 1];
        if ((by ^ 0xBC) == 0) {
            throw new SecurityException(z[3]);
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, 0, this.c - byArray2.length - 1);
        byte[] byArray4 = Arrays.copyOfRange(byArray, byArray5.length, this.c - 1);
        int n3 = 8 * this.c - (int)this.d;
        int n4 = 8 - n3;
        if (n4 > 0 && (byArray5[0] & (by2 = (byte)(255 << n4))) != 0) {
            throw new SignatureException(z[2]);
        }
        byte[] byArray6 = new byte[this.c - byArray4.length - 1];
        byArray6 = this.a(byArray4, byArray6.length);
        byte[] byArray3 = new byte[byArray6.length];
        int n5 = 0;
        byte[] byArray7 = byArray6;
        int n6 = byArray7.length;
        for (int i2 = 0; i2 < n6; ++n5, ++i2) {
            byte by3 = byArray7[i2];
            byArray3[n5] = (byte)(by3 ^ byArray5[n5]);
        }
        n3 = 8 * this.c - (int)this.d;
        if (n3 > 0) {
            byte by4 = (byte)(255 >>> n3);
            byArray3[0] = (byte)(byArray3[0] & by4);
        }
        if ((n2 = this.c - byArray4.length - this.k.getSaltLength() - 2) > 0) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (byArray3[n6] == 0) continue;
                throw new SecurityException(z[5]);
            }
        }
        if (byArray3[n2] != 1) {
            throw new SecurityException(z[1]);
        }
        byte[] byArray72 = Arrays.copyOfRange(byArray3, n2 + 1, byArray3.length);
        byte[] byArray8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray9 = new byte[8 + byArray2.length + byArray72.length];
        System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
        System.arraycopy(byArray2, 0, byArray9, byArray8.length, byArray2.length);
        System.arraycopy(byArray72, 0, byArray9, byArray8.length + byArray2.length, byArray72.length);
        this.e.reset();
        this.e.update(byArray9);
        byte[] byArray10 = this.e.digest();
        return MessageDigest.isEqual(byArray4, byArray10);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[12]);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[0]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.k = (PSSParameterSpec)algorithmParameterSpec;
        try {
            this.e = MessageDigest.getInstance(this.k.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException(noSuchAlgorithmException);
        }
        this.g = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, int n2) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException {
        String string = this.k.getDigestAlgorithm();
        String string2 = this.k.getMGFAlgorithm();
        if (!string2.equalsIgnoreCase(z[21])) {
            throw new InvalidAlgorithmParameterException(z[20] + string2);
        }
        String string3 = null;
        string3 = this.k.getMGFParameters() == null ? string : ((MGF1ParameterSpec)this.k.getMGFParameters()).getDigestAlgorithm();
        try {
            this.f = MessageDigest.getInstance(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(z[23] + string + z[22], noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[n2];
        int n3 = this.f.getDigestLength();
        int n4 = n2 / n3;
        if (n2 % n3 > 0) {
            ++n4;
        }
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[n3];
        int n5 = 0;
        while (n5 < n4) {
            byArray3[0] = (byte)(n5 >>> 24);
            byArray3[1] = (byte)(n5 >>> 16);
            byArray3[2] = (byte)(n5 >>> 8);
            byArray3[3] = (byte)n5;
            this.f.update(byArray, 0, byArray.length);
            this.f.update(byArray3);
            try {
                this.f.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw new BadPaddingException(digestException.toString());
            }
            for (int i2 = 0; i2 < byArray4.length && n5 * n3 + i2 < n2; ++i2) {
                byArray2[n5 * n3 + i2] = byArray4[i2];
            }
            ++n5;
        }
        return byArray2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws InvalidParameterException {
        AlgorithmParameters algorithmParameters = null;
        if (this.k == null) {
            return null;
        }
        try {
            algorithmParameters = AlgorithmParameters.getInstance(z[7], z[10]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new RuntimeException(z[8] + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(z[11]);
        }
        try {
            algorithmParameters.init(this.k);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            invalidParameterSpecException.printStackTrace();
            throw new RuntimeException(z[9] + invalidParameterSpecException.getMessage());
        }
        return algorithmParameters;
    }

    String a(byte[] byArray) {
        String string = z[18];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(string.charAt(n2 >> 4));
            stringBuffer.append(string.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[26];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "~\u0000k\u0001\u0010k\u0004r4\u0005|\u00177xQw\nkq\u0002l\u0015o>\u0003m\u0000{";
        int n3 = -1;
        block33: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                block36: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block36;
                    n5 = n5;
                    if (n5 <= n4) break block37;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 25;
                            break;
                        }
                        case 1: {
                            n6 = 101;
                            break;
                        }
                        case 2: {
                            n6 = 31;
                            break;
                        }
                        case 3: {
                            n6 = 81;
                            break;
                        }
                        default: {
                            n6 = 113;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "]\u0000|>\u0015p\u000bxq\u0014k\u0017p#";
                    n3 = 0;
                    continue block33;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "]\u0000|>\u0015p\u000bxq\u0014k\u0017p#";
                    n3 = 1;
                    continue block33;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "p\u000b|>\u001fj\fl%\u0014w\u0011?\"\u0018~\u000b~%\u0004k\u0000";
                    n3 = 2;
                    continue block33;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "p\u000b|>\u001fj\fl%\u0014w\u0011?\"\u0018~\u000b~%\u0004k\u0000";
                    n3 = 3;
                    continue block33;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "]\u0000|>\u0015p\u000bxq\u0014k\u0017p#";
                    n3 = 4;
                    continue block33;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "|\u000b|>\u0015p\u000bxq\u0014k\u0017p#";
                    n3 = 5;
                    continue block33;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "K6^\u0001\"J";
                    n3 = 6;
                    continue block33;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "W\n?\"\u0004z\r?0\u001d~\nm8\u0005q\b?";
                    n3 = 7;
                    continue block33;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "I6L\u0001\u0010k\u0004r4\u0005|\u0017L!\u0014zEq>\u00059\u0016j!\u0001v\u0017k4\u00159";
                    n3 = 8;
                    continue block33;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "P'R\u001b2\\";
                    n3 = 9;
                    continue block33;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "P'R\u001b2\\E|0\u001du\u0000{}Q{\u0010kq\u001fv\u0011?2\u001ew\u0003v6\u0004k\u0000{";
                    n3 = 10;
                    continue block33;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "j\u0000k\u0001\u0010k\u0004r4\u0005|\u00177xQw\nkq\u0002l\u0015o>\u0003m\u0000{";
                    n3 = 11;
                    continue block33;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "96v6\u001fx\u0011j#\u00149\tz?\u0016m\r??\u001emE|>\u0003k\u0000|%K9\u0002p%Q";
                    n3 = 12;
                    continue block33;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "J\fx?\u0010m\u0010m4Q|\u000b|>\u0015p\u000bxq\u0014k\u0017p#";
                    n3 = 13;
                    continue block33;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "9\u0007j%Qn\u0004lq\u0014a\u0015z2\u0005p\u000bxq";
                    n3 = 14;
                    continue block33;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "9\u0007j%Qn\u0004lq\u0014a\u0015z2\u0005p\u000bxq";
                    n3 = 15;
                    continue block33;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "96v6\u001fx\u0011j#\u00149\tz?\u0016m\r??\u001emE|>\u0003k\u0000|%K9\u0002p%Q";
                    n3 = 16;
                    continue block33;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = ")T-bE,S(iHx\u0007|5\u0014\u007f";
                    n3 = 17;
                    continue block33;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "Z\nj=\u00159\u000bp%Qj\fx?Q}\u0004k0";
                    n3 = 18;
                    continue block33;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "L\u000bl$\u0001i\nm%\u0014}ER\u001679\u0004s6\u001e#E";
                    n3 = 19;
                    continue block33;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "T\"Y`";
                    n3 = 20;
                    continue block33;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "9\u000bp%Qx\u0013~8\u001dx\u0007s4";
                    n3 = 21;
                    continue block33;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "]\fx4\u0002mE";
                    n3 = 22;
                    continue block33;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "J-^|@";
                    n3 = 23;
                    continue block33;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "T\"Y`";
                    n3 = 24;
                    continue block33;
                }
                case 24: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

