/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.RSACore;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSAPadding {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    public static final int PAD_ZERO = 5;
    private final int a;
    private final int b;
    private SecureRandom c;
    private final int d;
    private MessageDigest e;
    private MessageDigest f;
    private byte[] g;
    private static final Map<String, byte[]> h;
    private static final String[] z;

    public static RSAPadding getInstance(int n2, int n3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, null, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, oAEPParameterSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RSAPadding(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a = n2;
        this.b = n3;
        this.c = secureRandom;
        if (n3 < 64) {
            throw new InvalidKeyException(z[4]);
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.d = n3 - 11;
                return;
            }
            case 3: 
            case 5: {
                this.d = n3;
                return;
            }
            case 4: {
                String string = z[9];
                String string2 = z[6];
                byte[] byArray = null;
                try {
                    if (oAEPParameterSpec != null) {
                        string = oAEPParameterSpec.getDigestAlgorithm();
                        String string3 = oAEPParameterSpec.getMGFAlgorithm();
                        if (!string3.equalsIgnoreCase(z[13])) {
                            throw new InvalidAlgorithmParameterException(z[10] + string3);
                        }
                        string2 = ((MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters()).getDigestAlgorithm();
                        PSource pSource = oAEPParameterSpec.getPSource();
                        String string4 = pSource.getAlgorithm();
                        if (!string4.equalsIgnoreCase(z[11])) {
                            throw new InvalidAlgorithmParameterException(z[5] + string4);
                        }
                        byArray = ((PSource.PSpecified)pSource).getValue();
                    }
                    this.e = MessageDigest.getInstance(string);
                    this.f = MessageDigest.getInstance(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException(z[3] + string + z[8], noSuchAlgorithmException);
                }
                this.g = RSAPadding.a(this.e, byArray);
                int n4 = this.g.length;
                this.d = n3 - 2 - 2 * n4;
                if (this.d > 0) return;
                throw new InvalidKeyException(z[12] + string + z[7] + string2);
            }
        }
        throw new InvalidKeyException(z[14] + n2);
    }

    private static byte[] a(MessageDigest messageDigest, byte[] byArray) {
        byte[] byArray2;
        if (byArray == null || byArray.length == 0) {
            String string = messageDigest.getAlgorithm();
            byArray2 = h.get(string);
            if (byArray2 == null) {
                byArray2 = messageDigest.digest();
                h.put(string, byArray2);
            }
        } else {
            byArray2 = messageDigest.digest(byArray);
        }
        return byArray2;
    }

    public int getMaxDataSize() {
        return this.d;
    }

    public byte[] pad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        byte[] byArray2 = RSACore.convert(byArray, n2, n3);
        byte[] byArray3 = this.pad(byArray2);
        if (byArray2 != byArray) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] pad(byte[] byArray) throws BadPaddingException {
        if (byArray.length > this.d) {
            throw new BadPaddingException(z[1] + (this.d + 1) + z[2]);
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.a(byArray);
            }
            case 4: {
                return this.e(byArray);
            }
            case 5: {
                return this.b(byArray);
            }
        }
        throw new AssertionError();
    }

    public byte[] unpad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        byte[] byArray2 = RSACore.convert(byArray, n2, n3);
        byte[] byArray3 = this.unpad(byArray2);
        if (byArray2 != byArray) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] unpad(byte[] byArray) throws BadPaddingException {
        if (byArray.length != this.b) {
            throw new BadPaddingException(z[15]);
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.c(byArray);
            }
            case 4: {
                return this.f(byArray);
            }
            case 5: {
                return this.d(byArray);
            }
        }
        throw new AssertionError();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.b];
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        int n2 = this.b - 3 - byArray.length;
        int n3 = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = (byte)this.a;
        if (this.a == 1) {
            while (n2-- > 0) {
                byArray2[n3++] = -1;
            }
            return byArray2;
        } else {
            if (this.c == null) {
                this.c = JCAUtil.getSecureRandom();
            }
            byte[] byArray3 = new byte[64];
            int n4 = -1;
            while (n2-- > 0) {
                int n5;
                do {
                    if (n4 >= 0) continue;
                    this.c.nextBytes(byArray3);
                    n4 = byArray3.length - 1;
                } while ((n5 = byArray3[n4--] & 0xFF) == 0);
                byArray2[n3++] = (byte)n5;
            }
        }
        return byArray2;
    }

    private byte[] b(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.b];
        byte[] byArray3 = new byte[this.b - byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] c(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = 0;
        boolean bl = false;
        if (byArray[n3++] != 0) {
            bl = true;
        }
        if (byArray[n3++] != this.a) {
            bl = true;
        }
        int n4 = 0;
        while (n3 < byArray.length) {
            if ((n2 = byArray[n3++] & 0xFF) == 0 && n4 == 0) {
                n4 = n3;
            }
            if (n3 == byArray.length && n4 == 0) {
                bl = true;
            }
            if (this.a != 1 || n2 == 255 || n4 != 0) continue;
            bl = true;
        }
        n2 = byArray.length - n4;
        if (n2 > this.d) {
            bl = true;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n4, byArray3, 0, n2);
        BadPaddingException badPaddingException = new BadPaddingException(z[0]);
        if (bl) {
            throw badPaddingException;
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] d(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n5 = byArray[n2] & 0xFF;
            if (n5 == 0 || n3 != -1) continue;
            n3 = n2;
        }
        if (n3 == -1) {
            n3 = byArray.length > 0 ? byArray.length - 1 : 0;
        }
        n2 = byArray.length - n3;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n3, byArray3, 0, n2);
        return byArray3;
    }

    private byte[] e(byte[] byArray) throws BadPaddingException {
        if (this.c == null) {
            this.c = JCAUtil.getSecureRandom();
        }
        int n2 = this.g.length;
        byte[] byArray2 = new byte[n2];
        this.c.nextBytes(byArray2);
        byte[] byArray3 = new byte[this.b];
        int n3 = 1;
        int n4 = n2;
        System.arraycopy(byArray2, 0, byArray3, n3, n4);
        int n5 = n2 + 1;
        int n6 = byArray3.length - n5;
        int n7 = this.b - byArray.length;
        System.arraycopy(this.g, 0, byArray3, n5, n2);
        byArray3[n7 - 1] = 1;
        System.arraycopy(byArray, 0, byArray3, n7, byArray.length);
        this.a(byArray3, n3, n4, byArray3, n5, n6);
        this.a(byArray3, n5, n6, byArray3, n3, n4);
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] f(byte[] byArray) throws BadPaddingException {
        int n2;
        int n8;
        byte[] byArray2 = byArray;
        boolean bl = false;
        int n3 = this.g.length;
        if (byArray2[0] != 0) {
            bl = true;
        }
        int n4 = 1;
        int n5 = n3;
        int n6 = n3 + 1;
        int n7 = byArray2.length - n6;
        this.a(byArray2, n6, n7, byArray2, n4, n5);
        this.a(byArray2, n4, n5, byArray2, n6, n7);
        for (n8 = 0; n8 < n3; ++n8) {
            if (this.g[n8] == byArray2[n6 + n8]) continue;
            bl = true;
        }
        n8 = n6 + n3;
        int n9 = -1;
        for (n2 = n8; n2 < byArray2.length; ++n2) {
            byte by = byArray2[n2];
            if (n9 != -1 || by == 0) continue;
            if (by == 1) {
                n9 = n2;
                continue;
            }
            bl = true;
        }
        if (n9 == -1) {
            bl = true;
            n9 = byArray2.length - 1;
        }
        n2 = n9 + 1;
        byte[] byArray3 = new byte[n2 - n8];
        System.arraycopy(byArray2, n8, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray2.length - n2];
        System.arraycopy(byArray2, n2, byArray4, 0, byArray4.length);
        BadPaddingException badPaddingException = new BadPaddingException(z[16]);
        if (bl) {
            throw badPaddingException;
        }
        return byArray4;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6) throws BadPaddingException {
        var7_7 = new byte[4];
        var8_8 = new byte[this.f.getDigestLength()];
        block7: while (true) {
            if (var6_6 <= 0) {
                return;
            }
            this.f.update(var1_1, var2_2, var3_3);
            this.f.update(var7_7);
            try {
                this.f.digest(var8_8, 0, var8_8.length);
            }
            catch (DigestException var9_10) {
                throw new BadPaddingException(var9_10.toString());
            }
            var9_9 = 0;
            while (var9_9 < var8_8.length && var6_6 > 0) {
                v0 = var5_5++;
                var4_4[v0] = (byte)(var4_4[v0] ^ var8_8[var9_9++]);
                --var6_6;
            }
            if (var6_6 <= 0) continue;
            var9_9 = var7_7.length - 1;
            while (true) {
                v1 = --var9_9;
                var7_7[v1] = (byte)(var7_7[v1] + 1);
                if (var7_7[v1] == 0 && var9_9 > 0) ** break;
                continue block7;
            }
            break;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[17];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "-q\u001b\n\\\u0019`\u0011\u0017KIq\n\nJ\u001b";
        int n3 = -1;
        block24: while (true) {
            char[] cArray;
            block28: {
                int n4;
                int n5;
                block27: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block27;
                    n5 = n5;
                    if (n5 <= n4) break block28;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 105;
                            break;
                        }
                        case 1: {
                            n6 = 20;
                            break;
                        }
                        case 2: {
                            n6 = 120;
                            break;
                        }
                        case 3: {
                            n6 = 120;
                            break;
                        }
                        default: {
                            n6 = 37;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "-u\f\u0019\u0005\u0004a\u000b\f\u0005\u000bqX\u000bM\u0006f\f\u001dWI`\u0010\u0019KI";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Iv\u0001\f@\u001a";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "-}\u001f\u001dV\u001d4";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "9u\u001c\u001c@\r4\u000b\u0011_\f4\u0015\rV\u001d4\u001a\u001d\u0005\b`X\u0014@\bg\fX\u0013]";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "<z\u000b\rU\u0019{\n\f@\r4\b+J\u001cf\u001b\u001d\u0005\bx\u001f\u0017\u001fI";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ":\\9U\u0014";
                    n3 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "Iu\u0016\u001c\u0005$S>I";
                    n3 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "Iz\u0017\f\u0005\bb\u0019\u0011I\bv\u0014\u001d";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ":\\9U\u0014";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "<z\u000b\rU\u0019{\n\f@\r45?cIu\u0014\u001fJS4";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "9G\b\u001dF\u0000r\u0011\u001dA";
                    n3 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\"q\u0001XL\u001a4\f\u0017JIg\u0010\u0017W\u001d4\u001e\u0017WIq\u0016\u001bW\u0010d\f\u0011J\u00074\r\u000bL\u0007sX7d,D(\u0019A\r}\u0016\u001f\u0005\u001e}\f\u0010\u0005";
                    n3 = 11;
                    continue block24;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "$S>I";
                    n3 = 12;
                    continue block24;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = " z\u000e\u0019I\u0000pX\bD\rp\u0011\u0016BS4";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "-q\u001b\n\\\u0019`\u0011\u0017KIq\n\nJ\u001b";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "-q\u001b\n\\\u0019`\u0011\u0017KIq\n\nJ\u001b";
                    n3 = 15;
                    continue block24;
                }
                case 15: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        h = Collections.synchronizedMap(new HashMap());
    }
}

