/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkCASetUp;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public final class PkNewCertFactory {
    private PkNewCertFactory() {
        throw new UnsupportedOperationException();
    }

    public static PkNewCertificate newCert(String string, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
        return new PkNewCertImpl(string, x509CertificateArray, privateKey);
    }

    public static PkNewCertificate newCert(int n, String string, int n2, Date date, boolean bl, String string2, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
        return new PkNewCertImpl(n, string, n2, date, bl, string2, x509CertificateArray, privateKey);
    }

    public static PkNewCertificate newCert(int n, String string, int n2, Date date, boolean bl, String string2, KeyPair keyPair, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
        return new PkNewCertImpl(n, string, n2, date, bl, string2, keyPair, x509CertificateArray, privateKey);
    }

    public static PkNewCertificate newCert(int n, String string, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string2, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
        return new PkNewCertImpl(n, string, n2, date, bl, list, list2, list3, string2, x509CertificateArray, privateKey);
    }

    public static PkNewCertificate newCert(int n, String string, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
        return new PkNewCertImpl(n, string, n2, date, bl, list, list2, list3, string2, keyPair, x509CertificateArray, privateKey, false);
    }

    public static PkNewCertificate newCert(int n, String string, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair, X509Certificate[] x509CertificateArray, PrivateKey privateKey, boolean bl2) throws PkRejectionException {
        return new PkNewCertImpl(n, string, n2, date, bl, list, list2, list3, string2, keyPair, x509CertificateArray, privateKey, bl2);
    }

    private static final class PkNewCertImpl
    implements PkNewCertificate,
    PkConstants {
        private KeyPair newKey;
        private X509Certificate newCert;
        private Date notBefore;
        private X509Certificate[] newCertChain;
        private X509Certificate[] signingChain;
        private byte[] newKeyIdentifier = null;
        private static List<ObjectIdentifier> algList = new ArrayList<ObjectIdentifier>(16);
        private static final String DEFAULT_PROVIDER = "IBMJCE";
        private static final String DEFAULT_RNG = "IBMSecureRandom";
        private static final int DEFAULT_KEY_SIZE = 1024;
        private static final int DEFAULT_LIFETIME = 365;
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private static final Object className = "com.ibm.security.certclient.PkNewCertImpl";

        PkNewCertImpl(String string, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
            PrivateKey privateKey2 = privateKey;
            if (privateKey2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String string2 = privateKey2.getAlgorithm();
            X500Name x500Name = this.validSubject(string);
            this.notBefore = null;
            this.signingChain = this.validChain(x509CertificateArray);
            X500Name x500Name2 = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String string3 = this.signingChain[0].getSigAlgName();
            this.newKey = this.generateLocalKey(string2, 1024, DEFAULT_RNG, DEFAULT_PROVIDER);
            this.newCert = this.generatenewCertificate(2, string3, x500Name, x500Name2, this.newKey.getPublic(), 365, this.generateKID(false), null, null, null, DEFAULT_PROVIDER, false);
            this.newCertSign(string3, DEFAULT_PROVIDER, privateKey2);
        }

        PkNewCertImpl(int n, String string, int n2, Date date, boolean bl, String string2, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
            PrivateKey privateKey2 = privateKey;
            if (privateKey2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String string3 = privateKey2.getAlgorithm();
            X500Name x500Name = this.validSubject(string);
            this.notBefore = date;
            this.signingChain = this.validChain(x509CertificateArray);
            X500Name x500Name2 = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String string4 = this.signingChain[0].getSigAlgName();
            this.newKey = this.generateLocalKey(string3, n, DEFAULT_RNG, string2);
            this.newCert = this.generatenewCertificate(2, string4, x500Name, x500Name2, this.newKey.getPublic(), n2, this.generateKID(bl), null, null, null, string2, false);
            this.newCertSign(string4, string2, privateKey2);
        }

        PkNewCertImpl(int n, String string, int n2, Date date, boolean bl, String string2, KeyPair keyPair, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
            PrivateKey privateKey2 = privateKey;
            if (privateKey2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String string3 = privateKey2.getAlgorithm();
            X500Name x500Name = this.validSubject(string);
            this.notBefore = date;
            this.signingChain = this.validChain(x509CertificateArray);
            X500Name x500Name2 = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String string4 = this.signingChain[0].getSigAlgName();
            if (keyPair == null) {
                this.newKey = this.generateLocalKey(string3, n, DEFAULT_RNG, string2);
            } else {
                if (!keyPair.getPublic().getAlgorithm().equals(privateKey2.getAlgorithm())) {
                    if (debug != null) {
                        debug.text(0L, className, "PkNewCertImpl", "Keypair type not same as signer key {0}", (Object)keyPair.getPublic().getAlgorithm());
                    }
                    throw new PkRejectionException(PkNLSConstants.INVALID_KEY_TYPE);
                }
                this.newKey = keyPair;
            }
            this.newCert = this.generatenewCertificate(2, string4, x500Name, x500Name2, this.newKey.getPublic(), n2, this.generateKID(bl), null, null, null, string2, false);
            this.newCertSign(string4, string2, privateKey2);
        }

        PkNewCertImpl(int n, String string, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string2, X509Certificate[] x509CertificateArray, PrivateKey privateKey) throws PkRejectionException {
            PrivateKey privateKey2 = privateKey;
            if (privateKey2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String string3 = privateKey2.getAlgorithm();
            X500Name x500Name = this.validSubject(string);
            this.notBefore = date;
            this.signingChain = this.validChain(x509CertificateArray);
            X500Name x500Name2 = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String string4 = this.signingChain[0].getSigAlgName();
            this.newKey = this.generateLocalKey(string3, n, DEFAULT_RNG, string2);
            this.newCert = this.generatenewCertificate(2, string4, x500Name, x500Name2, this.newKey.getPublic(), n2, this.generateKID(bl), list, list2, list3, string2, false);
            this.newCertSign(string4, string2, privateKey2);
        }

        PkNewCertImpl(int n, String string, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair, X509Certificate[] x509CertificateArray, PrivateKey privateKey, boolean bl2) throws PkRejectionException {
            boolean bl3 = bl2;
            PrivateKey privateKey2 = privateKey;
            if (privateKey2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String string3 = privateKey2.getAlgorithm();
            X500Name x500Name = this.validSubject(string);
            this.notBefore = date;
            this.signingChain = this.validChain(x509CertificateArray);
            X500Name x500Name2 = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String string4 = this.signingChain[0].getSigAlgName();
            if (keyPair == null) {
                this.newKey = this.generateLocalKey(string3, n, DEFAULT_RNG, string2);
            } else {
                if (!keyPair.getPublic().getAlgorithm().equals(privateKey2.getAlgorithm())) {
                    if (debug != null) {
                        debug.text(0L, className, "PkNewCertImpl", "Keypair type not same as signer key {0}", (Object)keyPair.getPublic().getAlgorithm());
                    }
                    throw new PkRejectionException(PkNLSConstants.INVALID_KEY_TYPE);
                }
                this.newKey = keyPair;
            }
            this.newCert = this.generatenewCertificate(2, string4, x500Name, x500Name2, this.newKey.getPublic(), n2, this.generateKID(bl), list, list2, list3, string2, bl3);
            this.newCertSign(string4, string2, privateKey2);
        }

        private byte[] generateKID(boolean bl) throws PkRejectionException {
            try {
                byte[] byArray = PkCASetUp.computeKID(this.newKey.getPublic(), bl);
                if (debug != null) {
                    debug.text(0L, className, "generateKID", "Subject Key Identifier is {0}", (Object)byArray);
                }
                return byArray;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
        }

        private X500Name validSubject(String string) throws PkRejectionException {
            X500Name x500Name;
            try {
                x500Name = new X500Name(string);
                if (debug != null) {
                    debug.text(0L, className, "validSubject", "X500Name is {0}", (Object)x500Name);
                }
            }
            catch (IOException iOException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_SUBJECT_NAME, iOException);
            }
            return x500Name;
        }

        private X500Name validIssuer(String string) throws PkRejectionException {
            X500Name x500Name;
            try {
                x500Name = new X500Name(string);
                if (debug != null) {
                    debug.text(0L, className, "validIssuer", "X500Name is {0}", (Object)x500Name);
                }
            }
            catch (IOException iOException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_SUBJECT_NAME, iOException);
            }
            return x500Name;
        }

        private X509Certificate[] validChain(X509Certificate[] x509CertificateArray) throws PkRejectionException {
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                if (debug != null) {
                    debug.text(0L, className, "validCert", "Signing Cert is null");
                }
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE);
            }
            X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray2[i] = x509CertificateArray[i];
                if (x509CertificateArray2[i] != null) continue;
                if (debug != null) {
                    debug.text(0L, className, "validCert", "Signing Cert is null {0}", (Object)i);
                }
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE);
            }
            if (debug != null) {
                debug.text(0L, className, "validCert", "Signing Cert is {0}", (Object)x509CertificateArray2[0]);
            }
            return x509CertificateArray2;
        }

        private KeyPair generateLocalKey(String string, int n, String string2, String string3) throws PkRejectionException {
            KeyPair keyPair;
            int n2;
            String string4 = string3 == null || string3.length() == 0 ? DEFAULT_PROVIDER : string3;
            int n3 = n2 = n == 0 ? 1024 : n;
            if (!string.contains("EC") && n2 < 512) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + n);
            }
            if (debug != null) {
                debug.text(0L, className, "generateLocalKey", "Keytype is {0}", (Object)string);
                debug.text(0L, className, "generateLocalKey", "Provider is {0}", (Object)string4);
                debug.text(0L, className, "generateLocalKey", "KeySize is {0}", (Object)new Integer(n2));
            }
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string, string3);
                SecureRandom secureRandom = string2 == null || string2.length() == 0 ? SecureRandom.getInstance(string4) : SecureRandom.getInstance(string2, string4);
                if (debug != null) {
                    debug.text(0L, className, "generateLocalKey", "RNG is {0}", (Object)secureRandom);
                }
                keyPairGenerator.initialize(n, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, noSuchProviderException);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + n, invalidParameterException);
            }
            return keyPair;
        }

        private X509Certificate generatenewCertificate(int n, String string, X500Name x500Name, X500Name x500Name2, PublicKey publicKey, int n2, byte[] byArray, List<String> list, List<String> list2, List<String> list3, String string2, boolean bl) throws PkRejectionException {
            X509CertImpl x509CertImpl;
            BigInteger bigInteger;
            Date date;
            AlgorithmId algorithmId;
            String string3;
            X509CertInfo x509CertInfo = new X509CertInfo();
            if (debug != null) {
                debug.text(0L, className, "generatenewCertificate", "Version is {0}", (Object)new Integer(n));
            }
            if (n != 2) {
                throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_INVALID);
            }
            if (debug != null) {
                debug.text(0L, className, "generatenewCertificate", "Validity Period is {0}", (Object)new Integer(n2));
            }
            if (n2 <= 0) {
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            String string4 = string3 = string2 == null || string2.length() == 0 ? DEFAULT_PROVIDER : string2;
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Signing algorithm is {0}", (Object)string);
                debug.text(0L, className, "createSubjectAltName", "Provider is {0}", (Object)string3);
                debug.text(0L, className, "createSubjectAltName", "Issuer is {0}", (Object)x500Name2);
            }
            try {
                algorithmId = AlgorithmId.get((String)string, (String)string3);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
            ObjectIdentifier objectIdentifier = algorithmId.getOID();
            if (!algList.contains(objectIdentifier)) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM);
            }
            Date date2 = new Date();
            Date date3 = new Date();
            if (this.notBefore != null) {
                date = new Date();
                if (this.notBefore.getTime() < date.getTime() - 259200000L) {
                    throw new PkRejectionException("notBefore Time cannot exceed more than 3 days prior to the UTC time");
                }
                date2.setTime(this.notBefore.getTime());
                date3.setTime(this.notBefore.getTime());
            }
            date3.setTime(date3.getTime() + (long)(n2 * 24 * 60 * 60) * 1000L);
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Start date {0}", (Object)date2);
                debug.text(0L, className, "createSubjectAltName", "End date {0}", (Object)date3);
            }
            date = new CertificateValidity(date2, date3);
            CertificateExtensions certificateExtensions = new CertificateExtensions();
            try {
                SubjectAlternativeNameExtension subjectAlternativeNameExtension;
                x509CertInfo.set("version", (Object)new CertificateVersion(n));
                bigInteger = BigInteger.valueOf(System.nanoTime());
                x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber(bigInteger));
                x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
                x509CertInfo.set("subject", (Object)x500Name);
                x509CertInfo.set("issuer", (Object)x500Name2);
                x509CertInfo.set("key", (Object)new CertificateX509Key(publicKey));
                x509CertInfo.set("validity", (Object)date);
                if (list != null && list.size() > 0) {
                    subjectAlternativeNameExtension = this.createSubjectAltName(list);
                    certificateExtensions.set("x509.info.extensions.SubjectAlternativeName", (Object)subjectAlternativeNameExtension);
                }
                if (byArray != null) {
                    this.newKeyIdentifier = byArray;
                    subjectAlternativeNameExtension = new SubjectKeyIdentifierExtension(byArray);
                    certificateExtensions.set("x509.info.extensions.SubjectKeyIdentifier", (Object)subjectAlternativeNameExtension);
                }
                if (list2 != null && !list2.isEmpty()) {
                    subjectAlternativeNameExtension = this.setKeyUsageExt(list2);
                    certificateExtensions.set("x509.info.extensions.KeyUsage", (Object)subjectAlternativeNameExtension);
                }
                if (bl) {
                    subjectAlternativeNameExtension = new BasicConstraintsExtension(true, -1);
                    certificateExtensions.set("x509.info.extensions.BasicConstraints", (Object)subjectAlternativeNameExtension);
                }
                if (list3 != null && !list3.isEmpty()) {
                    subjectAlternativeNameExtension = this.setextKeyUsageExt(list3);
                    certificateExtensions.set("x509.info.extensions.ExtKeyUsage", (Object)subjectAlternativeNameExtension);
                }
                x509CertInfo.set("extensions", (Object)certificateExtensions);
            }
            catch (CertificateException certificateException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, certificateException);
            }
            catch (IOException iOException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, iOException);
            }
            catch (Exception exception) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, exception);
            }
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Raw certificate request created with serial {0}", (Object)bigInteger);
            }
            try {
                x509CertImpl = new X509CertImpl(x509CertInfo, string3);
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, certificateParsingException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, certificateEncodingException);
            }
            return x509CertImpl;
        }

        private KeyUsageExtension setKeyUsageExt(List<String> list) throws IOException, PkRejectionException {
            KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
            for (String string : list) {
                if (debug != null) {
                    debug.text(0L, className, "setKeyUsageExt", "Processing {0}", (Object)string);
                }
                if (string.equalsIgnoreCase("digital_signature")) {
                    keyUsageExtension.set("digital_signature", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("data_encipherment")) {
                    keyUsageExtension.set("data_encipherment", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("encipher_only")) {
                    keyUsageExtension.set("encipher_only", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("decipher_only")) {
                    keyUsageExtension.set("decipher_only", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("non_repudiation")) {
                    keyUsageExtension.set("non_repudiation", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("key_encipherment")) {
                    keyUsageExtension.set("key_encipherment", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("key_agreement")) {
                    keyUsageExtension.set("key_agreement", (Object)Boolean.TRUE);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            return keyUsageExtension;
        }

        private ExtKeyUsageExtension setextKeyUsageExt(List<String> list) throws IOException, PkRejectionException {
            ExtKeyUsageExtension extKeyUsageExtension = null;
            Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>();
            for (String string : list) {
                if (debug != null) {
                    debug.text(0L, className, "setextKeyUsageExt", "Processing {0}", (Object)string);
                }
                if (string.equalsIgnoreCase("ServerAuth_Id")) {
                    vector.add(PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("ClientAuth_Id")) {
                    vector.add(PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("CodeSigning_Id")) {
                    vector.add(PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("EmailProtection_Id")) {
                    vector.add(PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("IPSecEndSystem_Id")) {
                    vector.add(PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("IPSecTunnel_Id")) {
                    vector.add(PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("IPSecUser_Id")) {
                    vector.add(PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("TimeStamping_Id")) {
                    vector.add(PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            if (vector.size() > 0) {
                extKeyUsageExtension = new ExtKeyUsageExtension(vector);
            }
            return extKeyUsageExtension;
        }

        private byte[] getIPAddress(String string) {
            String[] stringArray = PkString.split(string, ".");
            byte[] byArray = new byte[]{new Integer(stringArray[0]).byteValue(), new Integer(stringArray[1]).byteValue(), new Integer(stringArray[2]).byteValue(), new Integer(stringArray[3]).byteValue()};
            return byArray;
        }

        private SubjectAlternativeNameExtension createSubjectAltName(List<String> list) throws Exception {
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
            if (list != null) {
                GeneralNames generalNames = new GeneralNames();
                boolean bl = false;
                int n = list.size();
                if (list.get(0) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", (Object)list.get(0));
                    }
                    generalNames.addElement((Object)new RFC822Name(list.get(0)));
                    bl = true;
                }
                if (n > 1 && list.get(1) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", (Object)list.get(1));
                    }
                    generalNames.addElement((Object)new DNSName(list.get(1)));
                    bl = true;
                }
                if (n > 2 && list.get(2) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", (Object)list.get(2));
                    }
                    generalNames.addElement((Object)new URIName(list.get(2)));
                    bl = true;
                }
                if (n > 3 && list.get(3) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", (Object)list.get(3));
                    }
                    generalNames.addElement((Object)new IPAddressName(this.getIPAddress(list.get(3))));
                    bl = true;
                }
                if (bl) {
                    subjectAlternativeNameExtension = new SubjectAlternativeNameExtension(generalNames);
                }
            } else if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "No subject Alt Names provided");
            }
            return subjectAlternativeNameExtension;
        }

        private void newCertSign(String string, String string2, PrivateKey privateKey) throws PkRejectionException {
            if (debug != null) {
                debug.text(0L, className, "newCertSign", "Signing with {0}", (Object)string);
            }
            try {
                ((X509CertImpl)this.newCert).sign(privateKey, string, string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE, invalidKeyException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, noSuchProviderException);
            }
            catch (SignatureException signatureException) {
                throw new PkRejectionException(PkNLSConstants.BAD_SS_CERT_SIGNATURE, signatureException);
            }
            catch (CertificateException certificateException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, certificateException);
            }
            if (debug != null) {
                debug.text(0L, className, "newCertSign", "Signed OK by provider {0}", (Object)string2);
            }
            this.newCertChain = new X509Certificate[this.signingChain.length + 1];
            System.arraycopy(this.signingChain, 0, this.newCertChain, 1, this.signingChain.length);
            this.newCertChain[0] = this.newCert;
        }

        @Override
        public PrivateKey getKey() {
            return this.newKey.getPrivate();
        }

        @Override
        public X509Certificate[] getCertificateChain() {
            return this.newCertChain;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.newKey.getPublic();
        }

        @Override
        public String getSubjectName() {
            return this.newCert.getSubjectDN().getName();
        }

        @Override
        public String getSigAlg() {
            return this.newCert.getSigAlgName();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.newKeyIdentifier;
        }

        @Override
        public void setToKeyStore(String string, String string2, KeyStore keyStore) throws PkException {
            if (string == null || string.length() == 0) {
                throw new PkException(PkNLSConstants.HTTP_BAD_OR_MISSING_ALIAS);
            }
            if (keyStore == null) {
                throw new PkException(PkNLSConstants.MISSING_KEYSTORE);
            }
            if (string2 == null || string2.length() == 0) {
                throw new PkException(PkNLSConstants.TUI_INVALIDPWD);
            }
            try {
                keyStore.setKeyEntry(string, this.newKey.getPrivate(), string2.toCharArray(), this.newCertChain);
            }
            catch (KeyStoreException keyStoreException) {
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE);
            }
        }

        static {
            algList.add(AlgorithmId.sha1WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithRSAEncryption_OIW_oid);
            algList.add(AlgorithmId.sha1WithDSA_oid);
            algList.add(AlgorithmId.sha1WithDSA_OIW_oid);
            algList.add(AlgorithmId.shaWithDSA_OIW_oid);
            algList.add(AlgorithmId.md5WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithECDSA_oid);
            algList.add(AlgorithmId.sha224WithECDSA_oid);
            algList.add(AlgorithmId.sha256WithECDSA_oid);
            algList.add(AlgorithmId.sha384WithECDSA_oid);
            algList.add(AlgorithmId.sha512WithECDSA_oid);
            algList.add(AlgorithmId.md2WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha256WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha384WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha512WithRSAEncryption_oid);
        }
    }
}

