/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class DSAPublicKey
extends X509Key
implements PKCS11DSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    private Session session = null;
    private Config config = null;
    private SessionManager sessionManager;
    static final long serialVersionUID = 4996119436080850303L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPublicKey";

    DSAPublicKey(Session session, PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken) throws InvalidKeyException {
        this.sessionManager = session.getSessionManager();
        this.object = object;
        this.label = label != null ? label : (String)this.getAttrValue(session, this.object, 3);
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getAttrValue(session, this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getAttrValue(session, this.object, 257);
        }
        this.isToken = (Boolean)this.getAttrValue(session, this.object, 1);
        this.isPrivate = (Boolean)this.getAttrValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(session, this.object, 368);
        this.startDate = (Date)this.getAttrValue(session, this.object, 272);
        this.endDate = (Date)this.getAttrValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(session, this.object, 355);
        this.isEncrypt = (Boolean)this.getAttrValue(session, this.object, 260);
        this.isVerifyRecover = (Boolean)this.getAttrValue(session, this.object, 267);
        this.isVerify = (Boolean)this.getAttrValue(session, this.object, 266);
        this.isWrap = (Boolean)this.getAttrValue(session, this.object, 262);
    }

    void setSession(Session sess) {
        this.session = sess;
    }

    public DSAPublicKey(Session session, PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken, BigInteger prime, BigInteger subprime, BigInteger base, BigInteger value) throws InvalidKeyException {
        this(session, object, ID, subject, label, isToken);
        if (prime != null) {
            this.prime = new BigInteger(prime.toByteArray());
        }
        if (subprime != null) {
            this.subprime = new BigInteger(subprime.toByteArray());
        }
        if (base != null) {
            this.base = new BigInteger(base.toByteArray());
        }
        if (value != null) {
            this.value = new BigInteger(value.toByteArray());
        }
        if (prime != null && subprime != null && base != null) {
            this.algid = new AlgIdDSA(prime, subprime, base);
        }
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode y: " + e.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DSAPublicKey(byte[] encoded, Session session, Config conf) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPublicKey", (Object)encoded);
        }
        this.decode(encoded);
        try {
            if (this.algid instanceof DSAParams) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "DSAPublicKey", (Object)this.algid);
                }
                DSAParams params = (DSAParams)this.algid;
                this.prime = ((DSAParameterSpec)params).getP();
                this.subprime = ((DSAParameterSpec)params).getQ();
                this.base = ((DSAParameterSpec)params).getG();
            } else {
                AlgorithmParameters algParams = this.algid.getAlgParameters();
                if (algParams == null) {
                    if (debug == null) throw new InvalidKeyException("A key could not be created from encoding");
                    debug.exit(16384L, (Object)className, "DSAPublicKey", null);
                    throw new InvalidKeyException("A key could not be created from encoding");
                }
                DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "DSAPublicKey", (Object)paramSpec);
                }
                this.prime = paramSpec.getP();
                this.subprime = paramSpec.getQ();
                this.base = paramSpec.getG();
            }
        }
        catch (InvalidParameterSpecException e) {
            if (debug == null) throw new InvalidKeyException(e.getMessage());
            debug.exception(16384L, (Object)className, "DSAPublicKey", (Throwable)e);
            debug.exit(16384L, (Object)className, "DSAPublicKey", null);
            throw new InvalidKeyException(e.getMessage());
        }
        this.label = conf != null ? this.genLabel(conf.getProviderNameSuffix()) : this.genLabel(null);
        int[] attrTypes = null;
        Object[] attrValues = null;
        HashMap<Integer, Object> hattrs = null;
        Set<Integer> keys = null;
        int numEles = 0;
        byte[] currentDSAValue = new byte[this.value.toByteArray().length];
        boolean useCurrentDSAValue = true;
        byte[] newDSAValue = null;
        System.arraycopy(this.value.toByteArray(), 0, currentDSAValue, 0, this.value.toByteArray().length);
        if (currentDSAValue.length == 129) {
            if (currentDSAValue[0] != 0) throw new InvalidKeyException("Invalid key value:  The DSA key contains 129 bytes and the most signifigant byte is not zero. \n");
            newDSAValue = new byte[currentDSAValue.length - 1];
            System.arraycopy(currentDSAValue, 1, newDSAValue, 0, currentDSAValue.length - 1);
            useCurrentDSAValue = false;
        } else if (currentDSAValue.length == 128) {
            useCurrentDSAValue = true;
        } else if (currentDSAValue.length < 128) {
            int numberOfMissingBytes = 128 - currentDSAValue.length;
            if ((currentDSAValue[0] & 0x80) != 0) {
                throw new InvalidKeyException("Invalid key value:  The DSA key contains less than 128 bytes and the most signifigant bit of the key is not zero. \n");
            }
            newDSAValue = new byte[currentDSAValue.length + numberOfMissingBytes];
            for (int j = 0; j < numberOfMissingBytes; ++j) {
                newDSAValue[j] = 0;
            }
            System.arraycopy(currentDSAValue, 0, newDSAValue, numberOfMissingBytes, currentDSAValue.length);
            useCurrentDSAValue = false;
        }
        if (conf != null) {
            hattrs = conf.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA);
            keys = hattrs.keySet();
            numEles = keys.size();
            attrTypes = new int[7 + numEles];
            attrValues = new Object[7 + numEles];
            attrTypes[0] = 0;
            attrTypes[1] = 256;
            attrTypes[2] = 3;
            attrTypes[3] = 304;
            attrTypes[4] = 305;
            attrTypes[5] = 306;
            attrTypes[6] = 17;
            attrValues[0] = PKCS11Object.PUBLIC_KEY;
            attrValues[1] = PKCS11Object.DSA;
            attrValues[2] = this.label;
            attrValues[3] = this.prime;
            attrValues[4] = this.subprime;
            attrValues[5] = this.base;
            attrValues[6] = !useCurrentDSAValue ? (Object)newDSAValue : (Object)this.value.toByteArray();
            Iterator<Integer> it = keys.iterator();
            int i = 1;
            while (it.hasNext()) {
                Integer key = it.next();
                attrTypes[6 + i] = key;
                attrValues[6 + i] = hattrs.get(key);
                ++i;
            }
        } else {
            attrTypes = new int[]{0, 256, 3, 1, 266, 304, 305, 306, 17};
            attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, this.label, Boolean.FALSE, Boolean.TRUE, this.prime, this.subprime, this.base, !useCurrentDSAValue ? newDSAValue : this.value.toByteArray()};
        }
        this.sessionManager = session.getSessionManager();
        this.object = session.createObject(attrTypes, attrValues);
        this.ID = (byte[])this.getAttrValue(session, this.object, 258);
        this.subject = (byte[])this.getAttrValue(session, this.object, 257);
        this.isToken = (Boolean)this.getAttrValue(session, this.object, 1);
        this.isPrivate = (Boolean)this.getAttrValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(session, this.object, 368);
        this.startDate = (Date)this.getAttrValue(session, this.object, 272);
        this.endDate = (Date)this.getAttrValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(session, this.object, 355);
        this.isEncrypt = (Boolean)this.getAttrValue(session, this.object, 260);
        this.isVerifyRecover = (Boolean)this.getAttrValue(session, this.object, 267);
        this.isVerify = (Boolean)this.getAttrValue(session, this.object, 266);
        this.isWrap = (Boolean)this.getAttrValue(session, this.object, 262);
        if (!session.getBoolAttributeValue(this.object, 1)) {
            session.addObject();
        }
        if (debug == null) return;
        debug.exit(16384L, (Object)className, "DSAPublicKey");
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parseKeyBits");
        }
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.value = in.getInteger();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "parseKeyBits", "Invalid key value");
            }
            throw new InvalidKeyException("Invalid key value\n" + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.object != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.session = null;
                this.object = null;
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.getToken().booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "finalize", "Free this DSAPublicKey object since it is a session key.");
                }
                this.rm();
                super.finalize();
            } else if (debug != null) {
                debug.text(16384L, (Object)className, "finalize", "Do NOT free this DSAPublicKey object since it is a token.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }

    @Override
    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    @Override
    public Integer getKeyType() {
        return this.keyType;
    }

    @Override
    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    @Override
    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    @Override
    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    @Override
    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    @Override
    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    @Override
    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    @Override
    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    @Override
    public Boolean getVerifyRecover() {
        return new Boolean(this.isVerifyRecover);
    }

    @Override
    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    @Override
    public BigInteger getPrime() {
        return this.prime;
    }

    @Override
    public BigInteger getSubprime() {
        return this.subprime;
    }

    @Override
    public BigInteger getBase() {
        return this.base;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public BigInteger getY() {
        return this.value;
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid == null) {
                return null;
            }
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " DSA Public Key: ";
        output = output + "\n Token: ";
        if (this.isToken != null) {
            output = output + this.isToken;
        }
        output = output + "\n Private: ";
        if (this.isPrivate != null) {
            output = output + this.isPrivate;
        }
        output = output + "\n Label: ";
        if (this.label != null) {
            output = output + this.label;
        }
        output = output + "\n Modifiable: ";
        if (this.isModifiable != null) {
            output = output + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        output = output + "\n ID: ";
        if (this.ID != null) {
            try {
                output = output + new String(this.ID, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                output = output + new String(this.ID);
            }
        }
        output = output + "\n Start Date: ";
        if (this.startDate != null) {
            output = output + this.startDate.toString();
        }
        output = output + "\n End Date: ";
        if (this.endDate != null) {
            output = output + this.endDate.toString();
        }
        output = output + "\n Derive: ";
        if (this.isDerive != null) {
            output = output + this.isDerive;
        }
        output = output + "\n Local: ";
        if (this.isLocal != null) {
            output = output + this.isLocal;
        }
        output = output + "\n Subject: ";
        if (this.subject != null) {
            try {
                X500Name x500name = new X500Name(this.subject);
                output = output + x500name.toString();
            }
            catch (IOException ex) {
                try {
                    UnstructuredName uname = new UnstructuredName(this.subject);
                    output = output + uname.toString();
                }
                catch (IOException ex2) {
                    try {
                        output = output + new String(this.subject, "8859_1");
                    }
                    catch (UnsupportedEncodingException e) {
                        output = output + new String(this.subject);
                    }
                }
            }
        }
        output = output + "\n Encrypt: ";
        if (this.isEncrypt != null) {
            output = output + this.isEncrypt;
        }
        output = output + "\n Verify: ";
        if (this.isVerify != null) {
            output = output + this.isVerify;
        }
        output = output + "\n VerifyRecover: ";
        if (this.isVerifyRecover != null) {
            output = output + this.isVerifyRecover;
        }
        output = output + "\n Wrap: ";
        if (this.isWrap != null) {
            output = output + this.isWrap;
        }
        output = output + "\n prime: ";
        if (this.prime != null) {
            output = output + this.prime.toString();
        }
        output = output + "\n subprime: ";
        if (this.subprime != null) {
            output = output + this.subprime.toString();
        }
        output = output + "\n base: ";
        if (this.base != null) {
            output = output + this.base.toString();
        }
        output = output + "\n value: ";
        if (this.value != null) {
            output = output + this.value.toString();
        }
        return output;
    }

    private Object getAttrValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    @Override
    public String getFormat() {
        return "PKCS#11";
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    private String genLabel(String providerSuffix) {
        byte[] labelName = new byte[32];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        String provName = null;
        provName = providerSuffix == null ? "IBMPKCS11Impl" : "IBMPKCS11Impl" + providerSuffix;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", provName);
            random.nextBytes(labelSaltData);
        }
        catch (Exception random) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 23) {
            labelLength = 23;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        String label = null;
        try {
            label = new String(labelName, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            label = new String(labelName);
        }
        return label;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

